/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle;

import com.google.common.base.Supplier;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.fx.particle.ParticleBase;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.gfx.OpenGlState;

@SideOnly(value=Side.CLIENT)
public class ParticleBillboard
extends ParticleBase {
    private static final Color B_COLOR = Color.getColor(TextFormatting.BLACK);
    private static final float B_COLOR_ALPHA = 0.5f;
    private static final Color F_COLOR = Color.getColor(TextFormatting.GOLD);
    private static final float F_COLOR_ALPHA = 0.99f;
    private static final Color F_COLOR_DEPTH = Color.getColor(TextFormatting.GRAY);
    private static final int MIN_TEXT_WIDTH = 60;
    private static final double BUBBLE_MARGIN = 4.0;
    private final float scale;
    private final Entity subject;
    private final Supplier<List<String>> accessor;
    private List<String> text;
    private int textWidth;
    private int numberOfMessages;
    private double top;
    private double bottom;
    private double left;
    private double right;
    private boolean canBeSeen;

    public ParticleBillboard(@Nonnull Entity entity, @Nonnull Supplier<List<String>> accessor) {
        super(entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        this.subject = entity;
        this.accessor = accessor;
        this.field_190017_n = false;
        this.updatePosition();
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.scale = 1.0f;
        this.canBeSeen = this.canBeSeen();
    }

    private boolean canBeSeen() {
        if (this.subject.func_98034_c(EnvironStateHandler.EnvironState.getPlayer())) {
            return false;
        }
        if (!EnvironStateHandler.EnvironState.getPlayer().func_70685_l(this.subject)) {
            return false;
        }
        double range = ModOptions.speechbubbles.speechBubbleRange * ModOptions.speechbubbles.speechBubbleRange;
        return EnvironStateHandler.EnvironState.getPlayer().func_70068_e(this.subject) <= range;
    }

    public boolean shouldExpire() {
        if (!this.func_187113_k() || !this.subject.func_70089_S()) {
            return true;
        }
        this.text = (List)this.accessor.get();
        return this.text == null || this.text.isEmpty();
    }

    private void updatePosition() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        AxisAlignedBB box = this.subject.func_174813_aQ();
        double newY = box.field_72337_e + (this.subject.func_70093_af() ? 0.25 : 0.5);
        this.func_187109_b(this.subject.field_70165_t, newY, this.subject.field_70161_v);
    }

    public void func_189213_a() {
        if (this.shouldExpire()) {
            this.func_187112_i();
        } else {
            this.updatePosition();
            this.canBeSeen = this.canBeSeen();
            if (this.canBeSeen) {
                this.textWidth = 60;
                for (String s : this.text) {
                    this.textWidth = Math.max(this.textWidth, this.font.func_78256_a(s));
                }
                this.numberOfMessages = this.text.size();
                this.top = (double)(-this.numberOfMessages * 9) - 4.0;
                this.bottom = 4.0;
                this.left = -((double)this.textWidth / 2.0 + 4.0);
                this.right = (double)this.textWidth / 2.0 + 4.0;
            }
        }
    }

    public void func_180434_a(VertexBuffer buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (this.text == null || this.text.isEmpty()) {
            return;
        }
        if (!this.canBeSeen) {
            return;
        }
        float pitch = this.manager.field_78732_j * (float)(this.isThirdPersonView() ? -1 : 1);
        float yaw = -this.manager.field_78735_i;
        float locX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - this.interpX());
        float locY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - this.interpY());
        float locZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - this.interpZ());
        OpenGlState glState = OpenGlState.push();
        GlStateManager.func_179109_b((float)locX, (float)locY, (float)locZ);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)((double)(-this.scale) * 0.015), (double)(-this.scale * 0.015f), (double)((double)this.scale * 0.015));
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.003662109f);
        float saveLightX = OpenGlHelper.lastBrightnessX;
        float saveLightY = OpenGlHelper.lastBrightnessY;
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179141_d();
        float red = ParticleBillboard.B_COLOR.red;
        float green = ParticleBillboard.B_COLOR.green;
        float blue = ParticleBillboard.B_COLOR.blue;
        float alpha = 0.5f;
        buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(this.left, this.top, 0.0).func_181666_a(red, green, blue, 0.5f).func_181675_d();
        buffer.func_181662_b(this.left, this.bottom, 0.0).func_181666_a(red, green, blue, 0.5f).func_181675_d();
        buffer.func_181662_b(this.right, this.top, 0.0).func_181666_a(red, green, blue, 0.5f).func_181675_d();
        buffer.func_181662_b(this.right, this.bottom, 0.0).func_181666_a(red, green, blue, 0.5f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.05f);
        int lines = this.numberOfMessages;
        for (int t = 0; t < this.numberOfMessages; ++t) {
            String str = this.text.get(t);
            int offset = -lines * 9;
            int margin = -this.font.func_78256_a(str) / 2;
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            this.font.func_78276_b(str, margin, offset, F_COLOR_DEPTH.rgbWithAlpha(0.99f));
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            this.font.func_78276_b(str, margin, offset, F_COLOR.rgbWithAlpha(0.99f));
            --lines;
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)saveLightX, (float)saveLightY);
        OpenGlState.pop(glState);
    }

    public int func_189214_a(float partialTick) {
        return this.subject.func_70070_b(partialTick);
    }

    public int func_70537_b() {
        return 3;
    }
}

