/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.fx.particle.ParticleBase;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public abstract class ParticleAsset
extends ParticleBase {
    protected float pitchRate;
    protected float yawRate;
    protected float rollRate;
    protected float currentPitch;
    protected float currentYaw;
    protected float currentRoll;
    protected float scale = 0.25f;
    protected boolean dieOnGround;

    public ParticleAsset(@Nonnull World world, double x, double y, double z) {
        this(world, x, y, z, 0.0, 0.0, 0.0);
    }

    public ParticleAsset(@Nonnull World world, double x, double y, double z, double dX, double dY, double dZ) {
        super(world, x, y, z, dX, dY, dZ);
        this.func_187115_a(0.25f, 0.25f);
        this.field_70545_g = 0.12f;
        this.dieOnGround = true;
        this.currentPitch = 360.0f * this.field_187136_p.nextFloat();
        this.currentYaw = 360.0f * this.field_187136_p.nextFloat();
        this.currentRoll = 360.0f * this.field_187136_p.nextFloat();
    }

    public void setDieOnGround(boolean flag) {
        this.dieOnGround = flag;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.func_187115_a(this.scale, this.scale);
    }

    public void setPitchRate(float rate) {
        this.pitchRate = rate;
    }

    public void setYawRate(float rate) {
        this.yawRate = rate;
    }

    public void setRollRate(float rate) {
        this.rollRate = rate;
    }

    public void setGravity(float grav) {
        this.field_70545_g = grav;
    }

    public void setMotion(float dX, float dY, float dZ) {
        this.field_187129_i = dX;
        this.field_187130_j = dY;
        this.field_187131_k = dZ;
    }

    protected boolean isOnGround() {
        if (this.field_187129_i == 0.0 && this.field_187130_j == 0.0 && this.field_187131_k == 0.0) {
            return true;
        }
        return !WorldUtils.isAirBlock(this.field_187122_b, new BlockPos(this.field_187126_f, this.field_187127_g - 1.0, this.field_187128_h));
    }

    public void func_189213_a() {
        if (this.field_187133_m) {
            return;
        }
        super.func_189213_a();
        if (this.dieOnGround && this.isOnGround()) {
            this.func_187112_i();
        }
        if (this.pitchRate != 0.0f) {
            this.currentPitch = MathStuff.wrapDegrees(this.currentPitch + this.pitchRate);
        }
        if (this.yawRate != 0.0f) {
            this.currentYaw = MathStuff.wrapDegrees(this.currentYaw + this.yawRate);
        }
        if (this.rollRate != 0.0f) {
            this.currentRoll = MathStuff.wrapDegrees(this.currentRoll + this.rollRate);
        }
    }

    protected abstract void handleRender(float var1);

    protected void doModelTranslate() {
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.5f);
    }

    protected ResourceLocation getTexture() {
        return TextureMap.field_110575_b;
    }

    public final void func_180434_a(VertexBuffer buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float x = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - this.interpX());
        float y = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - this.interpY());
        float z = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - this.interpZ());
        float pitch = MathStuff.wrapDegrees(this.currentPitch + this.pitchRate * partialTicks);
        float yaw = MathStuff.wrapDegrees(this.currentYaw + this.yawRate * partialTicks);
        float roll = MathStuff.wrapDegrees(this.currentRoll + this.rollRate * partialTicks);
        this.bindTexture(this.getTexture());
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179141_d();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        GlStateManager.func_179114_b((float)roll, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        int i = this.func_189214_a(partialTicks);
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        this.doModelTranslate();
        this.handleRender(partialTicks);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
    }

    public int func_70537_b() {
        return 3;
    }
}

