/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.fx.BlockEffectType;
import org.blockartistry.DynSurround.client.fx.JetEffect;
import org.blockartistry.DynSurround.client.fx.particle.system.ParticleFireJet;
import org.blockartistry.lib.chunk.IBlockAccessEx;

@SideOnly(value=Side.CLIENT)
public class FireJetEffect
extends JetEffect {
    public FireJetEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.FIRE_JET;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        boolean isAirBlock = provider.getBlockState(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()).func_185904_a() == Material.field_151579_a;
        return isAirBlock && super.canTrigger(provider, state, pos, random);
    }

    @Override
    public void doEffect(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        int lavaBlocks = FireJetEffect.countBlocks(provider, pos, state, -1);
        double spawnHeight = FireJetEffect.jetSpawnHeight(state, pos);
        ParticleFireJet effect = new ParticleFireJet(lavaBlocks, provider.getWorld(), (double)pos.func_177958_n() + 0.5, spawnHeight, (double)pos.func_177952_p() + 0.5);
        this.addEffect(effect);
    }
}

