/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.fx.particle.mote.ParticleCollection;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.lib.gfx.ParticleHelper;

@SideOnly(value=Side.CLIENT)
public class CollectionHelper {
    private final String name;
    private final ParticleCollection.ICollectionFactory factory;
    private final ResourceLocation texture;
    private WeakReference<ParticleCollection> collection;

    public CollectionHelper(@Nonnull String name, @Nonnull ResourceLocation texture) {
        this(name, ParticleCollection.FACTORY, texture);
    }

    public CollectionHelper(@Nonnull String name, @Nonnull ParticleCollection.ICollectionFactory factory, @Nonnull ResourceLocation texture) {
        this.name = name;
        this.texture = texture;
        this.factory = factory;
    }

    @Nonnull
    public String name() {
        return this.name;
    }

    @Nonnull
    public ParticleCollection get() {
        ParticleCollection pc;
        ParticleCollection particleCollection = pc = this.collection != null ? (ParticleCollection)((Object)this.collection.get()) : null;
        if (pc == null || !pc.func_187113_k() || pc.shouldDie()) {
            pc = this.factory.create(EnvironStateHandler.EnvironState.getWorld(), this.texture);
            this.collection = new WeakReference<ParticleCollection>(pc);
            ParticleHelper.addParticle(pc);
        }
        return pc;
    }

    public void clear() {
        ParticleCollection pc;
        ParticleCollection particleCollection = pc = this.collection != null ? (ParticleCollection)((Object)this.collection.get()) : null;
        if (pc != null) {
            pc.func_187112_i();
            this.collection = null;
        }
    }

    public String toString() {
        ParticleCollection pc;
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append('=');
        ParticleCollection particleCollection = pc = this.collection != null ? (ParticleCollection)((Object)this.collection.get()) : null;
        if (pc == null) {
            builder.append("No Collection");
        } else if (!pc.func_187113_k()) {
            builder.append("Expired");
        } else if (pc.shouldDie()) {
            builder.append("Should Die");
        } else {
            builder.append(pc.size());
        }
        return builder.toString();
    }
}

