/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.fx.BlockEffect;
import org.blockartistry.DynSurround.client.fx.BubbleJetEffect;
import org.blockartistry.DynSurround.client.fx.DustJetEffect;
import org.blockartistry.DynSurround.client.fx.FireFlyEffect;
import org.blockartistry.DynSurround.client.fx.FireJetEffect;
import org.blockartistry.DynSurround.client.fx.FountainJetEffect;
import org.blockartistry.DynSurround.client.fx.SteamJetEffect;
import org.blockartistry.DynSurround.client.fx.WaterSplashJetEffect;

public enum BlockEffectType {
    UNKNOWN("UNKNOWN", null){

        @Override
        public boolean isEnabled() {
            return false;
        }
    }
    ,
    SOUND("sound", null){

        @Override
        public boolean isEnabled() {
            return false;
        }
    }
    ,
    FIREFLY("firefly", (Class)FireFlyEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.block.effects.enableFireflies;
        }
    }
    ,
    STEAM_JET("steam", (Class)SteamJetEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.block.effects.enableSteamJets;
        }
    }
    ,
    FIRE_JET("fire", (Class)FireJetEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.block.effects.enableFireJets;
        }
    }
    ,
    BUBBLE_JET("bubble", (Class)BubbleJetEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.block.effects.enableBubbleJets;
        }
    }
    ,
    DUST_JET("dust", (Class)DustJetEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.block.effects.enableDustJets;
        }
    }
    ,
    FOUNTAIN_JET("fountain", (Class)FountainJetEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.block.effects.enableFountainJets;
        }
    }
    ,
    SPLASH_JET("splash", (Class)WaterSplashJetEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.block.effects.enableWaterSplash;
        }
    };

    private static final Map<String, BlockEffectType> typeMap;
    protected final String name;
    protected Constructor<?> factory;

    @Nonnull
    public static BlockEffectType get(@Nonnull String name) {
        BlockEffectType result = typeMap.get(name);
        return result == null ? UNKNOWN : result;
    }

    private BlockEffectType(String name, Class<?> clazz) {
        this.name = name;
        try {
            this.factory = clazz.getConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public abstract boolean isEnabled();

    @Nullable
    public BlockEffect getInstance(int chance) {
        if (this.factory != null) {
            try {
                return (BlockEffect)this.factory.newInstance(chance);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        typeMap = new HashMap<String, BlockEffectType>();
        for (BlockEffectType effect : BlockEffectType.values()) {
            typeMap.put(effect.getName(), effect);
        }
    }
}

