/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.system.accents;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientChunkCache;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.footsteps.implem.AcousticsManager;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IFootstepAccentProvider;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.weather.Weather;
import org.blockartistry.DynSurround.registry.BiomeInfo;
import org.blockartistry.DynSurround.registry.season.SeasonInfo;
import org.blockartistry.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class RainSplashAccent
implements IFootstepAccentProvider {
    protected final BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();

    @Override
    @Nonnull
    public String getName() {
        return "Rain Splash Accent";
    }

    @Override
    @Nonnull
    public ObjectArray<IAcoustic> provide(@Nonnull EntityLivingBase entity, @Nullable BlockPos blockPos, @Nonnull ObjectArray<IAcoustic> in) {
        if (ModOptions.sound.enablePuddleSound && Weather.isRaining() && EnvironStateHandler.EnvironState.isPlayer((Entity)entity)) {
            BiomeInfo biome;
            if (blockPos != null) {
                this.mutable.func_181079_c(blockPos.func_177958_n(), blockPos.func_177956_o() + 1, blockPos.func_177952_p());
            } else {
                this.mutable.func_189535_a((Entity)entity);
            }
            World world = entity.func_130014_f_();
            SeasonInfo season = ClientRegistry.SEASON.getData(world);
            int precipHeight = season.getPrecipitationHeight(world, (BlockPos)this.mutable).func_177956_o();
            if (precipHeight == this.mutable.func_177956_o() && (biome = ClientRegistry.BIOME.get(ClientChunkCache.INSTANCE.func_180494_b((BlockPos)this.mutable))).hasWeatherEffect() && !biome.getHasDust()) {
                this.mutable.func_185336_p(precipHeight);
                if (!season.canWaterFreeze(world, (BlockPos)this.mutable)) {
                    in.addAll((IAcoustic[])AcousticsManager.SPLASH);
                }
            }
        }
        return in;
    }
}

