/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.system.accents;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IFootstepAccentProvider;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.registry.ArmorClass;
import org.blockartistry.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class ArmorAccents
implements IFootstepAccentProvider {
    @Override
    @Nonnull
    public String getName() {
        return "Armor Accents";
    }

    @Override
    @Nonnull
    public ObjectArray<IAcoustic> provide(@Nonnull EntityLivingBase entity, @Nullable BlockPos pos, @Nonnull ObjectArray<IAcoustic> in) {
        ArmorClass foot;
        ArmorClass armor;
        if (EnvironStateHandler.EnvironState.isPlayer((Entity)entity)) {
            armor = EnvironStateHandler.EnvironState.getPlayerArmorClass();
            foot = EnvironStateHandler.EnvironState.getPlayerFootArmorClass();
        } else {
            armor = ArmorClass.effectiveArmorClass(entity);
            foot = ArmorClass.footArmorClass(entity);
        }
        IAcoustic armorAddon = ClientRegistry.FOOTSTEPS.getArmorAcoustic(armor);
        IAcoustic footAddon = ClientRegistry.FOOTSTEPS.getFootArmorAcoustic(foot);
        if (armorAddon != null || footAddon != null) {
            if (armorAddon == footAddon) {
                footAddon = null;
            }
            in.add(armorAddon);
            in.add(footAddon);
        }
        return in;
    }
}

