/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.system;

import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.client.footsteps.implem.PendingSound;
import org.blockartistry.DynSurround.client.footsteps.interfaces.EventType;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IOptions;
import org.blockartistry.DynSurround.client.footsteps.interfaces.ISoundPlayer;
import org.blockartistry.DynSurround.client.footsteps.system.Association;
import org.blockartistry.DynSurround.client.handlers.SoundEffectHandler;
import org.blockartistry.DynSurround.client.sound.BasicSound;
import org.blockartistry.DynSurround.client.sound.FootstepSound;
import org.blockartistry.DynSurround.registry.Variator;
import org.blockartistry.lib.MCHelper;
import org.blockartistry.lib.TimeUtils;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.collections.ObjectArray;
import org.blockartistry.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class SoundPlayer
implements ISoundPlayer {
    protected final Random random = XorShiftRandom.current();
    protected final ObjectArray<PendingSound> pending = new ObjectArray();
    protected final Variator var;

    public SoundPlayer(@Nonnull Variator var) {
        this.var = var;
    }

    public void playAcoustic(@Nonnull EntityLivingBase entity, @Nonnull Association assoc, @Nonnull EventType event) {
        if (assoc.getNoAssociation()) {
            this.playStep(entity, assoc, event);
        } else {
            this.playAcoustic(entity, assoc.getData(), event, null);
        }
    }

    private void logAcousticPlay(@Nonnull IAcoustic[] acoustics, @Nonnull EventType event) {
        if (DSurround.log().isDebugging()) {
            String txt = String.join((CharSequence)",", (CharSequence[])Arrays.stream(acoustics).map(IAcoustic::getAcousticName).toArray(String[]::new));
            DSurround.log().debug("Playing acoustic %s for event %s", txt, event.toString().toUpperCase());
        }
    }

    public void playAcoustic(@Nonnull EntityLivingBase entity, @Nonnull IAcoustic[] acoustics, @Nonnull EventType event, @Nullable IOptions inputOptions) {
        if (acoustics != null) {
            this.logAcousticPlay(acoustics, event);
            for (int i = 0; i < acoustics.length; ++i) {
                acoustics[i].playSound(this, entity, event, inputOptions);
            }
        }
    }

    protected void playStep(@Nonnull EntityLivingBase entity, @Nonnull Association assoc, @Nonnull EventType event) {
        SoundType soundType = assoc.getSoundType();
        if (soundType != null && !assoc.isLiquid()) {
            IBlockState upState = WorldUtils.getBlockState(entity.func_130014_f_(), assoc.getPos().func_177984_a());
            if (upState.func_177230_c() == Blocks.field_150431_aC) {
                soundType = MCHelper.getSoundType(upState);
            }
            SoundEvent se = event == EventType.LAND ? soundType.func_185842_g() : soundType.func_185844_d();
            this.actuallyPlaySound(entity, se, soundType.func_185843_a(), soundType.func_185847_b(), true);
        }
    }

    @Override
    public void playSound(@Nonnull EntityLivingBase entity, @Nonnull SoundEvent sound2, float volume, float pitch, @Nullable IOptions options) {
        if (options != null && options.isDelayedSound()) {
            long delay = TimeUtils.currentTimeMillis() + this.randAB(this.random, options.getDelayMin(), options.getDelayMax());
            this.pending.add(new PendingSound(entity, sound2, volume, pitch, delay, options.getDelayMax()));
        } else {
            this.actuallyPlaySound(entity, sound2, volume, pitch, false);
        }
    }

    protected void actuallyPlaySound(@Nonnull EntityLivingBase entity, @Nonnull SoundEvent sound2, float volume, float pitch, boolean noScale) {
        try {
            FootstepSound s = (FootstepSound)((FootstepSound)new FootstepSound((Entity)entity, sound2).setVolume(volume * this.var.VOLUME_SCALE)).setPitch(pitch);
            if (noScale) {
                s.setVolumeScale(BasicSound.DEFAULT_SCALE);
            }
            SoundEffectHandler.INSTANCE.playSound(s);
        }
        catch (Throwable t) {
            DSurround.log().error("Unable to play sound", t);
        }
    }

    @Override
    public Random getRNG() {
        return this.random;
    }

    public void think() {
        long time = TimeUtils.currentTimeMillis();
        this.pending.removeIf(sound2 -> {
            if (sound2.getTimeToPlay() <= time) {
                if (!sound2.isLate(time)) {
                    sound2.playSound(this);
                }
                return true;
            }
            return false;
        });
    }

    private long randAB(@Nonnull Random rng, long a, long b) {
        return a >= b ? a : a + (long)rng.nextInt((int)(b + 1L));
    }
}

