/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.system;

import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.footsteps.implem.AcousticsManager;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.lib.MCHelper;
import org.blockartistry.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class Association {
    private final IBlockState state;
    private final BlockPos pos;
    private final ObjectArray<IAcoustic> data = new ObjectArray(8);
    private final boolean isNotEmitter;

    public Association() {
        this(AcousticsManager.EMPTY);
    }

    public Association(@Nonnull IAcoustic[] association) {
        this(null, null, association);
    }

    public Association(@Nonnull IBlockState state, @Nonnull BlockPos pos) {
        this(state, pos, AcousticsManager.EMPTY);
    }

    public Association(@Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull IAcoustic[] association) {
        this.state = state;
        this.pos = pos;
        this.data.addAll((IAcoustic[])(association == null ? AcousticsManager.EMPTY : association));
        this.isNotEmitter = association == AcousticsManager.NOT_EMITTER;
    }

    @Nonnull
    public IAcoustic[] getData() {
        return this.data.toArray((IAcoustic[])new IAcoustic[0]);
    }

    @Nonnull
    public boolean getNoAssociation() {
        return this.data.size() == 0;
    }

    public boolean isLiquid() {
        return this.state != null && this.state.func_185904_a().func_76224_d();
    }

    public SoundType getSoundType() {
        return this.state != null ? MCHelper.getSoundType(this.state) : null;
    }

    public void add(@Nonnull IAcoustic acoustics) {
        this.data.add(acoustics);
    }

    public void add(@Nonnull IAcoustic[] acoustics) {
        this.data.addAll((IAcoustic[])acoustics);
    }

    public void add(@Nonnull Collection<? extends IAcoustic> collection) {
        this.data.addAll((Collection<IAcoustic>)collection);
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isNotEmitter() {
        return this.isNotEmitter;
    }
}

