/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.implem;

import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.footsteps.interfaces.ISoundPlayer;

@SideOnly(value=Side.CLIENT)
public class PendingSound {
    private static final float LATENESS_SLACK_FACTOR = 1.2f;
    private final EntityLivingBase location;
    private final SoundEvent sound;
    private final float volume;
    private final float pitch;
    private final long timeToPlay;
    private final long maximum;
    private final float lateTolerance;

    public PendingSound(@Nonnull EntityLivingBase location, @Nonnull SoundEvent sound2, float volume, float pitch, long timeToPlay, long maximum) {
        this.location = location;
        this.sound = sound2;
        this.volume = volume;
        this.pitch = pitch;
        this.timeToPlay = timeToPlay;
        this.maximum = maximum;
        this.lateTolerance = (float)maximum * 1.2f;
    }

    public void playSound(@Nonnull ISoundPlayer player2) {
        player2.playSound(this.location, this.sound, this.volume, this.pitch, null);
    }

    public long getTimeToPlay() {
        return this.timeToPlay;
    }

    public long getMaximumBase() {
        return this.maximum;
    }

    public float getLateTolerance() {
        return this.lateTolerance;
    }

    public boolean isLate(long time) {
        if (this.maximum < 0L) {
            return false;
        }
        return (float)(time - this.timeToPlay) > this.lateTolerance;
    }

    public long howLate(long time) {
        return time - this.timeToPlay;
    }
}

