/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.implem;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.footsteps.implem.AcousticProfile;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.DynSurround.registry.BlockInfo;

@SideOnly(value=Side.CLIENT)
public final class BlockAcousticMap {
    protected static final BlockInfo.BlockInfoMutable key = new BlockInfo.BlockInfoMutable();
    protected final IAcousticResolver resolver;
    protected Map<BlockInfo, AcousticProfile> data = new HashMap<BlockInfo, AcousticProfile>();
    protected Map<IBlockState, AcousticProfile> cache = new IdentityHashMap<IBlockState, AcousticProfile>();

    public BlockAcousticMap() {
        this(null);
    }

    public BlockAcousticMap(@Nonnull IAcousticResolver resolver) {
        this.resolver = resolver;
        this.data.put(BlockInfo.AIR, AcousticProfile.Static.NOT_EMITTER);
    }

    @Nonnull
    protected AcousticProfile cacheMiss(@Nonnull IBlockState state) {
        AcousticProfile result = this.data.get(key.set(state));
        if (result != null) {
            return result;
        }
        if (key.hasSubTypes()) {
            result = this.data.get(key.asGeneric());
        }
        if (result != null) {
            return result;
        }
        if (this.resolver != null) {
            result = this.resolver.resolve(state);
        } else if (key.hasSpecialMeta()) {
            result = this.data.get(key.asSpecial());
        }
        return result != null ? result : AcousticProfile.NO_PROFILE;
    }

    @Nullable
    public IAcoustic[] getBlockAcoustics(@Nonnull IBlockState state) {
        AcousticProfile result = this.cache.get(state);
        if (result == null) {
            result = this.cacheMiss(state);
            this.cache.put(state, result);
        }
        return result.get();
    }

    public void put(@Nonnull BlockInfo info, @Nonnull IAcoustic[] acoustics) {
        this.data.put(info, new AcousticProfile.Static(acoustics));
    }

    public void clear() {
        this.data = new HashMap<BlockInfo, AcousticProfile>(this.data.size());
        this.cache = new IdentityHashMap<IBlockState, AcousticProfile>(this.cache.size());
    }

    public static interface IAcousticResolver {
        public AcousticProfile resolve(@Nonnull IBlockState var1);
    }
}

