/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.aurora;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.aurora.AuroraBase;
import org.blockartistry.DynSurround.client.aurora.AuroraUtils;
import org.blockartistry.DynSurround.client.aurora.Node;
import org.blockartistry.DynSurround.client.shader.Shaders;
import org.blockartistry.lib.gfx.OpenGlState;
import org.blockartistry.lib.gfx.OpenGlUtil;
import org.blockartistry.lib.gfx.shaders.ShaderProgram;
import org.blockartistry.lib.math.MathStuff;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AuroraShaderBand
extends AuroraBase {
    protected ShaderProgram program = Shaders.AURORA;
    protected ShaderProgram.IShaderUseCallback callback = shader -> {
        shader.set("time", AuroraUtils.getTimeSeconds() * 0.75f);
        shader.set("resolution", this.getAuroraWidth(), this.getAuroraHeight());
        shader.set("topColor", this.getFadeColor());
        shader.set("middleColor", this.getMiddleColor());
        shader.set("bottomColor", this.getBaseColor());
        shader.set("alpha", this.getAlpha());
    };
    protected final float auroraWidth = (float)this.bands[0].getNodeList().length * this.bands[0].getNodeWidth();
    protected final float panelTexWidth = this.bands[0].getNodeWidth() / this.auroraWidth;

    public AuroraShaderBand(long seed) {
        super(seed, true);
    }

    @Override
    protected float getAlpha() {
        return MathStuff.clamp((float)this.bands[0].getAlphaLimit() / 255.0f * this.tracker.ageRatio() * 2.0f, 0.0f, 1.0f);
    }

    protected float getAuroraWidth() {
        return this.auroraWidth;
    }

    protected float getAuroraHeight() {
        return 18.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(float partialTick) {
        if (this.program == null) {
            return;
        }
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer renderer = tess.func_178180_c();
        double tranY = this.getTranslationY(partialTick);
        double tranX = this.getTranslationX(partialTick);
        double tranZ = this.getTranslationZ(partialTick);
        OpenGlState glState = OpenGlState.push();
        GlStateManager.func_179137_b((double)tranX, (double)tranY, (double)tranZ);
        GlStateManager.func_179139_a((double)0.5, (double)10.0, (double)0.5);
        GlStateManager.func_179140_f();
        OpenGlUtil.setAuroraBlend();
        GL11.glFrontFace((int)2304);
        try {
            this.program.use(this.callback);
            for (int b = 0; b < this.bands.length; ++b) {
                this.bands[b].translate(partialTick);
                renderer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
                Node[] array = this.bands[b].getNodeList();
                for (int i = 0; i < array.length - 1; ++i) {
                    double posY2;
                    double posZ2;
                    double posX2;
                    float v1 = 0.0f;
                    float v2 = 1.0f;
                    float u1 = (float)i * this.panelTexWidth;
                    float u2 = u1 + this.panelTexWidth;
                    Node node = array[i];
                    double posY = node.getModdedY();
                    double posX = node.tetX;
                    double posZ = node.tetZ;
                    double zero = 0.0;
                    if (i < array.length - 2) {
                        Node nodePlus = array[i + 1];
                        posX2 = nodePlus.tetX;
                        posZ2 = nodePlus.tetZ;
                        posY2 = nodePlus.getModdedY();
                    } else {
                        posX2 = node.posX;
                        posZ2 = node.getModdedZ();
                        posY2 = 0.0;
                    }
                    renderer.func_181662_b(posX, 0.0, posZ).func_187315_a((double)u1, 0.0).func_181675_d();
                    renderer.func_181662_b(posX, posY, posZ).func_187315_a((double)u1, 1.0).func_181675_d();
                    renderer.func_181662_b(posX2, 0.0, posZ2).func_187315_a((double)u2, 0.0).func_181675_d();
                    renderer.func_181662_b(posX2, posY2, posZ2).func_187315_a((double)u2, 1.0).func_181675_d();
                }
                tess.func_78381_a();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.program = null;
        }
        finally {
            try {
                if (this.program != null) {
                    this.program.unUse();
                }
            }
            catch (Throwable throwable) {}
        }
        GL11.glFrontFace((int)2305);
        OpenGlState.pop(glState);
    }

    @Override
    public String toString() {
        return "<SHADER> " + super.toString();
    }
}

