/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.aurora;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;

public final class AuroraGeometry {
    public final int length;
    public final float nodeLength;
    public final float nodeWidth;
    public final int bandOffset;
    public final int alphaLimit;
    private static final List<AuroraGeometry> PRESET = new ArrayList<AuroraGeometry>();

    private AuroraGeometry(int length, float nodeLength, float nodeWidth, int bandOffset, int alphaLimit) {
        this.length = length;
        this.nodeLength = nodeLength;
        this.nodeWidth = nodeWidth;
        this.bandOffset = bandOffset;
        this.alphaLimit = alphaLimit;
    }

    @Nonnull
    public static AuroraGeometry get(@Nonnull Random random) {
        int idx = random.nextInt(PRESET.size());
        return PRESET.get(idx);
    }

    @Nonnull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("bandLength:").append(this.length);
        builder.append(";nodeLength:").append(this.nodeLength);
        builder.append(";nodeWidth:").append(this.nodeWidth);
        builder.append(";bandOffset:").append(this.bandOffset);
        builder.append(";alphaLimit:").append(this.alphaLimit);
        return builder.toString();
    }

    static {
        PRESET.add(new AuroraGeometry(128, 30.0f, 2.0f, 45, 96));
        PRESET.add(new AuroraGeometry(128, 15.0f, 2.0f, 27, 96));
        PRESET.add(new AuroraGeometry(64, 30.0f, 2.0f, 45, 96));
        PRESET.add(new AuroraGeometry(64, 15.0f, 2.0f, 27, 96));
        PRESET.add(new AuroraGeometry(128, 30.0f, 2.0f, 45, 80));
        PRESET.add(new AuroraGeometry(128, 15.0f, 2.0f, 27, 80));
        PRESET.add(new AuroraGeometry(64, 30.0f, 2.0f, 45, 80));
        PRESET.add(new AuroraGeometry(64, 15.0f, 2.0f, 27, 80));
        PRESET.add(new AuroraGeometry(128, 30.0f, 2.0f, 45, 64));
        PRESET.add(new AuroraGeometry(128, 15.0f, 2.0f, 27, 64));
        PRESET.add(new AuroraGeometry(64, 30.0f, 2.0f, 45, 64));
        PRESET.add(new AuroraGeometry(64, 15.0f, 2.0f, 27, 64));
    }
}

