/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.aurora;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.aurora.AuroraBand;
import org.blockartistry.DynSurround.client.aurora.AuroraColor;
import org.blockartistry.DynSurround.client.aurora.AuroraGeometry;
import org.blockartistry.DynSurround.client.aurora.AuroraLifeTracker;
import org.blockartistry.DynSurround.client.aurora.IAurora;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.registry.DimensionInfo;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public abstract class AuroraBase
implements IAurora {
    protected final Random random;
    protected final long seed;
    protected final AuroraBand[] bands;
    protected final AuroraLifeTracker tracker;
    protected final AuroraColor colors;

    public AuroraBase(long seed) {
        this(seed, false);
    }

    public AuroraBase(long seed, boolean flag) {
        this.seed = seed;
        this.tracker = new AuroraLifeTracker(512, 1);
        this.random = new XorShiftRandom(seed);
        this.bands = new AuroraBand[this.random.nextInt(3) + 1];
        this.colors = AuroraColor.get(this.random);
        AuroraGeometry geo = AuroraGeometry.get(this.random);
        this.bands[0] = new AuroraBand(this.random, geo, flag, flag);
        if (this.bands.length > 1) {
            for (int i = 1; i < this.bands.length; ++i) {
                this.bands[i] = this.bands[0].copy(geo.bandOffset * i);
            }
        }
    }

    @Override
    public boolean isAlive() {
        return this.tracker.isAlive();
    }

    @Override
    public void setFading(boolean flag) {
        this.tracker.setFading(flag);
    }

    @Override
    public boolean isDying() {
        return this.tracker.isFading();
    }

    @Override
    public void update() {
        this.tracker.update();
    }

    @Override
    public boolean isComplete() {
        return !this.isAlive();
    }

    protected float getAlpha() {
        return this.tracker.ageRatio() * (float)this.bands[0].getAlphaLimit() / 255.0f;
    }

    protected double getTranslationX(float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g.field_70165_t - (mc.field_71439_g.field_70142_S + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70142_S) * (double)partialTick);
    }

    protected double getTranslationZ(float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g.field_70161_v - 150.0 - (mc.field_71439_g.field_70136_U + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70136_U) * (double)partialTick);
    }

    protected double getTranslationY(float partialTick) {
        DimensionInfo dimInfo = EnvironStateHandler.EnvironState.getDimensionInfo();
        Minecraft mc = Minecraft.func_71410_x();
        double heightScale = 1.0;
        if (mc.field_71439_g.field_70163_u > (double)dimInfo.getSeaLevel()) {
            double limit = (double)(dimInfo.getSkyHeight() + dimInfo.getCloudHeight()) / 2.0;
            double d1 = limit - (double)dimInfo.getSeaLevel();
            double d2 = mc.field_71439_g.field_70163_u - (double)dimInfo.getSeaLevel();
            heightScale = (d1 - d2) / d1;
        }
        return 64.0 * heightScale;
    }

    @Nonnull
    protected Color getBaseColor() {
        return this.colors.baseColor;
    }

    @Nonnull
    protected Color getFadeColor() {
        return this.colors.fadeColor;
    }

    @Nonnull
    protected Color getMiddleColor() {
        return this.colors.middleColor;
    }

    @Override
    public abstract void render(float var1);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("seed: ").append(this.seed);
        builder.append(", bands: ").append(this.bands.length);
        builder.append(", base: ").append(this.getBaseColor().toString());
        builder.append(", fade: ").append(this.getFadeColor().toString());
        builder.append(", alpha: ").append((int)(this.getAlpha() * 255.0f));
        if (!this.tracker.isAlive()) {
            builder.append(", DEAD");
        } else if (this.tracker.isFading()) {
            builder.append(", FADING");
        }
        return builder.toString();
    }
}

