/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.aurora;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.aurora.AuroraGeometry;
import org.blockartistry.DynSurround.client.aurora.Node;
import org.blockartistry.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class AuroraBand {
    protected static final float ANGLE1 = 0.19634955f;
    protected static final float ANGLE2 = MathStuff.toRadians(12.857142f);
    protected static final float AURORA_SPEED = 0.75f;
    protected static final int AURORA_WAVELENGTH = 8;
    public static final float AURORA_AMPLITUDE = 18.0f;
    protected final Random random;
    protected Node[] nodes;
    protected float cycle = 0.0f;
    protected int alphaLimit = 128;
    protected int length;
    protected float nodeLength;
    protected float nodeWidth;

    public AuroraBand(Random random, AuroraGeometry geo, boolean noTaper, boolean fixedHeight) {
        this.random = random;
        this.preset(geo);
        this.generateBands(noTaper, fixedHeight);
        this.translate(0.0f);
    }

    public AuroraBand(Random random, AuroraGeometry geo) {
        this(random, geo, false, false);
    }

    protected AuroraBand(Node[] nodes, AuroraBand band) {
        this.random = band.random;
        this.nodes = nodes;
        this.cycle = band.cycle;
        this.length = band.length;
        this.nodeLength = band.nodeLength;
        this.nodeWidth = band.nodeWidth;
        this.alphaLimit = band.alphaLimit;
        this.translate(0.0f);
    }

    public int getAlphaLimit() {
        return this.alphaLimit;
    }

    @Nonnull
    public Node[] getNodeList() {
        return this.nodes;
    }

    public float getNodeWidth() {
        return this.nodeWidth;
    }

    public void update() {
        float f;
        this.cycle += 0.75f;
        if (f >= 360.0f) {
            this.cycle -= 360.0f;
        }
    }

    public AuroraBand copy(int offset) {
        Node[] newNodes = new Node[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            newNodes[i] = new Node(this.nodes[i], offset);
        }
        return new AuroraBand(newNodes, this);
    }

    public void translate(float partialTick) {
        float c = this.cycle + 0.75f * partialTick;
        for (int i = 0; i < this.nodes.length; ++i) {
            float f = MathStuff.cos(MathStuff.toRadians((float)(i << 3) + c));
            Node node = this.nodes[i];
            node.dZ = f * 18.0f;
            node.dY = f * 3.0f;
            float mZ = node.getModdedZ();
            node.tetX = node.posX + node.cosDeg90;
            node.tetX2 = node.posX + node.cosDeg270;
            node.tetZ = mZ + node.sinDeg90;
            node.tetZ2 = mZ + node.sinDeg270;
        }
    }

    protected void preset(AuroraGeometry geo) {
        this.length = geo.length;
        this.nodeLength = geo.nodeLength;
        this.nodeWidth = geo.nodeWidth;
        this.alphaLimit = geo.alphaLimit;
    }

    protected void generateBands(boolean noTaper, boolean fixedHeight) {
        this.nodes = this.populate(noTaper, fixedHeight);
        float factor = (float)Math.PI / (float)(this.length / 4);
        int lowerBound = this.length / 8 + 1;
        int upperBound = this.length * 7 / 8 - 1;
        int count = 0;
        for (int i = 0; i < this.length; ++i) {
            float width = noTaper ? this.nodeWidth : (i < lowerBound ? MathStuff.sin(factor * (float)count++) * this.nodeWidth : (i > upperBound ? MathStuff.sin(factor * (float)count--) * this.nodeWidth : this.nodeWidth));
            this.nodes[i].setWidth(width);
        }
    }

    @Nonnull
    protected Node[] populate(boolean noTaper, boolean fixedHeight) {
        float angle;
        Node[] nodeList = new Node[this.length];
        int bound = this.length / 2 - 1;
        float angleTotal = 0.0f;
        for (int i = this.length / 8 / 2 - 1; i >= 0; --i) {
            angle = (this.random.nextFloat() - 0.5f) * 8.0f;
            if (MathStuff.abs(angleTotal += angle) > 180.0f) {
                angle = -angle;
                angleTotal += angle;
            }
            for (int k = 7; k >= 0; --k) {
                int idx = i * 8 + k;
                if (idx == bound) {
                    float amplitude = fixedHeight ? 18.0f : 7.0f + this.random.nextFloat();
                    nodeList[idx] = new Node(0.0f, amplitude, 0.0f, angle);
                    continue;
                }
                float y = fixedHeight ? 18.0f : (i == 0 ? MathStuff.sin(0.19634955f * (float)k) * 7.0f + this.random.nextFloat() / 2.0f : 10.0f + this.random.nextFloat() * 5.0f);
                Node node = nodeList[idx + 1];
                float subAngle = node.angle + angle;
                float subAngleRads = MathStuff.toRadians(subAngle);
                float z = node.posZ - MathStuff.sin(subAngleRads) * this.nodeLength;
                float x = node.posX - MathStuff.cos(subAngleRads) * this.nodeLength;
                nodeList[idx] = new Node(x, y, z, subAngle);
            }
        }
        angleTotal = 0.0f;
        for (int j = this.length / 8 / 2; j < this.length / 8; ++j) {
            angle = (this.random.nextFloat() - 0.5f) * 8.0f;
            if (MathStuff.abs(angleTotal += angle) > 180.0f) {
                angle = -angle;
                angleTotal += angle;
            }
            for (int h = 0; h < 8; ++h) {
                float y = fixedHeight ? 18.0f : (j == this.length / 8 - 1 ? MathStuff.cos(ANGLE2 * (float)h) * 7.0f + this.random.nextFloat() / 2.0f : 10.0f + this.random.nextFloat() * 5.0f);
                Node node = nodeList[j * 8 + h - 1];
                float subAngle = node.angle + angle;
                float subAngleRads = MathStuff.toRadians(subAngle);
                float z = node.posZ + MathStuff.sin(subAngleRads) * this.nodeLength;
                float x = node.posX + MathStuff.cos(subAngleRads) * this.nodeLength;
                nodeList[j * 8 + h] = new Node(x, y, z, subAngle);
            }
        }
        return nodeList;
    }
}

