/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.lib.chunk.DirectChunkCache;
import org.blockartistry.lib.chunk.IBlockAccessEx;
import org.blockartistry.lib.chunk.IChunkCache;
import org.blockartistry.lib.chunk.PassThroughChunkCache;
import org.blockartistry.lib.math.TimerEMA;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class ClientChunkCache {
    public static final IBlockAccessEx INSTANCE = ClientChunkCache.useDirectChunkCache() ? new DirectChunkCache() : new PassThroughChunkCache();
    public static final TimerEMA timing = new TimerEMA("Chunk Cache");

    private static boolean useDirectChunkCache() {
        return !ModOptions.general.enableClientChunkCaching;
    }

    private static int range() {
        int r = Math.max(32, ModOptions.general.specialEffectRange);
        r = Math.max(r, ModOptions.lightlevel.llBlockRange);
        return r + 2;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void clientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.START) {
            EntityPlayerSP player2 = Minecraft.func_71410_x().field_71439_g;
            if (player2 != null) {
                long start = System.nanoTime();
                int range = ClientChunkCache.range();
                BlockPos pos = new BlockPos((Vec3i)player2.func_180425_c());
                BlockPos min = pos.func_177982_a(-range, -range, -range);
                BlockPos max = pos.func_177982_a(range, range, range);
                ((IChunkCache)((Object)INSTANCE)).update(player2.func_130014_f_(), min, max);
                timing.update(System.nanoTime() - start);
            } else {
                ((IChunkCache)((Object)INSTANCE)).clear();
            }
        }
    }
}

