/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.asm;

import net.minecraftforge.fml.common.Loader;
import org.blockartistry.DynSurround.asm.Transformer;
import org.blockartistry.lib.asm.Transmorgrifier;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SoundCrashFixStreamThread
extends Transmorgrifier {
    public SoundCrashFixStreamThread() {
        super("paulscode.sound.StreamThread");
    }

    @Override
    public boolean isEnabled() {
        return !Loader.isModLoaded((String)"ambientsounds");
    }

    @Override
    public String name() {
        return "removeSource";
    }

    @Override
    public boolean transmorgrify(ClassNode cn) {
        String name = "run";
        String sig = "()V";
        MethodNode m = this.findMethod(cn, "()V", "run");
        if (m != null) {
            this.logMethod(Transformer.log(), m, "Found!");
            for (AbstractInsnNode insn : m.instructions) {
                if (!(insn instanceof MethodInsnNode) || !((MethodInsnNode)insn).owner.equals("java/util/ListIterator") || !((MethodInsnNode)insn).name.equals("next")) continue;
                insn = insn.getNext().getNext();
                LocalVariableNode var = this.findLocalVariable(m, "src");
                if (var == null) continue;
                m.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(58, var.index));
                m.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "org/blockartistry/DynSurround/client/sound/fix/SoundFixMethods", "removeSource", "(Lpaulscode/sound/Source;)Lpaulscode/sound/Source;", false));
                m.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, var.index));
                return true;
            }
        } else {
            Transformer.log().error("Unable to locate method {}{}", new Object[]{"run", "()V"});
        }
        Transformer.log().info("Unable to patch [{}]!", new Object[]{this.getClassName()});
        return false;
    }
}

