/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.asm;

import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.asm.Transformer;
import org.blockartistry.lib.asm.Transmorgrifier;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class PatchParticleManagerSync
extends Transmorgrifier {
    public PatchParticleManagerSync() {
        super("net.minecraft.client.particle.ParticleManager");
    }

    @Override
    public String name() {
        return "ParticleManager synchronization";
    }

    @Override
    public boolean isEnabled() {
        return ModOptions.asm.enableParticleManagerSync;
    }

    @Override
    public boolean transmorgrify(ClassNode cn) {
        for (MethodNode m : cn.methods) {
            if (m.name.startsWith("<") || (m.access & 1) == 0 || (m.access & 0x20) != 0) continue;
            this.logMethod(Transformer.log(), m, "Synchronized!");
            m.access |= 0x20;
        }
        return true;
    }
}

