/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.proxy.Proxy;
import org.blockartistry.lib.ForgeUtils;
import org.blockartistry.lib.Localization;
import org.blockartistry.lib.VersionChecker;
import org.blockartistry.lib.VersionHelper;
import org.blockartistry.lib.logging.ModLog;

@Mod(modid="dsurround", useMetadata=true, dependencies="after:galacticraftcore; after:ambientsounds", version="3.4.9.17", acceptedMinecraftVersions="[1.10.2]", guiFactory="org.blockartistry.DynSurround.client.gui.ConfigGuiFactory", updateJSON="https://raw.githubusercontent.com/OreCruncher/DynamicSurroundings/master/version.json", certificateFingerprint="7a2128d395ad96ceb9d9030fbd41d035b435753a")
public class DSurround {
    public static final String MOD_ID = "dsurround";
    public static final String API_ID = "dsurroundAPI";
    public static final String RESOURCE_ID = "dsurround";
    public static final String MOD_NAME = "Dynamic Surroundings";
    public static final String VERSION = "3.4.9.17";
    public static final String MINECRAFT_VERSIONS = "[1.10.2]";
    public static final String DEPENDENCIES = "after:galacticraftcore; after:ambientsounds";
    public static final String GUI_FACTORY = "org.blockartistry.DynSurround.client.gui.ConfigGuiFactory";
    public static final String UPDATE_URL = "https://raw.githubusercontent.com/OreCruncher/DynamicSurroundings/master/version.json";
    public static final String FINGERPRINT = "7a2128d395ad96ceb9d9030fbd41d035b435753a";
    public static final String SERVER_VERSION = "3.4.9.0";
    @Mod.Instance(value="dsurround")
    protected static DSurround instance;
    @SidedProxy(clientSide="org.blockartistry.DynSurround.proxy.ProxyClient", serverSide="org.blockartistry.DynSurround.proxy.Proxy")
    protected static Proxy proxy;
    protected static ModLog logger;
    protected static Configuration config;
    protected static File dataDirectory;
    protected static boolean installedOnServer;
    protected static boolean devMode;

    @Nonnull
    public static DSurround instance() {
        return instance;
    }

    @Nonnull
    public static Proxy proxy() {
        return proxy;
    }

    @Nonnull
    public static Configuration config() {
        return config;
    }

    @Nonnull
    public static ModLog log() {
        return logger;
    }

    @Nonnull
    public static File dataDirectory() {
        return dataDirectory;
    }

    public static boolean isInstalledOnServer() {
        return installedOnServer;
    }

    public static boolean isDeveloperMode() {
        return devMode;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean routePacketToServer() {
        return DSurround.isInstalledOnServer() && !Minecraft.func_71410_x().func_71387_A();
    }

    public DSurround() {
        logger = ModLog.setLogger("dsurround", LogManager.getLogger((String)"dsurround"));
        String cmdText = System.getProperty("dsurround.devMode");
        if (!StringUtils.isEmpty((CharSequence)cmdText) && "true".equals(cmdText)) {
            devMode = true;
            logger.info("RUNNING IN DEVELOPMENT MODE", new Object[0]);
        }
    }

    @Mod.EventHandler
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        dataDirectory = new File(event.getModConfigurationDirectory(), "dsurround");
        dataDirectory.mkdirs();
        config = new Configuration(new File(dataDirectory, "dsurround.cfg"), VERSION);
        config.load();
        ModOptions.load(config);
        config.save();
        logger.setDebug(ModOptions.logging.enableDebugLogging);
        logger.setTraceMask(ModOptions.logging.debugFlagMask);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(@Nonnull FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(@Nonnull FMLPostInitializationEvent event) {
        ModMetadata data;
        proxy.postInit(event);
        config.save();
        if (!proxy.isRunningAsServer() && (data = ForgeUtils.getModMetadata("dsurround")) != null) {
            data.name = Localization.format("dsurround.metadata.Name", new Object[0]);
            data.credits = Localization.format("dsurround.metadata.Credits", new Object[0]);
            data.description = Localization.format("dsurround.metadata.Description", new Object[0]);
            data.authorList = Arrays.asList(StringUtils.split((String)Localization.format("dsurround.metadata.Authors", new Object[0]), (char)','));
        }
    }

    @Mod.EventHandler
    public void loadCompleted(@Nonnull FMLLoadCompleteEvent event) {
        proxy.loadCompleted(event);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(@Nonnull FMLFingerprintViolationEvent event) {
        DSurround.log().warn("Invalid fingerprint detected!", new Object[0]);
    }

    @NetworkCheckHandler
    public boolean checkModLists(@Nonnull Map<String, String> modList, @Nonnull Side side) {
        String modVersion = modList.get("dsurround");
        if (side == Side.SERVER) {
            boolean bl = installedOnServer = !StringUtils.isEmpty((CharSequence)modVersion);
            if (installedOnServer) {
                DSurround.log().info("%s version %s is installed on the server", MOD_NAME, modVersion);
                if (VersionHelper.compareVersions(modVersion, SERVER_VERSION) < 0) {
                    DSurround.log().info("For the best experience the server should be running at least version %s", SERVER_VERSION);
                }
            }
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void clientConnect(@Nonnull FMLNetworkEvent.ClientConnectedToServerEvent event) {
        proxy.clientConnect(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void clientDisconnect(@Nonnull FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        proxy.clientDisconnect(event);
        installedOnServer = false;
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (ModOptions.logging.enableVersionChecking) {
            new VersionChecker("dsurround", "dsurround.msg.NewVersion.dsurround").playerLogin(event);
        }
    }

    @Mod.EventHandler
    public void serverAboutToStart(@Nonnull FMLServerAboutToStartEvent event) {
        proxy.serverAboutToStart(event);
    }

    @Mod.EventHandler
    public void serverStarting(@Nonnull FMLServerStartingEvent event) {
        proxy.serverStarting(event);
    }

    @Mod.EventHandler
    public void serverStopping(@Nonnull FMLServerStoppingEvent event) {
        proxy.serverStopping(event);
    }

    @Mod.EventHandler
    public void serverStopped(@Nonnull FMLServerStoppedEvent event) {
        proxy.serverStopped(event);
    }

    static {
        logger = ModLog.NULL_LOGGER;
    }
}

