/*
 * Decompiled with CFR 0.152.
 */
package cyano.lootable.graphics;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cyano.lootable.LootableBodies;
import cyano.lootable.entities.EntityLootableBody;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerArrow;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class CorpseRenderer
extends RenderLivingBase<EntityLootableBody> {
    private static final ResourceLocation localSkin = new ResourceLocation("lootablebodies:textures/entity/corpse/corpse.png");
    protected final ModelPlayer thickArmsModel;
    protected final ModelPlayer thinArmsModel;

    public CorpseRenderer(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelPlayer(0.0f, true), 0.5f);
        this.thinArmsModel = (ModelPlayer)this.field_77045_g;
        this.thickArmsModel = new ModelPlayer(0.0f, false);
        this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerArrow((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerCustomHead(this.getMainModel().field_78116_c));
    }

    public ModelPlayer getMainModel() {
        return (ModelPlayer)super.func_177087_b();
    }

    public void setModel(boolean thinArms) {
        this.field_77045_g = thinArms ? this.thinArmsModel : this.thickArmsModel;
    }

    protected ResourceLocation getEntityTexture(EntityLootableBody entity) {
        if (LootableBodies.useLocalSkin) {
            return localSkin;
        }
        GameProfile profile = entity.getGameProfile();
        if (profile != null && profile.getId() != null) {
            return CorpseRenderer.getSkin(profile);
        }
        return DefaultPlayerSkin.func_177335_a();
    }

    public static ResourceLocation getSkin(GameProfile profile) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Map loadSkinFromCache = minecraft.func_152342_ad().func_152788_a(profile);
        if (loadSkinFromCache.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            ResourceLocation skin = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)loadSkinFromCache.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            return skin;
        }
        return DefaultPlayerSkin.func_177334_a((UUID)profile.getId());
    }

    public void doRender(EntityLootableBody entity, double x, double y, double z, float yaw, float partialTick) {
        boolean shouldSit;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((EntityLivingBase)entity, (RenderLivingBase)this, x, y, z))) {
            return;
        }
        this.setModel(entity.useThinArms());
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        this.field_77045_g.field_78095_p = 0.0f;
        this.field_77045_g.field_78093_q = shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        this.field_77045_g.field_78091_s = entity.func_70631_g_();
        try {
            float rotationInterpolation = 0.0f;
            float headYaw = 0.0f;
            float headPitch = 0.0f;
            this.renderLivingAt(entity, x, y, z);
            float age = 0.0f;
            this.func_77043_a((EntityLivingBase)entity, age, rotationInterpolation, partialTick);
            float scale = this.func_188322_c((EntityLivingBase)entity, 0.0f);
            float armSwingAmount = 0.0f;
            float armSwing = 0.0f;
            GlStateManager.func_179141_d();
            this.field_77045_g.func_78086_a((EntityLivingBase)entity, armSwing, armSwingAmount, 0.0f);
            this.field_77045_g.func_78087_a(armSwing, armSwingAmount, age, headYaw, headPitch, scale, (Entity)entity);
            if (this.field_188301_f) {
                boolean flag1 = this.func_177088_c((EntityLivingBase)entity);
                GlStateManager.func_179142_g();
                GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
                if (!this.field_188323_j) {
                    this.func_77036_a((EntityLivingBase)entity, armSwing, armSwingAmount, age, headYaw, headPitch, scale);
                }
                this.func_177093_a((EntityLivingBase)entity, armSwing, armSwingAmount, partialTick, age, headYaw, headPitch, scale);
                GlStateManager.func_187417_n();
                GlStateManager.func_179119_h();
                if (flag1) {
                    this.func_180565_e();
                }
            } else {
                boolean flag = this.func_177090_c((EntityLivingBase)entity, partialTick);
                this.func_77036_a((EntityLivingBase)entity, armSwing, armSwingAmount, age, headYaw, headPitch, scale);
                if (flag) {
                    this.func_177091_f();
                }
                GlStateManager.func_179132_a((boolean)true);
                this.func_177093_a((EntityLivingBase)entity, armSwing, armSwingAmount, partialTick, age, headYaw, headPitch, scale);
            }
            GlStateManager.func_179101_C();
        }
        catch (Exception ex) {
            FMLLog.log((Level)Level.ERROR, (Throwable)ex, (String)"Couldn't render entity", (Object[])new Object[0]);
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        if (!this.field_188301_f && LootableBodies.displayNameTag) {
            this.func_177067_a((EntityLivingBase)entity, x, y, z);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((EntityLivingBase)entity, (RenderLivingBase)this, x, y, z));
        this.setModel(true);
    }

    protected void renderLivingAt(EntityLootableBody e, double x, double y, double z) {
        super.func_77039_a((EntityLivingBase)e, x, y, z);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)e.getRotation(), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.85f, (float)-0.125f);
    }
}

