/*
 * Decompiled with CFR 0.152.
 */
package cyano.lootable;

import cyano.lootable.Proxy;
import cyano.lootable.ServerProxy;
import cyano.lootable.entities.EntityLootableBody;
import cyano.lootable.events.PlayerDeathEventHandler;
import cyano.lootable.graphics.GUIHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod(modid="lootablebodies", name="DrCyano's Lootable Bodies", version="2.2.0", acceptedMinecraftVersions="[1.10.2,)")
public class LootableBodies {
    public static final String MODID = "lootablebodies";
    public static final String NAME = "DrCyano's Lootable Bodies";
    public static final String VERSION = "2.2.0";
    private static LootableBodies INSTANCE = null;
    public static boolean displayNameTag = true;
    public static boolean addBonesToCorpse = true;
    public static boolean useLocalSkin = false;
    public static long ticksPerItemDecay = 12000L;
    public static boolean hurtByEnvironment = false;
    public static boolean hurtByAttacks = false;
    public static boolean hurtByMisc = false;
    public static boolean completelyInvulnerable = false;
    public static float corpseHP = 20.0f;
    public static boolean allowCorpseDecay = true;
    public static boolean decayOnlyWhenEmpty = true;
    public static long corpseDecayTime = 72000L;
    @SidedProxy(clientSide="cyano.lootable.ClientProxy", serverSide="cyano.lootable.ServerProxy")
    public static Proxy proxy;
    private int entityIndex = 0;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        INSTANCE = this;
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        corpseHP = config.getFloat("corpse_HP", "options", corpseHP, 1.0f, 32767.0f, "The amount of damage a corpse can suffer before being \ndestroyed and releasing its items. \nNote that 10 hearts = 20 HP.");
        useLocalSkin = config.getBoolean("local_texture", "options", useLocalSkin, "If false, corpses will have the skins of the player who \ndied. If true, then corpses will use the following texture \n.location: assets/lootablebodies/textures/entity/corpse/corpse.png");
        displayNameTag = config.getBoolean("display_nametag", "options", displayNameTag, "If true, corpses will show their owner's name");
        addBonesToCorpse = config.getBoolean("add_bones_to_corpse", "options", addBonesToCorpse, "If true, corpses will have bones and rotten flesh added to them.");
        hurtByEnvironment = config.getBoolean("hurt_by_environment", "corpse damage", hurtByEnvironment, "If true, corpses will be damaged by fire, lava, falling, and other such hazards.");
        hurtByAttacks = config.getBoolean("hurt_by_weapons", "corpse damage", hurtByAttacks, "If true, corpses can be damaged by attacking them.");
        hurtByMisc = config.getBoolean("hurt_by_misc", "corpse damage", hurtByMisc, "If true, corpses will be damaged by damage sources not covered by the other options in this section.");
        completelyInvulnerable = !LootableBodies.or(hurtByEnvironment, hurtByAttacks, hurtByMisc);
        ticksPerItemDecay = (int)(1200.0f * config.getFloat("item_decay_rate", "options", 5.0f, -1.0f, 1.0E9f, "All damageable items on the corpse will suffer 1 durability damage \nfor every X number of minutes (default is 5 minutes) that they are. \nItems damaged in this way will never be completely destroyed. \nSet to 0 (or negative) to disable."));
        allowCorpseDecay = config.getBoolean("enable_corpse_decay", "corpse decay", allowCorpseDecay, "If true, corpses will self-destruct after a period of time.");
        decayOnlyWhenEmpty = config.getBoolean("empty_only_decay", "corpse decay", decayOnlyWhenEmpty, "If true and enable_corpse_decay is also true, corpses will \nself-destruct after being empty for a period of time (will \nnot decay if there are any items on the corpse). If using this \noption, you will probably want to also disable the \nadd_bones_to_corpse option.");
        String decayTime = config.getString("corpse_decay_time", "corpse decay", "1:00:00", "Time after death before a corpse will self-destruct (if the \nenable_corpse_decay option is set to true). \nThe format is hours:minutes:seconds or just hours:minutes");
        corpseDecayTime = Math.max(this.parseTimeInSeconds(decayTime), 2) * 20;
        config.save();
        proxy.preInit(event);
    }

    private int parseTimeInSeconds(String time) {
        String[] component = time.split(":");
        int hr = 0;
        int min = 0;
        int sec = 0;
        if (component.length > 0) {
            hr = Integer.parseInt(component[0].trim());
        }
        if (component.length > 1) {
            min = Integer.parseInt(component[1].trim());
        }
        if (component.length > 2) {
            sec = Integer.parseInt(component[2].trim());
        }
        return 3600 * hr + 60 * min + sec;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerItemRenders();
        this.registerEntity(EntityLootableBody.class);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerDeathEventHandler());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)LootableBodies.getInstance(), (IGuiHandler)GUIHandler.getInstance());
        proxy.init(event);
    }

    private void registerEntity(Class entityClass) {
        String idName = "Corpse";
        EntityRegistry.registerModEntity((Class)entityClass, (String)idName, (int)this.entityIndex++, (Object)this, (int)32, (int)1, (boolean)true);
    }

    private void registerItemRenders() {
        if (proxy instanceof ServerProxy) {
            return;
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    public static LootableBodies getInstance() {
        return INSTANCE;
    }

    private static boolean or(boolean ... bools) {
        for (int i = 0; i < bools.length; ++i) {
            if (!bools[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean and(boolean ... bools) {
        for (int i = 0; i < bools.length; ++i) {
            if (bools[i]) continue;
            return false;
        }
        return true;
    }
}

