/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.util;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import net.doubledoordev.d3core.D3Core;
import net.doubledoordev.d3core.util.CoreConstants;
import net.doubledoordev.d3core.util.EndermanGriefing;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AchievementEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.io.FileUtils;

public class EventHandler {
    public static final EventHandler I = new EventHandler();
    public boolean enableStringID;
    public boolean enableUnlocalizedName;
    public boolean enableOreDictionary;
    public boolean enableBurnTime;
    public boolean nosleep;
    public boolean printDeathCoords = true;
    public boolean claysTortureMode;
    public boolean norain;
    public boolean insomnia;
    public boolean lilypad;
    public boolean achievementFireworks;
    private int aprilFoolsDelay = 0;

    private EventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void itemTooltipEventHandler(ItemTooltipEvent event) {
        if (event.isShowAdvancedItemTooltips()) {
            if (this.enableStringID) {
                event.getToolTip().add(TextFormatting.DARK_AQUA + event.getItemStack().func_77973_b().getRegistryName().toString());
            }
            if (this.enableUnlocalizedName) {
                event.getToolTip().add(TextFormatting.DARK_GREEN + event.getItemStack().func_77977_a());
            }
            if (this.enableOreDictionary) {
                for (int id : OreDictionary.getOreIDs((ItemStack)event.getItemStack())) {
                    event.getToolTip().add(TextFormatting.DARK_PURPLE + OreDictionary.getOreName((int)id));
                }
            }
            if (this.enableBurnTime && TileEntityFurnace.func_145954_b((ItemStack)event.getItemStack())) {
                event.getToolTip().add(TextFormatting.GOLD + "Burns for " + TileEntityFurnace.func_145952_a((ItemStack)event.getItemStack()) + " ticks");
            }
        }
    }

    @SubscribeEvent
    public void achievementEvent(AchievementEvent event) {
        StatisticsManagerServer sms;
        EntityPlayer player = event.getEntityPlayer();
        if (this.achievementFireworks && FMLCommonHandler.instance().getEffectiveSide().isServer() && player.func_184102_h() != null && (sms = player.func_184102_h().func_184103_al().func_152602_a(player)).func_77442_b(event.getAchievement()) && !sms.func_77443_a(event.getAchievement())) {
            CoreConstants.spawnRandomFireworks((Entity)player, 1, 1);
        }
    }

    @SubscribeEvent
    public void entityDeathEvent(LivingDropsEvent event) {
        EntityEnderman entityEnderman;
        IBlockState state;
        if (event.getEntityLiving() instanceof EntityPlayer && this.claysTortureMode) {
            event.setCanceled(true);
        } else if (event.getEntityLiving() instanceof EntityEnderman && EndermanGriefing.dropCarrying && (state = (entityEnderman = (EntityEnderman)event.getEntityLiving()).func_175489_ck()) != null && state.func_177230_c() != Blocks.field_150350_a) {
            ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
            event.getDrops().add(new EntityItem(entityEnderman.field_70170_p, entityEnderman.field_70165_t, entityEnderman.field_70163_u, entityEnderman.field_70161_v, stack));
        }
    }

    @SubscribeEvent
    public void playerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && this.printDeathCoords) {
            TextComponentString posText = new TextComponentString("X: " + MathHelper.func_76128_c((double)event.getEntityLiving().field_70165_t) + " Y: " + MathHelper.func_76128_c((double)(event.getEntityLiving().field_70163_u + 0.5)) + " Z: " + MathHelper.func_76128_c((double)event.getEntityLiving().field_70161_v));
            try {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (server.func_71187_D().func_71557_a((ICommandSender)event.getEntityLiving()).contains(server.func_71187_D().func_71555_a().get("tp"))) {
                    posText.func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to teleport!"))).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + MathHelper.func_76128_c((double)event.getEntityLiving().field_70165_t) + " " + MathHelper.func_76128_c((double)(event.getEntityLiving().field_70163_u + 0.5)) + " " + MathHelper.func_76128_c((double)event.getEntityLiving().field_70161_v))));
                }
                if (server.func_71187_D().func_71557_a((ICommandSender)event.getEntityLiving()).contains(server.func_71187_D().func_71555_a().get("tpx"))) {
                    posText.func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to teleport!"))).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpx " + ((EntityPlayer)event.getEntityLiving()).field_71093_bK + " " + MathHelper.func_76128_c((double)event.getEntityLiving().field_70165_t) + " " + MathHelper.func_76128_c((double)(event.getEntityLiving().field_70163_u + 0.5)) + " " + MathHelper.func_76128_c((double)event.getEntityLiving().field_70161_v))));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((EntityPlayer)event.getEntityLiving()).func_146105_b(new TextComponentString("You died at ").func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)).func_150257_a((ITextComponent)posText));
        }
    }

    @SubscribeEvent
    public void sleepEvent(PlayerSleepInBedEvent event) {
        if (this.nosleep || D3Core.isAprilFools()) {
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public void aprilFools(ServerChatEvent event) {
        if (D3Core.isAprilFools()) {
            Style style = event.getComponent().func_150256_b();
            float chance = 0.25f;
            if (CoreConstants.RANDOM.nextFloat() < chance) {
                style.func_150227_a(Boolean.valueOf(true));
                chance *= chance;
            }
            if (CoreConstants.RANDOM.nextFloat() < chance) {
                style.func_150217_b(Boolean.valueOf(true));
                chance *= chance;
            }
            if (CoreConstants.RANDOM.nextFloat() < chance) {
                style.func_150228_d(Boolean.valueOf(true));
                chance *= chance;
            }
            if (CoreConstants.RANDOM.nextFloat() < chance) {
                style.func_150225_c(Boolean.valueOf(true));
                chance *= chance;
            }
            if (CoreConstants.RANDOM.nextFloat() < chance) {
                style.func_150237_e(Boolean.valueOf(true));
            }
            style.func_150238_a(TextFormatting.values()[CoreConstants.RANDOM.nextInt(TextFormatting.values().length)]);
            event.getComponent().func_150255_a(style);
        }
    }

    @SubscribeEvent
    public void aprilFools(PlayerEvent.NameFormat event) {
        if (D3Core.isAprilFools()) {
            event.setDisplayname("\u00a7k" + event.getDisplayname());
        }
    }

    @SubscribeEvent
    public void worldTickHandler(TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.norain) {
            WorldInfo worldInfo = event.world.func_72912_H();
            worldInfo.func_76069_a(false);
            worldInfo.func_76084_b(false);
            worldInfo.func_76080_g(Integer.MAX_VALUE);
            worldInfo.func_76090_f(Integer.MAX_VALUE);
        }
    }

    @SubscribeEvent
    public void playerTickHandler(TickEvent.PlayerTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.insomnia && event.player.field_71076_b > 90) {
            event.player.field_71076_b = 90;
        }
        if (D3Core.isAprilFools() && this.aprilFoolsDelay-- <= 0) {
            this.aprilFoolsDelay = 100 * (5 + CoreConstants.RANDOM.nextInt(FMLCommonHandler.instance().getMinecraftServerInstance().func_71233_x()));
            CoreConstants.spawnRandomFireworks((Entity)event.player, 1 + CoreConstants.RANDOM.nextInt(5), 1 + CoreConstants.RANDOM.nextInt(5));
        }
    }

    @SubscribeEvent
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        File file = new File(D3Core.getFolder(), "loginmessage.txt");
        if (file.exists()) {
            try {
                String txt = FileUtils.readFileToString((File)file);
                try {
                    event.player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)txt));
                }
                catch (JsonParseException jsonparseexception) {
                    event.player.func_145747_a((ITextComponent)new TextComponentString(txt));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.lilypad) {
            this.lilypad(event.player);
        }
        if (D3Core.isAprilFools()) {
            CoreConstants.spawnRandomFireworks((Entity)event.player, 1 + CoreConstants.RANDOM.nextInt(5), 1 + CoreConstants.RANDOM.nextInt(5));
        }
    }

    @SubscribeEvent
    public void playerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        if (this.lilypad) {
            this.lilypad(event.player);
        }
        if (D3Core.isAprilFools()) {
            CoreConstants.spawnRandomFireworks((Entity)event.player, 1 + CoreConstants.RANDOM.nextInt(5), 1 + CoreConstants.RANDOM.nextInt(5));
        }
    }

    private void lilypad(EntityPlayer player) {
        World world = player.field_70170_p;
        BlockPos blockPos = new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        if (blockPos.func_177958_n() < 0) {
            blockPos = blockPos.func_177982_a(-1, 0, 0);
        }
        if (blockPos.func_177952_p() < 0) {
            blockPos = blockPos.func_177982_a(0, 0, -1);
        }
        int limiter = world.func_72940_L() * 2;
        while (world.func_180495_p(blockPos).func_185904_a() == Material.field_151586_h && --limiter != 0) {
            blockPos = blockPos.func_177982_a(0, 1, 0);
        }
        while (world.func_180495_p(blockPos).func_185904_a() == Material.field_151579_a && --limiter != 0) {
            blockPos = blockPos.func_177982_a(0, -1, 0);
        }
        if (limiter == 0) {
            return;
        }
        if (world.func_180495_p(blockPos).func_185904_a() == Material.field_151586_h) {
            world.func_175656_a(blockPos.func_177982_a(0, 1, 0), Blocks.field_150392_bi.func_176223_P());
            player.func_70634_a((double)blockPos.func_177958_n() + 0.5, (double)(blockPos.func_177956_o() + 2), (double)blockPos.func_177952_p() + 0.5);
        }
    }
}

