/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.quests.QuestInterface;

public class QuestItem
extends QuestInterface {
    public NpcMiscInventory items = new NpcMiscInventory(3);
    public boolean leaveItems = false;
    public boolean ignoreDamage = false;
    public boolean ignoreNBT = false;

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        this.items.setFromNBT(compound.func_74775_l("Items"));
        this.leaveItems = compound.func_74767_n("LeaveItems");
        this.ignoreDamage = compound.func_74767_n("IgnoreDamage");
        this.ignoreNBT = compound.func_74767_n("IgnoreNBT");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        compound.func_74782_a("Items", (NBTBase)this.items.getToNBT());
        compound.func_74757_a("LeaveItems", this.leaveItems);
        compound.func_74757_a("IgnoreDamage", this.ignoreDamage);
        compound.func_74757_a("IgnoreNBT", this.ignoreNBT);
    }

    @Override
    public boolean isCompleted(EntityPlayer player) {
        List<ItemStack> questItems = NoppesUtilPlayer.countStacks(this.items, this.ignoreDamage, this.ignoreNBT);
        for (ItemStack reqItem : questItems) {
            if (NoppesUtilPlayer.compareItems(player, reqItem, this.ignoreDamage, this.ignoreNBT)) continue;
            return false;
        }
        return true;
    }

    public List<ItemStack> getProgressSet(EntityPlayer player) {
        ArrayList<ItemStack> map = new ArrayList<ItemStack>();
        List<ItemStack> questItems = NoppesUtilPlayer.countStacks(this.items, this.ignoreDamage, this.ignoreNBT);
        for (ItemStack item : questItems) {
            if (item == null) continue;
            ItemStack is = item.func_77946_l();
            is.field_77994_a = 0;
            map.add(is);
        }
        for (ItemStack item : player.field_71071_by.field_70462_a) {
            if (item == null) continue;
            for (ItemStack questItem : map) {
                if (!NoppesUtilPlayer.compareItems(questItem, item, this.ignoreDamage, this.ignoreNBT)) continue;
                questItem.field_77994_a += item.field_77994_a;
            }
        }
        return map;
    }

    @Override
    public void handleComplete(EntityPlayer player) {
        if (this.leaveItems) {
            return;
        }
        block0: for (ItemStack questitem : this.items.items.values()) {
            int stacksize = questitem.field_77994_a;
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack item = player.field_71071_by.field_70462_a[i];
                if (item == null || !NoppesUtilPlayer.compareItems(item, questitem, this.ignoreDamage, this.ignoreNBT)) continue;
                int size = item.field_77994_a;
                if (stacksize - size >= 0) {
                    player.field_71071_by.func_70299_a(i, null);
                    item.func_77979_a(size);
                } else {
                    item.func_77979_a(stacksize);
                }
                if ((stacksize -= size) <= 0) continue block0;
            }
        }
    }

    @Override
    public Vector<String> getQuestLogStatus(EntityPlayer player) {
        Vector<String> vec = new Vector<String>();
        List<ItemStack> questItems = NoppesUtilPlayer.countStacks(this.items, this.ignoreDamage, this.ignoreNBT);
        List<ItemStack> progress = this.getProgressSet(player);
        for (int slot : this.items.items.keySet()) {
            ItemStack quest = this.items.items.get(slot);
            ItemStack item = null;
            for (ItemStack is : progress) {
                if (!NoppesUtilPlayer.compareItems(quest, is, this.ignoreDamage, this.ignoreNBT)) continue;
                item = is;
                break;
            }
            if (item == null) continue;
            String process = item.field_77994_a + "";
            if (item.field_77994_a >= quest.field_77994_a) {
                process = quest.field_77994_a + "";
            }
            item.field_77994_a -= quest.field_77994_a;
            if (item.field_77994_a < 0) {
                item.field_77994_a = 0;
            }
            process = process + "/" + quest.field_77994_a + "";
            if (item.func_82837_s()) {
                vec.add(item.func_82833_r() + ": " + process);
                continue;
            }
            vec.add(item.func_77977_a() + ".name: " + process);
        }
        return vec;
    }
}

