/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.NpcSounds;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.items.ItemNpcInterface;

public class ItemMachineGun
extends ItemNpcInterface {
    public ItemMachineGun(int par1) {
        super(par1);
        this.func_77656_e(80);
        this.func_77637_a(CustomItems.tabWeapon);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() == ItemMachineGun.this ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public void func_77615_a(ItemStack stack, World par2World, EntityLivingBase entity, int count) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        int ticks = this.func_77626_a(stack) - count;
        int shotsleft = compound.func_74762_e("ShotsLeft") - ticks / 6;
        if (compound.func_74767_n("Reloading2")) {
            shotsleft = ticks / 5;
            if (ticks > 40) {
                shotsleft = 8;
            }
            if (shotsleft > 1) {
                compound.func_74768_a("ShotsLeft", shotsleft);
                compound.func_74757_a("Reloading2", false);
            }
        } else if (shotsleft <= 0) {
            compound.func_74757_a("Reloading2", true);
            stack.func_77972_a(1, (EntityLivingBase)player);
        } else {
            compound.func_74768_a("ShotsLeft", shotsleft);
        }
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int count) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        int ticks = this.func_77626_a(stack) - count;
        if (ticks % 6 != 0) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            NBTTagCompound compound = stack.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
                stack.func_77982_d(compound);
            }
            int shotsleft = compound.func_74762_e("ShotsLeft") - ticks / 6;
            if (!player.field_71075_bZ.field_75098_d || !CustomNpcs.GunsEnabled) {
                if (compound.func_74767_n("Reloading2") && this.hasItem(player, CustomItems.bulletBlack)) {
                    if (ticks > 0 && ticks <= 24) {
                        ItemMachineGun.playSound((EntityLivingBase)player, NpcSounds.GUN_AK47_LOAD, 1.0f, 1.0f);
                    }
                    return;
                }
                if (shotsleft <= 0 || !this.hasItem(player, CustomItems.bulletBlack) || !CustomNpcs.GunsEnabled) {
                    ItemMachineGun.playSound((EntityLivingBase)player, NpcSounds.GUN_EMPTY, 1.0f, 1.0f);
                    return;
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.consumeItem(player, CustomItems.bulletBlack);
            }
            compound.func_82580_o("Reloading2");
        }
        EntityProjectile projectile = new EntityProjectile(entity.field_70170_p, entity, new ItemStack(CustomItems.bulletBlack, 1, 0), false);
        projectile.damage = 4.0f;
        projectile.setSpeed(40);
        projectile.shoot(2.0f);
        ItemMachineGun.playSound(entity, NpcSounds.GUN_PISTAL_SHOT, 0.9f, field_77697_d.nextFloat() * 0.3f + 0.8f);
        entity.field_70170_p.func_72838_d((Entity)projectile);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemstack, World world, EntityPlayer player, EnumHand hand) {
        if (!player.field_71075_bZ.field_75098_d && !this.hasItem(player, CustomItems.bulletBlack)) {
            itemstack.func_77983_a("Reloading2", (NBTBase)new NBTTagByte(1));
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("Reloading2")) {
            return EnumAction.BOW;
        }
        return EnumAction.BLOCK;
    }
}

