/*
 * Decompiled with CFR 0.152.
 */
package gunn.modcurrency.mod.worldsaveddata.bank;

import gunn.modcurrency.mod.worldsaveddata.bank.BankAccount;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class BankAccountSavedData
extends WorldSavedData {
    ArrayList<BankAccount> bankArray = new ArrayList();
    public static String IDENTIFIER = "currency_bankdata";

    public BankAccountSavedData(String name) {
        super(name);
    }

    public BankAccount getBankAccount(String name) {
        for (int i = 0; i < this.bankArray.size(); ++i) {
            if (!name.toLowerCase().equals(this.bankArray.get(i).getName().toLowerCase())) continue;
            return this.bankArray.get(i);
        }
        this.setBankAccount(new BankAccount(name, 0));
        return this.getBankAccount(name);
    }

    public void setBankAccount(BankAccount account) {
        boolean hasAcc = false;
        for (int i = 0; i < this.bankArray.size(); ++i) {
            if (!account.getName().toLowerCase().equals(this.bankArray.get(i).getName().toLowerCase())) continue;
            this.bankArray.set(i, account);
            hasAcc = true;
        }
        if (!hasAcc) {
            this.bankArray.add(account);
        }
        this.func_76185_a();
    }

    public void clearData() {
        this.bankArray = new ArrayList();
        this.func_76185_a();
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList bankList = new NBTTagList();
        for (int i = 0; i < this.bankArray.size(); ++i) {
            NBTTagCompound bankTag = new NBTTagCompound();
            bankTag.func_74778_a("name", this.bankArray.get(i).getName());
            bankTag.func_74768_a("balance", this.bankArray.get(i).getBalance());
            bankList.func_74742_a((NBTBase)bankTag);
        }
        compound.func_74782_a("bankData", (NBTBase)bankList);
        return compound;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList bankList = nbt.func_150295_c("bankData", 10);
        for (int i = 0; i < bankList.func_74745_c(); ++i) {
            NBTTagCompound bankTag = bankList.func_150305_b(i);
            String name = bankTag.func_74779_i("name");
            int bal = bankTag.func_74762_e("balance");
            this.bankArray.add(new BankAccount(name, bal));
        }
    }

    public static BankAccountSavedData getData(World world) {
        BankAccountSavedData data = (BankAccountSavedData)world.func_175693_T().func_75742_a(BankAccountSavedData.class, IDENTIFIER);
        if (data == null) {
            data = new BankAccountSavedData(IDENTIFIER);
            world.func_72823_a(IDENTIFIER, (WorldSavedData)data);
        }
        return data;
    }
}

