/*
 * Decompiled with CFR 0.152.
 */
package gunn.modcurrency.mod.network;

import gunn.modcurrency.mod.worldsaveddata.bank.BankAccount;
import gunn.modcurrency.mod.worldsaveddata.bank.BankAccountSavedData;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncBankDataToClient
implements IMessage {
    private int balance;
    private String name;

    public void setData(BankAccount acc) {
        this.balance = acc.getBalance();
        this.name = acc.getName();
    }

    public void fromBytes(ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.balance = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        buf.writeInt(this.balance);
    }

    public static class Handler
    implements IMessageHandler<PacketSyncBankDataToClient, IMessage> {
        public IMessage onMessage(PacketSyncBankDataToClient message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSyncBankDataToClient message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            BankAccountSavedData data = BankAccountSavedData.getData((World)world);
            data.setBankAccount(new BankAccount(message.name, message.balance));
        }
    }
}

