/*
 * Decompiled with CFR 0.152.
 */
package gunn.modcurrency.mod.container;

import gunn.modcurrency.mod.client.gui.util.INBTInventory;
import gunn.modcurrency.mod.container.slot.SlotCustomizable;
import gunn.modcurrency.mod.container.slot.SlotVendor;
import gunn.modcurrency.mod.item.ItemWallet;
import gunn.modcurrency.mod.item.ModItems;
import gunn.modcurrency.mod.network.PacketHandler;
import gunn.modcurrency.mod.network.PacketItemSpawnToServer;
import gunn.modcurrency.mod.tileentity.TileVending;
import gunn.modcurrency.mod.utils.UtilMethods;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ContainerVending
extends Container
implements INBTInventory {
    private final int HOTBAR_SLOT_COUNT = 9;
    private final int PLAYER_INV_ROW_COUNT = 3;
    private final int PLAYER_INV_COLUMN_COUNT = 9;
    private final int PLAYER_INV_TOTAL_COUNT = 27;
    private final int PLAYER_TOTAL_COUNT = 36;
    private int TE_VEND_COLUMN_COUNT = 3;
    private final int TE_VEND_ROW_COUNT = 5;
    private int TE_VEND_MAIN_TOTAL_COUNT = this.TE_VEND_COLUMN_COUNT * 5;
    private final int PLAYER_FIRST_SLOT_INDEX = 0;
    private final int TE_MONEY_FIRST_SLOT_INDEX = 36;
    private final int TE_VEND_FIRST_SLOT_INDEX = 37;
    private Item[] specialSlotItems = new Item[2];
    private TileVending tile;
    private int[] cachedFields;

    public ContainerVending(InventoryPlayer invPlayer, TileVending te) {
        this.specialSlotItems[0] = ModItems.itemBanknote;
        this.specialSlotItems[1] = ModItems.itemWallet;
        this.tile = te;
        this.setupPlayerInv(invPlayer);
        this.setupTeInv();
    }

    private void setupPlayerInv(InventoryPlayer invPlayer) {
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int HOTBAR_XPOS = 8;
        int HOTBAR_YPOS = 211;
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)invPlayer, x, 8 + 18 * x, 211));
        }
        int PLAYER_INV_XPOS = 8;
        int PLAYER_INV_YPOS = 153;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNum = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 153 + y * 18;
                this.func_75146_a(new Slot((IInventory)invPlayer, slotNum, xpos, ypos));
            }
        }
    }

    private void setupTeInv() {
        IItemHandler itemHandler = (IItemHandler)this.tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        int inputX = 0;
        if (this.tile.getField(2) == 0) {
            inputX = 152;
        }
        if (this.tile.getField(2) == 1) {
            inputX = -1000;
        }
        this.func_75146_a((Slot)new SlotCustomizable(itemHandler, 0, inputX, 9, this.specialSlotItems));
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int TE_INV_XPOS = 44;
        int TE_INV_YPOS = 50;
        if (this.tile.getField(7) == 1) {
            TE_INV_YPOS = 32;
            this.TE_VEND_COLUMN_COUNT = 6;
            this.TE_VEND_MAIN_TOTAL_COUNT = this.TE_VEND_COLUMN_COUNT * 5;
        }
        for (int y = 0; y < this.TE_VEND_COLUMN_COUNT; ++y) {
            for (int x = 0; x < 5; ++x) {
                int slotNum = 1 + y * 5 + x;
                int xpos = 44 + x * 18;
                int ypos = TE_INV_YPOS + y * 18;
                this.func_75146_a((Slot)new SlotVendor(itemHandler, slotNum, xpos, ypos));
            }
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        this.checkGhostStacks();
        this.tile.voidPlayerUsing();
        this.tile.setField(8, 0);
        this.tile.setField(5, 0);
        this.tile.setField(2, 0);
        this.tile.outInputSlot();
        super.func_75134_a(playerIn);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tile.canInteractWith(playerIn);
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId == -999) {
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        if (clickTypeIn == ClickType.PICKUP_ALL && slotId >= 0 && slotId <= 36) {
            Slot slot = (Slot)this.field_75151_b.get(slotId);
            ItemStack itemstack1 = player.field_71071_by.func_70445_o();
            if (!(itemstack1 == null || slot != null && slot.func_75216_d() && slot.func_82869_a(player))) {
                int i = dragType == 0 ? 0 : this.field_75151_b.size() - 1;
                int j = dragType == 0 ? 1 : -1;
                for (int k = 0; k < 2; ++k) {
                    for (int l = i; l >= 0 && l <= 36 && itemstack1.field_77994_a < itemstack1.func_77976_d(); l += j) {
                        Slot slot1 = (Slot)this.field_75151_b.get(l);
                        if (!slot1.func_75216_d() || !ContainerVending.func_94527_a((Slot)slot1, (ItemStack)itemstack1, (boolean)true) || !slot1.func_82869_a(player) || !this.func_94530_a(itemstack1, slot1)) continue;
                        ItemStack itemstack2 = slot1.func_75211_c();
                        if (k == 0 && itemstack2.field_77994_a == itemstack2.func_77976_d()) continue;
                        int i1 = Math.min(itemstack1.func_77976_d() - itemstack1.field_77994_a, itemstack2.field_77994_a);
                        ItemStack itemstack3 = slot1.func_75209_a(i1);
                        itemstack1.field_77994_a += i1;
                        if (itemstack3 == null) {
                            slot1.func_75215_d(null);
                        }
                        slot1.func_82870_a(player, itemstack3);
                    }
                }
            }
            this.func_75142_b();
            return null;
        }
        if (clickTypeIn == ClickType.PICKUP_ALL && slotId > 36) {
            return null;
        }
        if (this.tile.getField(2) == 1) {
            if (slotId >= 37 && slotId < 37 + this.TE_VEND_MAIN_TOTAL_COUNT && this.tile.getField(8) == 1 && clickTypeIn == ClickType.PICKUP && dragType == 0) {
                if (this.func_75139_a(slotId).func_75216_d()) {
                    this.tile.setSelectedName(this.func_75139_a(slotId).func_75211_c().func_82833_r());
                } else {
                    this.tile.setSelectedName("No Item");
                }
                this.tile.func_145831_w().func_184138_a(this.tile.func_174877_v(), this.tile.func_145838_q().func_176223_P(), this.tile.func_145838_q().func_176223_P(), 3);
                if (this.tile.getField(3) != slotId) {
                    this.tile.setField(3, slotId);
                    return null;
                }
            } else if (slotId >= 37 && slotId < 37 + this.TE_VEND_MAIN_TOTAL_COUNT && this.tile.getField(8) == 0 && this.tile.isGhostSlot(slotId - 36 - 1)) {
                --((IItemHandler)this.tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot((int)(slotId - 36)).field_77994_a;
                this.tile.setGhostSlot(slotId - 36 - 1, false);
            }
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        if (slotId >= 0 && slotId <= 36) {
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        if (slotId >= 37 && slotId < 37 + this.TE_VEND_MAIN_TOTAL_COUNT) {
            if (!this.tile.isGhostSlot(slotId - 36 - 1)) {
                if (clickTypeIn == ClickType.PICKUP && dragType == 0) {
                    return this.checkAfford(slotId, 1, player);
                }
                if (clickTypeIn == ClickType.PICKUP && dragType == 1) {
                    return this.checkAfford(slotId, 10, player);
                }
                if (clickTypeIn == ClickType.QUICK_MOVE) {
                    return this.checkAfford(slotId, 64, player);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private ItemStack checkAfford(int slotId, int amnt, EntityPlayer player) {
        IItemHandler itemHandler = (IItemHandler)this.tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ItemStack playStack = player.field_71071_by.func_70445_o();
        ItemStack slotStack = itemHandler.getStackInSlot(slotId - 36);
        boolean wallet = false;
        int bank = 0;
        if (itemHandler.getStackInSlot(0) != null) {
            if (itemHandler.getStackInSlot(0).func_77973_b() == ModItems.itemWallet) {
                wallet = true;
                bank = this.tile.getField(10);
            }
        } else {
            bank = this.tile.getField(0);
        }
        int cost = this.tile.getItemCost(slotId - 36 - 1);
        if (slotStack != null) {
            if (playStack != null && !UtilMethods.equalStacks(playStack, slotStack)) {
                return null;
            }
            if (this.tile.getField(6) == 0 && slotStack.field_77994_a < amnt && slotStack.field_77994_a != 0) {
                amnt = slotStack.field_77994_a;
            }
            if (bank >= cost * amnt) {
                if (slotStack.field_77994_a >= amnt || this.tile.getField(6) == 1) {
                    ItemStack playBuyStack = slotStack.func_77946_l();
                    playBuyStack.field_77994_a = amnt;
                    if (player.field_71071_by.func_70445_o() != null) {
                        playBuyStack.field_77994_a = amnt + playStack.field_77994_a;
                    }
                    player.field_71071_by.func_70437_b(playBuyStack);
                    if (this.tile.getField(6) == 0) {
                        if (slotStack.field_77994_a - amnt == 0) {
                            this.tile.setGhostSlot(slotId - 36 - 1, true);
                            slotStack.field_77994_a = 1;
                        } else {
                            slotStack.func_77979_a(amnt);
                        }
                    }
                    if (wallet) {
                        this.sellToWallet(itemHandler.getStackInSlot(0), cost * amnt);
                    } else {
                        this.tile.setField(0, bank - cost * amnt);
                    }
                    this.tile.setField(4, this.tile.getField(4) + cost * amnt);
                }
            } else {
                this.tile.unsucessfulNoise();
            }
            return slotStack;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack sourceStack = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) return sourceStack;
        ItemStack copyStack = slot.func_75211_c();
        sourceStack = copyStack.func_77946_l();
        if (index < 36) {
            if (((Slot)this.field_75151_b.get(index)).func_75211_c().func_77973_b() == ModItems.itemBanknote || ((Slot)this.field_75151_b.get(index)).func_75211_c().func_77973_b() == ModItems.itemWallet) {
                if (this.tile.getField(2) != 0) return null;
                if (!this.func_75135_a(copyStack, 36, 37, false)) {
                    return null;
                }
            } else {
                if (this.tile.getField(2) != 1) return null;
                if (!this.func_75135_a(copyStack, 37, 37 + this.TE_VEND_MAIN_TOTAL_COUNT, false)) {
                    return null;
                }
            }
        } else if (index == 36) {
            if (this.tile.getField(2) == 0 && index == 36 && !this.func_75135_a(copyStack, 0, 36, false)) {
                return null;
            }
        } else {
            if (index < 37 || index >= 37 + this.TE_VEND_MAIN_TOTAL_COUNT + 1) return null;
            if (!this.func_75135_a(copyStack, 0, 36, false)) {
                return null;
            }
        }
        if (copyStack.field_77994_a == 0) {
            slot.func_75215_d(null);
            return sourceStack;
        } else {
            slot.func_75218_e();
        }
        return sourceStack;
    }

    public void func_75142_b() {
        super.func_75142_b();
        boolean[] fieldChanged = new boolean[this.tile.getFieldCount()];
        if (this.cachedFields == null) {
            this.cachedFields = new int[this.tile.getFieldCount()];
        }
        for (int i = 0; i < this.cachedFields.length; ++i) {
            if (this.cachedFields[i] == this.tile.getField(i)) continue;
            this.cachedFields[i] = this.tile.getField(i);
            fieldChanged[i] = true;
        }
        for (IContainerListener listener : this.field_75149_d) {
            for (int field = 0; field < this.tile.getFieldCount(); ++field) {
                if (!fieldChanged[field]) continue;
                listener.func_71112_a((Container)this, field, this.cachedFields[field]);
            }
        }
    }

    public void func_75137_b(int id, int data) {
        this.tile.setField(id, data);
    }

    private void sellToWallet(ItemStack wallet, int amountRemovable) {
        int amount = amountRemovable;
        int one = this.getTotalOfBill(wallet, 0);
        int five = this.getTotalOfBill(wallet, 1);
        int ten = this.getTotalOfBill(wallet, 2);
        int twenty = this.getTotalOfBill(wallet, 3);
        int fifty = this.getTotalOfBill(wallet, 4);
        int hundo = this.getTotalOfBill(wallet, 5);
        int[] out = new int[6];
        out[5] = Math.round(amount / 100);
        while (out[5] > hundo) {
            out[5] = out[5] - 1;
        }
        out[4] = Math.round((amount -= out[5] * 100) / 50);
        while (out[4] > fifty) {
            out[4] = out[4] - 1;
        }
        out[3] = Math.round((amount -= out[4] * 50) / 20);
        while (out[3] > twenty) {
            out[3] = out[3] - 1;
        }
        out[2] = Math.round((amount -= out[3] * 20) / 10);
        while (out[2] > ten) {
            out[2] = out[2] - 1;
        }
        out[1] = Math.round((amount -= out[2] * 10) / 5);
        while (out[1] > five) {
            out[1] = out[1] - 1;
        }
        out[0] = Math.round(amount -= out[1] * 5);
        while (out[0] > one) {
            out[0] = out[0] - 1;
        }
        amount -= out[0];
        ItemStackHandler itemHandler = this.readInventoryTag(wallet, ItemWallet.WALLET_TOTAL_COUNT);
        block14: for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < itemHandler.getSlots(); ++j) {
                ItemStack stack = itemHandler.getStackInSlot(j);
                if (stack == null) continue;
                if (stack.func_77952_i() == i) {
                    if (stack.field_77994_a >= out[i]) {
                        itemHandler.getStackInSlot((int)j).field_77994_a -= out[i];
                        out[0] = 0;
                        continue block14;
                    }
                    out[i] = out[i] - stack.field_77994_a;
                    itemHandler.setStackInSlot(j, null);
                }
                if (stack.field_77994_a != 0) continue;
                itemHandler.setStackInSlot(j, null);
            }
        }
        if (amount != 0) {
            int billDamage = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                int billWorth;
                if (itemHandler.getStackInSlot(i) == null || (billWorth = this.getBillWorth(itemHandler.getStackInSlot(i).func_77952_i(), itemHandler.getStackInSlot((int)i).field_77994_a)) <= amount) continue;
                billDamage = itemHandler.getStackInSlot(i).func_77952_i();
                if (itemHandler.getStackInSlot((int)i).field_77994_a == 1) {
                    itemHandler.setStackInSlot(i, null);
                    break;
                }
                ++itemHandler.getStackInSlot((int)i).field_77994_a;
                break;
            }
            int change = 0;
            switch (billDamage) {
                case 0: {
                    change = 0;
                    break;
                }
                case 1: {
                    change = 5 - amount;
                    break;
                }
                case 2: {
                    change = 10 - amount;
                    break;
                }
                case 3: {
                    change = 20 - amount;
                    break;
                }
                case 4: {
                    change = 50 - amount;
                    break;
                }
                case 5: {
                    change = 100 - amount;
                }
            }
            this.tile.setField(0, this.tile.getField(0) + change);
            PacketItemSpawnToServer pack = new PacketItemSpawnToServer();
            pack.setBlockPos(this.tile.func_174877_v());
            PacketHandler.INSTANCE.sendToServer((IMessage)pack);
        }
        this.writeInventoryTag(wallet, itemHandler);
    }

    private int getTotalOfBill(ItemStack stack, int billDamage) {
        ItemStackHandler itemStackHandler = this.readInventoryTag(stack, ItemWallet.WALLET_TOTAL_COUNT);
        int totalOfBill = 0;
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            if (itemStackHandler.getStackInSlot(i) == null || itemStackHandler.getStackInSlot(i).func_77952_i() != billDamage) continue;
            totalOfBill += itemStackHandler.getStackInSlot((int)i).field_77994_a;
        }
        return totalOfBill;
    }

    private int getBillWorth(int itemDamage, int stackSize) {
        int cash = 0;
        switch (itemDamage) {
            case 0: {
                cash = 1;
                break;
            }
            case 1: {
                cash = 5;
                break;
            }
            case 2: {
                cash = 10;
                break;
            }
            case 3: {
                cash = 20;
                break;
            }
            case 4: {
                cash = 50;
                break;
            }
            case 5: {
                cash = 100;
            }
        }
        return cash * stackSize;
    }

    private void checkGhostStacks() {
        IItemHandler itemHandler = (IItemHandler)this.tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < this.TE_VEND_MAIN_TOTAL_COUNT; ++i) {
            if (!this.tile.isGhostSlot(i) || itemHandler.getStackInSlot((int)(i + 1)).field_77994_a <= 1) continue;
            --itemHandler.getStackInSlot((int)(i + 1)).field_77994_a;
            this.tile.setGhostSlot(i, false);
        }
    }
}

