/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui.controls.container;

import com.creativemd.creativecore.gui.ContainerControl;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.controls.container.client.GuiSlotControl;
import com.creativemd.creativecore.gui.event.container.SlotChangeEvent;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotControl
extends ContainerControl {
    public Slot slot;
    public ItemStack lastSended;

    public SlotControl(Slot slot) {
        super(slot.field_75224_c.func_70005_c_() + slot.getSlotIndex());
        this.slot = slot;
        if (slot.func_75216_d()) {
            this.lastSended = slot.func_75211_c().func_77946_l();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiControl createGuiControl() {
        GuiSlotControl control = new GuiSlotControl(this.slot.field_75223_e, this.slot.field_75221_f, this);
        return control;
    }

    @Override
    public void onTick() {
        if (!ItemStack.func_77989_b((ItemStack)this.lastSended, (ItemStack)this.slot.func_75211_c())) {
            this.sendUpdate();
            this.raiseEvent(new SlotChangeEvent(this));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.func_77976_d();
    }

    public int getStackLimit(Slot slot, ItemStack stack) {
        return Math.min(slot.func_75219_a(), this.getItemStackLimit(stack));
    }

    @Override
    public void writeToNBTUpdate(NBTTagCompound nbt) {
        ItemStack stack = this.slot.func_75211_c();
        if (this.slot.func_75216_d()) {
            stack.func_77955_b(nbt);
            if (stack.field_77994_a > 127) {
                nbt.func_74768_a("realCount", stack.field_77994_a);
            }
            this.lastSended = stack.func_77946_l();
        } else {
            this.lastSended = null;
        }
        NBTTagCompound dragSlot = new NBTTagCompound();
        if (this.getPlayer().field_71071_by.func_70445_o() != null) {
            this.getPlayer().field_71071_by.func_70445_o().func_77955_b(dragSlot);
        }
        nbt.func_74782_a("drag", (NBTBase)dragSlot);
    }

    @Override
    public void onPacketReceive(NBTTagCompound nbt) {
        switch (nbt.func_74762_e("type")) {
            case 0: {
                ItemStack stack = null;
                if (nbt.func_74764_b("id")) {
                    stack = ItemStack.func_77949_a((NBTTagCompound)nbt);
                    if (nbt.func_74764_b("realCount")) {
                        stack.field_77994_a = nbt.func_74762_e("realCount");
                    }
                }
                this.slot.func_75215_d(stack);
                if (!ItemStack.func_77989_b((ItemStack)this.lastSended, (ItemStack)this.slot.func_75211_c())) {
                    this.raiseEvent(new SlotChangeEvent(this));
                }
                this.lastSended = stack;
                ItemStack dragStack = null;
                if (nbt.func_74764_b("drag")) {
                    dragStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("drag"));
                }
                this.getPlayer().field_71071_by.func_70437_b(dragStack);
                break;
            }
            case 1: {
                this.onSlotClicked(nbt.func_74762_e("button"), nbt.func_74767_n("shift"), nbt.func_74762_e("scrolled"));
                break;
            }
            case 2: {
                this.dropItem(nbt.func_74767_n("ctrl"));
                break;
            }
            case 3: {
                this.splitStack(nbt.func_74759_k("slots"), ItemStack.func_77949_a((NBTTagCompound)nbt), nbt.func_74767_n("right"));
            }
        }
    }

    public void dropItem(boolean ctrl) {
        if (this.slot.func_75216_d()) {
            ItemStack drop = this.slot.func_75211_c().func_77946_l();
            if (ctrl) {
                this.slot.func_75215_d(null);
            } else {
                drop.field_77994_a = 1;
                ItemStack newStack = this.slot.func_75211_c();
                --newStack.field_77994_a;
                if (newStack.field_77994_a == 0) {
                    this.slot.func_75215_d(null);
                } else {
                    this.slot.func_75215_d(newStack);
                }
            }
            this.getPlayer().func_71019_a(drop, true);
            this.slot.func_82870_a(this.getPlayer(), drop);
        }
    }

    public boolean canAddItemToSlot(@Nullable Slot slotIn, ItemStack stack, boolean stackSizeMatters) {
        boolean flag;
        boolean bl = flag = slotIn == null || !slotIn.func_75216_d();
        if (stack == null) {
            return flag;
        }
        return !flag && stack.func_77969_a(slotIn.func_75211_c()) && ItemStack.func_77970_a((ItemStack)slotIn.func_75211_c(), (ItemStack)stack) ? slotIn.func_75211_c().field_77994_a + (stackSizeMatters ? 0 : stack.field_77994_a) <= this.getItemStackLimit(stack) : flag;
    }

    public ItemStack putItemInSlot(Slot slot, ItemStack stack) {
        boolean canStack = this.canAddItemToSlot(slot, stack, true);
        int availableStackSize = this.getStackLimit(slot, stack);
        if (canStack && slot.func_75214_a(stack)) {
            int additionalStackSize;
            int neededStackSize = stack.field_77994_a;
            if (slot.func_75216_d()) {
                availableStackSize -= slot.func_75211_c().field_77994_a;
            }
            if ((additionalStackSize = Math.min(availableStackSize, neededStackSize)) > 0) {
                ItemStack inSlot = stack.func_77946_l();
                inSlot.field_77994_a = additionalStackSize;
                if (slot.func_75216_d()) {
                    inSlot.field_77994_a += slot.func_75211_c().field_77994_a;
                }
                slot.func_75215_d(inSlot);
                stack.field_77994_a -= additionalStackSize;
                if (stack.field_77994_a <= 0) {
                    return null;
                }
            }
        }
        return stack;
    }

    public void switchItems() {
        ItemStack hand = this.getPlayer().field_71071_by.func_70445_o();
        InventoryPlayer inventoryplayer = this.getPlayer().field_71071_by;
        ItemStack slotItem = this.slot.func_75211_c();
        if (this.slot.func_75214_a(hand)) {
            boolean canStack = this.canAddItemToSlot(this.slot, hand, true);
            int stackSize = this.getStackLimit(this.slot, hand);
            if (canStack && (!this.slot.func_75216_d() || this.slot.func_82869_a(this.getPlayer()))) {
                int neededStackSize = hand.field_77994_a;
                if (this.slot.func_75216_d()) {
                    stackSize -= slotItem.field_77994_a;
                }
                stackSize = Math.min(stackSize, neededStackSize);
                ItemStack inSlot = hand.func_77946_l();
                inSlot.field_77994_a = stackSize;
                if (this.slot.func_75216_d()) {
                    inSlot.field_77994_a += slotItem.field_77994_a;
                }
                this.slot.func_75215_d(inSlot);
                int left = neededStackSize - stackSize;
                if (left > 0) {
                    hand.field_77994_a = left;
                } else {
                    inventoryplayer.func_70437_b(null);
                }
            } else if (slotItem.field_77994_a <= 64) {
                int left = hand.field_77994_a - stackSize;
                if (left > 1) {
                    this.getPlayer().func_71019_a(slotItem.func_77946_l(), true);
                }
                ItemStack inSlot = hand.func_77946_l();
                inSlot.field_77994_a = Math.min(stackSize, hand.field_77994_a);
                this.slot.func_75215_d(inSlot);
                hand.field_77994_a -= Math.min(stackSize, hand.field_77994_a);
                if (hand.field_77994_a <= 0) {
                    inventoryplayer.func_70437_b(slotItem.func_77946_l());
                }
            }
        }
    }

    public void mergeToOtherInventory(ItemStack toTransfer, boolean useEmptySlot) {
        for (int i = 0; i < this.getParent().controls.size(); ++i) {
            if (!(this.getParent().controls.get(i) instanceof SlotControl)) continue;
            Slot mergeSlot = ((SlotControl)this.getParent().controls.get((int)i)).slot;
            if (mergeSlot.field_75224_c == this.slot.field_75224_c || !useEmptySlot && !mergeSlot.func_75216_d() || (toTransfer = ((SlotControl)this.getParent().controls.get(i)).putItemInSlot(mergeSlot, toTransfer)) != null) continue;
            return;
        }
    }

    public void transferIntoOtherInventory(boolean reverse, int amount) {
        if (this.slot.func_75216_d()) {
            ItemStack stack = this.slot.func_75211_c();
            if (reverse) {
                int stackSizeLeft = Math.min(amount, stack.field_77994_a);
                for (int i = 0; i < this.getParent().controls.size(); ++i) {
                    boolean canStack;
                    if (!(this.getParent().controls.get(i) instanceof SlotControl)) continue;
                    Slot mergeSlot = ((SlotControl)this.getParent().controls.get((int)i)).slot;
                    if (mergeSlot.field_75224_c == this.slot.field_75224_c || !(canStack = this.canAddItemToSlot(mergeSlot, stack, true)) || !mergeSlot.func_75216_d()) continue;
                    int transfer = Math.min(stackSizeLeft, ((SlotControl)this.getParent().controls.get(i)).getStackLimit(this.slot, stack));
                    stackSizeLeft -= transfer;
                    stack.field_77994_a += transfer;
                    mergeSlot.func_75211_c().field_77994_a -= transfer;
                    if (mergeSlot.func_75211_c().field_77994_a <= 0) {
                        mergeSlot.func_75215_d(null);
                    }
                    if (stackSizeLeft > 0) continue;
                    return;
                }
            } else {
                if (amount > stack.field_77994_a) {
                    amount = stack.field_77994_a;
                }
                ItemStack copy = stack.func_77946_l();
                copy.field_77994_a = amount;
                int minAmount = stack.field_77994_a - amount;
                this.mergeToOtherInventory(copy, false);
                if (copy.field_77994_a > 0) {
                    this.mergeToOtherInventory(copy, true);
                }
                stack.field_77994_a = copy.field_77994_a <= 0 ? minAmount : (stack.field_77994_a -= amount - copy.field_77994_a);
                if (stack.field_77994_a <= 0) {
                    this.slot.func_75215_d(null);
                }
            }
        }
    }

    public void onSlotClicked(int mouseButton, boolean shift, int scrolled) {
        ItemStack hand = this.getPlayer().field_71071_by.func_70445_o();
        InventoryPlayer inventoryplayer = this.getPlayer().field_71071_by;
        ItemStack slotItem = this.slot.func_75211_c();
        boolean isWheel = false;
        if (mouseButton == 0) {
            if (this.slot.func_82869_a(this.getPlayer())) {
                if (shift) {
                    this.transferIntoOtherInventory(false, 64);
                } else if (hand != null) {
                    this.switchItems();
                } else if (this.slot.func_75216_d()) {
                    int stackSize = Math.min(Math.min(slotItem.field_77994_a, 64), slotItem.field_77994_a);
                    ItemStack newHand = slotItem.func_77946_l();
                    newHand.field_77994_a = stackSize;
                    inventoryplayer.func_70437_b(newHand);
                    slotItem.field_77994_a -= stackSize;
                    if (slotItem.field_77994_a == 0) {
                        this.slot.func_75215_d(null);
                    }
                    this.slot.func_82870_a(this.getPlayer(), inventoryplayer.func_70445_o());
                }
            }
        } else if (mouseButton == 1) {
            if (hand != null) {
                if (this.slot.func_75214_a(hand)) {
                    boolean canStack = this.canAddItemToSlot(this.slot, hand, true);
                    if (canStack) {
                        int stacksize = 1;
                        if (this.slot.func_75216_d()) {
                            stacksize += slotItem.field_77994_a;
                        }
                        stacksize = Math.min(stacksize, this.getStackLimit(this.slot, hand));
                        if (this.slot.func_75216_d() && stacksize > slotItem.field_77994_a || !this.slot.func_75216_d() && stacksize > 0) {
                            ItemStack inSlot = hand.func_77946_l();
                            inSlot.field_77994_a = stacksize;
                            this.slot.func_75215_d(inSlot);
                            --hand.field_77994_a;
                            if (hand.field_77994_a == 0) {
                                inventoryplayer.func_70437_b(null);
                            }
                        }
                    } else {
                        this.switchItems();
                    }
                }
            } else if (this.slot.func_75216_d() && this.slot.func_82869_a(this.getPlayer())) {
                int amount = (slotItem.field_77994_a + 1) / 2;
                hand = this.slot.func_75209_a(amount);
                inventoryplayer.func_70437_b(hand);
                if (slotItem.field_77994_a == 0) {
                    this.slot.func_75215_d((ItemStack)null);
                }
                this.slot.func_82870_a(this.getPlayer(), inventoryplayer.func_70445_o());
            }
        } else if (mouseButton == 2) {
            if (hand == null && this.slot.func_75216_d() && this.getPlayer().field_71075_bZ.field_75098_d) {
                ItemStack stack = slotItem.func_77946_l();
                stack.field_77994_a = this.getItemStackLimit(stack);
                inventoryplayer.func_70437_b(stack);
            }
        } else if (mouseButton == 3 && (scrolled == 1 || this.slot.func_82869_a(this.getPlayer()))) {
            this.transferIntoOtherInventory(scrolled == -1, 1);
        }
    }

    public void splitStack(int[] slots, ItemStack stack, boolean isRightClick) {
        stack = stack.func_77946_l();
        int StackPerSlot = MathHelper.func_76141_d((float)((float)stack.field_77994_a / (float)slots.length));
        if (isRightClick) {
            StackPerSlot = 1;
        }
        for (int i = 0; i < slots.length; ++i) {
            int use;
            SlotControl control = (SlotControl)this.getParent().controls.get(slots[i]);
            int stackSize = control.getStackLimit(control.slot, stack);
            if (control.slot.func_75216_d()) {
                stackSize -= control.slot.func_75211_c().field_77994_a;
            }
            if ((use = Math.min(StackPerSlot, Math.min(stackSize, stack.field_77994_a))) > 0) {
                int size = use;
                if (control.slot.func_75216_d()) {
                    size += control.slot.func_75211_c().field_77994_a;
                }
                ItemStack inSlot = stack.func_77946_l();
                inSlot.field_77994_a = size;
                control.slot.func_75215_d(inSlot);
            }
            stack.field_77994_a -= use;
        }
        if (stack.field_77994_a <= 0) {
            this.getPlayer().field_71071_by.func_70437_b(null);
        } else {
            this.getPlayer().field_71071_by.func_70437_b(stack.func_77946_l());
        }
    }
}

