/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.stack;

import com.creativemd.creativecore.common.utils.stack.InfoBlock;
import com.creativemd.creativecore.common.utils.stack.InfoFuel;
import com.creativemd.creativecore.common.utils.stack.InfoItem;
import com.creativemd.creativecore.common.utils.stack.InfoItemStack;
import com.creativemd.creativecore.common.utils.stack.InfoMaterial;
import com.creativemd.creativecore.common.utils.stack.InfoOre;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;

public abstract class InfoStack {
    public static HashMap<String, Class<? extends InfoStack>> types = new HashMap();
    public static ArrayList<InfoStackObjectParser> objectParser = new ArrayList();
    public int stackSize = 0;
    protected static Field displayOnCreativeTab;

    public static void registerObjectParser(InfoStackObjectParser parser) {
        objectParser.add(parser);
    }

    public static void registerType(String id, Class<? extends InfoStack> classType) {
        if (types.containsKey(id)) {
            throw new IllegalArgumentException("Id '" + id + "' is already taken!");
        }
        try {
            classType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InvalidParameterException("The class does not contain an empty constructor!");
        }
        types.put(id, classType);
    }

    public static String getIDFromClass(Class<? extends InfoStack> classType) {
        for (Map.Entry<String, Class<? extends InfoStack>> entry : types.entrySet()) {
            if (entry.getValue() != classType) continue;
            return entry.getKey();
        }
        return "";
    }

    public static InfoStack parseObject(Object stack) {
        if (stack == null) {
            return null;
        }
        if (stack instanceof InfoStack) {
            return (InfoStack)stack;
        }
        for (int i = 0; i < objectParser.size(); ++i) {
            InfoStack temp = null;
            try {
                temp = objectParser.get(i).parseObject(stack);
            }
            catch (Exception e) {
                temp = null;
            }
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    public static InfoStack parseNBT(NBTTagCompound nbt) {
        String id = nbt.func_74779_i("id");
        Class<? extends InfoStack> classType = types.get(id);
        try {
            InfoStack info = classType.getConstructor(new Class[0]).newInstance(new Object[0]);
            info.loadFromNBT(nbt);
            return info;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getID() {
        return InfoStack.getIDFromClass(this.getClass());
    }

    public InfoStack(int stackSize) {
        if (stackSize < 0) {
            stackSize = 0;
        }
        if (stackSize > 64) {
            stackSize = 64;
        }
        this.stackSize = stackSize;
    }

    public InfoStack() {
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("id", this.getID());
        nbt.func_74768_a("count", this.stackSize);
        this.writeToNBTExtra(nbt);
        return nbt;
    }

    protected abstract void writeToNBTExtra(NBTTagCompound var1);

    public void loadFromNBT(NBTTagCompound nbt) {
        this.stackSize = nbt.func_74762_e("count");
        this.loadFromNBTExtra(nbt);
    }

    protected abstract void loadFromNBTExtra(NBTTagCompound var1);

    public int getAmount(ItemStack stack) {
        if (this.stackSize == 0) {
            return Integer.MAX_VALUE;
        }
        return stack.field_77994_a / this.stackSize;
    }

    public boolean isInstance(ItemStack stack) {
        return this.isInstanceIgnoreSize(stack) && this.stackSize <= stack.field_77994_a;
    }

    public boolean isInstance(InfoStack info) {
        if (this.isInstanceIgnoreSize(info) && this.stackSize < info.stackSize) {
            return false;
        }
        return false;
    }

    public abstract boolean isInstanceIgnoreSize(InfoStack var1);

    public abstract InfoStack copy();

    public ItemStack getItemStack() {
        return this.getItemStack(this.stackSize);
    }

    public abstract ArrayList<ItemStack> getAllPossibleItemStacks();

    public abstract ItemStack getItemStack(int var1);

    protected abstract boolean isStackInstanceIgnoreSize(ItemStack var1);

    public boolean isInstanceIgnoreSize(ItemStack stack) {
        return this.isStackInstanceIgnoreSize(stack);
    }

    public boolean equals(Object object) {
        return object instanceof InfoStack && ((InfoStack)object).stackSize == this.stackSize && this.equalsIgnoreSize(object);
    }

    public abstract boolean equalsIgnoreSize(Object var1);

    protected static List<ItemStack> getAllExistingItems() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item item : Item.field_150901_e) {
            item.func_150895_a(item, item.func_77640_w(), stacks);
        }
        for (Block block : Block.field_149771_c) {
            try {
                block.func_149666_a(Item.func_150898_a((Block)block), (CreativeTabs)displayOnCreativeTab.get(block), stacks);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return stacks;
    }

    static {
        InfoStack.registerType("block", InfoBlock.class);
        InfoStack.registerObjectParser(new InfoStackObjectParser(){

            @Override
            public InfoStack parseObject(Object object) {
                Block block = null;
                if (object instanceof Block) {
                    block = (Block)object;
                }
                if (object instanceof ItemBlock) {
                    block = Block.func_149634_a((Item)((Item)object));
                }
                if (block != null && !(block instanceof BlockAir)) {
                    return new InfoBlock(block);
                }
                return null;
            }
        });
        InfoStack.registerType("item", InfoItem.class);
        InfoStack.registerObjectParser(new InfoStackObjectParser(){

            @Override
            public InfoStack parseObject(Object object) {
                if (object instanceof Item && !(object instanceof ItemBlock)) {
                    return new InfoItem((Item)object);
                }
                return null;
            }
        });
        InfoStack.registerType("itemstack", InfoItemStack.class);
        InfoStack.registerObjectParser(new InfoStackObjectParser(){

            @Override
            public InfoStack parseObject(Object object) {
                if (object instanceof ItemStack) {
                    if (((ItemStack)object).func_77952_i() == Short.MAX_VALUE) {
                        if (((ItemStack)object).func_77973_b() instanceof ItemBlock) {
                            return new InfoBlock(Block.func_149634_a((Item)((ItemStack)object).func_77973_b()));
                        }
                        return new InfoItem(((ItemStack)object).func_77973_b());
                    }
                    return new InfoItemStack((ItemStack)object);
                }
                return null;
            }
        });
        InfoStack.registerType("material", InfoMaterial.class);
        InfoStack.registerObjectParser(new InfoStackObjectParser(){

            @Override
            public InfoStack parseObject(Object object) {
                if (object instanceof Material) {
                    return new InfoMaterial((Material)object);
                }
                return null;
            }
        });
        InfoStack.registerType("ore", InfoOre.class);
        InfoStack.registerObjectParser(new InfoStackObjectParser(){

            @Override
            public InfoStack parseObject(Object object) {
                if (object instanceof String) {
                    return new InfoOre((String)object);
                }
                if (object instanceof ArrayList) {
                    ArrayList oresIDs = new ArrayList();
                    ArrayList ores = (ArrayList)object;
                    for (int i = 0; i < ores.size(); ++i) {
                        ArrayList<Integer> neworesIDs = new ArrayList<Integer>();
                        int[] oreIDsofStack = OreDictionary.getOreIDs((ItemStack)((ItemStack)ores.get(i)));
                        for (int j = 0; j < oreIDsofStack.length; ++j) {
                            if (i != 0 && !oresIDs.contains(oreIDsofStack[j])) continue;
                            neworesIDs.add(oreIDsofStack[j]);
                        }
                        oresIDs = neworesIDs;
                    }
                    if (oresIDs.size() == 1) {
                        return new InfoOre(OreDictionary.getOreName((int)((Integer)oresIDs.get(0))));
                    }
                }
                return null;
            }
        });
        InfoStack.registerType("fuel", InfoFuel.class);
        displayOnCreativeTab = ReflectionHelper.findField(Block.class, (String[])new String[]{"displayOnCreativeTab", "field_149772_a"});
    }

    public static abstract class InfoStackObjectParser {
        public abstract InfoStack parseObject(Object var1);
    }
}

