/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils;

import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.creativecore.common.utils.Rotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;

public class RotationUtils {
    private static String[] facingNames;
    private static String[] horizontalFacingNames;

    public static String[] getHorizontalFacingNames() {
        if (horizontalFacingNames == null) {
            horizontalFacingNames = new String[4];
            for (int i = 0; i < horizontalFacingNames.length; ++i) {
                RotationUtils.horizontalFacingNames[i] = EnumFacing.func_176731_b((int)i).func_176610_l();
            }
        }
        return horizontalFacingNames;
    }

    public static String[] getFacingNames() {
        if (facingNames == null) {
            facingNames = new String[6];
            for (int i = 0; i < facingNames.length; ++i) {
                RotationUtils.facingNames[i] = EnumFacing.func_82600_a((int)i).func_176610_l();
            }
        }
        return facingNames;
    }

    public static int getAxisIndex(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return 0;
            }
            case Y: {
                return 1;
            }
            case Z: {
                return 2;
            }
        }
        return 0;
    }

    public static EnumFacing.Axis getAxisFromIndex(int index) {
        if (index == 0) {
            return EnumFacing.Axis.X;
        }
        if (index == 1) {
            return EnumFacing.Axis.Y;
        }
        if (index == 2) {
            return EnumFacing.Axis.Z;
        }
        return null;
    }

    public static EnumFacing getFacingFromAxis(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return EnumFacing.EAST;
            }
            case Y: {
                return EnumFacing.UP;
            }
            case Z: {
                return EnumFacing.SOUTH;
            }
        }
        return null;
    }

    public static Vec3d applyVectorRotation(Vec3d vector, EnumFacing EnumFacing2) {
        return RotationUtils.applyVectorRotation(vector, Rotation.getRotationByFacing(EnumFacing2));
    }

    public static Vec3d applyVectorRotation(Vec3d vector, Rotation EnumFacing2) {
        double tempX = vector.field_72450_a;
        double tempY = vector.field_72448_b;
        double tempZ = vector.field_72449_c;
        double posX = tempX;
        double posY = tempY;
        double posZ = tempZ;
        switch (EnumFacing2) {
            case UP: {
                posX = -tempY;
                posY = tempX;
                break;
            }
            case DOWN: {
                posX = tempY;
                posY = -tempX;
                break;
            }
            case UPX: {
                posZ = -tempY;
                posY = tempZ;
                break;
            }
            case DOWNX: {
                posZ = tempY;
                posY = -tempZ;
                break;
            }
            case SOUTH: {
                posX = -tempZ;
                posZ = tempX;
                break;
            }
            case NORTH: {
                posX = tempZ;
                posZ = -tempX;
                break;
            }
            case WEST: {
                posX = -tempX;
                posZ = -tempZ;
                break;
            }
        }
        return new Vec3d(posX, posY, posZ);
    }

    public static void applyCubeRotation(CubeObject cube, EnumFacing EnumFacing2) {
        RotationUtils.applyCubeRotation(cube, Rotation.getRotationByFacing(EnumFacing2), new Vec3d(0.5, 0.5, 0.5));
    }

    public static void applyCubeRotation(CubeObject cube, Rotation EnumFacing2, Vec3d center) {
        float minX = cube.minX;
        float minY = cube.minY;
        float minZ = cube.minZ;
        float maxX = cube.maxX;
        float maxY = cube.maxY;
        float maxZ = cube.maxZ;
        if (center != null) {
            minX = (float)((double)minX - center.field_72450_a);
            minY = (float)((double)minY - center.field_72448_b);
            minZ = (float)((double)minZ - center.field_72449_c);
            maxX = (float)((double)maxX - center.field_72450_a);
            maxY = (float)((double)maxY - center.field_72448_b);
            maxZ = (float)((double)maxZ - center.field_72449_c);
        }
        Vec3d min = RotationUtils.applyVectorRotation(new Vec3d((double)minX, (double)minY, (double)minZ), EnumFacing2);
        Vec3d max = RotationUtils.applyVectorRotation(new Vec3d((double)maxX, (double)maxY, (double)maxZ), EnumFacing2);
        if (center != null) {
            min = min.func_72441_c(center.field_72450_a, center.field_72448_b, center.field_72449_c);
            max = max.func_72441_c(center.field_72450_a, center.field_72448_b, center.field_72449_c);
        }
        if (min.field_72450_a < max.field_72450_a) {
            cube.minX = (float)min.field_72450_a;
            cube.maxX = (float)max.field_72450_a;
        } else {
            cube.minX = (float)max.field_72450_a;
            cube.maxX = (float)min.field_72450_a;
        }
        if (min.field_72448_b < max.field_72448_b) {
            cube.minY = (float)min.field_72448_b;
            cube.maxY = (float)max.field_72448_b;
        } else {
            cube.minY = (float)max.field_72448_b;
            cube.maxY = (float)min.field_72448_b;
        }
        if (min.field_72449_c < max.field_72449_c) {
            cube.minZ = (float)min.field_72449_c;
            cube.maxZ = (float)max.field_72449_c;
        } else {
            cube.minZ = (float)max.field_72449_c;
            cube.maxZ = (float)min.field_72449_c;
        }
    }

    public static EnumFacing getFacingFromVec(Vec3d vec) {
        if (vec.field_72450_a == 1.0 && vec.field_72448_b == 0.0 && vec.field_72449_c == 0.0) {
            return EnumFacing.EAST;
        }
        if (vec.field_72450_a == -1.0 && vec.field_72448_b == 0.0 && vec.field_72449_c == 0.0) {
            return EnumFacing.WEST;
        }
        if (vec.field_72450_a == 0.0 && vec.field_72448_b == 1.0 && vec.field_72449_c == 0.0) {
            return EnumFacing.UP;
        }
        if (vec.field_72450_a == 0.0 && vec.field_72448_b == -1.0 && vec.field_72449_c == 0.0) {
            return EnumFacing.DOWN;
        }
        if (vec.field_72450_a == 0.0 && vec.field_72448_b == 0.0 && vec.field_72449_c == 1.0) {
            return EnumFacing.SOUTH;
        }
        if (vec.field_72450_a == 0.0 && vec.field_72448_b == 0.0 && vec.field_72449_c == -1.0) {
            return EnumFacing.NORTH;
        }
        return null;
    }

    public static EnumFacing rotateFacing(EnumFacing facing, EnumFacing facing2) {
        Vec3d vec = new Vec3d(facing.func_176730_m());
        vec = RotationUtils.applyVectorRotation(vec, facing2);
        return EnumFacing.func_176737_a((float)((float)vec.field_72450_a), (float)((float)vec.field_72448_b), (float)((float)vec.field_72449_c));
    }
}

