/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryUtils {
    public static NBTTagCompound saveInventoryBasic(IInventory basic) {
        ItemStack[] stacks = new ItemStack[basic.func_70302_i_()];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = basic.func_70301_a(i);
        }
        return InventoryUtils.saveInventory(stacks);
    }

    public static NBTTagCompound saveInventory(ItemStack[] inventory) {
        NBTTagCompound nbtInv = new NBTTagCompound();
        for (int i = 0; i < inventory.length; ++i) {
            NBTTagCompound newNBT = new NBTTagCompound();
            if (inventory[i] != null) {
                inventory[i].func_77955_b(newNBT);
            }
            nbtInv.func_74782_a("slot" + i, (NBTBase)newNBT);
        }
        nbtInv.func_74768_a("size", inventory.length);
        return nbtInv;
    }

    public static ItemStack[] loadInventory(NBTTagCompound nbt) {
        ItemStack[] inventory = new ItemStack[nbt.func_74762_e("size")];
        for (int i = 0; i < inventory.length; ++i) {
            inventory[i] = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("slot" + i));
        }
        return inventory;
    }

    public static InventoryBasic loadInventoryBasic(NBTTagCompound nbt) {
        return InventoryUtils.loadInventoryBasic(nbt, nbt.func_74762_e("size"));
    }

    public static InventoryBasic loadInventoryBasic(NBTTagCompound nbt, int length) {
        InventoryBasic basic = new InventoryBasic("basic", false, length);
        if (nbt != null) {
            ItemStack[] stacks = InventoryUtils.loadInventory(nbt);
            for (int i = 0; i < stacks.length; ++i) {
                if (length <= i) continue;
                basic.func_70299_a(i, stacks[i]);
            }
        }
        return basic;
    }

    public static boolean isItemStackEqual(ItemStack stack, ItemStack stack2) {
        if (stack != null && stack2 != null && stack.func_77973_b() == stack2.func_77973_b() && stack.func_77952_i() == stack2.func_77952_i()) {
            if (!stack.func_77942_o() && !stack2.func_77942_o()) {
                return true;
            }
            if (stack.func_77942_o() != stack2.func_77942_o()) {
                return false;
            }
            if (stack.func_77978_p().equals((Object)stack2.func_77978_p())) {
                return true;
            }
        }
        return false;
    }

    public static boolean consumeItemStack(IInventory inventory, ItemStack stack) {
        if (InventoryUtils.getAmount(inventory, stack) >= stack.field_77994_a) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!InventoryUtils.isItemStackEqual(inventory.func_70301_a(i), stack)) continue;
                int amount = Math.min(stack.field_77994_a, inventory.func_70301_a((int)i).field_77994_a);
                if (amount > 0) {
                    inventory.func_70301_a((int)i).field_77994_a -= amount;
                    if (inventory.func_70301_a((int)i).field_77994_a <= 0) {
                        inventory.func_70299_a(i, null);
                    }
                    stack.field_77994_a -= amount;
                }
                if (stack.field_77994_a > 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack) {
        int i;
        if (stack.field_77994_a <= 0) {
            return true;
        }
        for (i = 0; i < inventory.length; ++i) {
            int amount;
            if (!InventoryUtils.isItemStackEqual(inventory[i], stack) || (amount = Math.min(64 - inventory[i].field_77994_a, stack.field_77994_a)) <= 0) continue;
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a = inventory[i].field_77994_a + amount;
            inventory[i] = newStack;
            stack.field_77994_a -= amount;
            if (stack.field_77994_a > 0) continue;
            return true;
        }
        for (i = 0; i < inventory.length; ++i) {
            if (inventory[i] != null) continue;
            inventory[i] = stack;
            return true;
        }
        return false;
    }

    public static boolean addItemStackToInventory(IInventory inventory, ItemStack stack) {
        int i;
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            int amount;
            if (!InventoryUtils.isItemStackEqual(inventory.func_70301_a(i), stack) || (amount = Math.min(64 - inventory.func_70301_a((int)i).field_77994_a, stack.field_77994_a)) <= 0) continue;
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a = inventory.func_70301_a((int)i).field_77994_a + amount;
            inventory.func_70299_a(i, newStack);
            stack.field_77994_a -= amount;
            if (stack.field_77994_a > 0) continue;
            return true;
        }
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) != null) continue;
            inventory.func_70299_a(i, stack);
            return true;
        }
        return false;
    }

    public static int getAmount(IInventory inventory, ItemStack stack) {
        int amount = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!InventoryUtils.isItemStackEqual(inventory.func_70301_a(i), stack)) continue;
            amount += inventory.func_70301_a((int)i).field_77994_a;
        }
        return amount;
    }

    public static void cleanInventory(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a != 0) continue;
            inventory.func_70299_a(i, null);
        }
    }
}

