/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.client.rendering.model;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedQuad;
import com.creativemd.creativecore.client.rendering.model.CreativeVertexBufferConsumer;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.pipeline.BlockInfo;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class CreativeCubeConsumer {
    public final VertexFormat format;
    protected int vertices = 0;
    protected byte[] dataLength = null;
    protected float[][][] quadData = null;
    protected final BlockInfo blockInfo;
    private int tint = -1;
    private boolean diffuse = true;
    protected int posIndex = -1;
    protected int normalIndex = -1;
    protected int colorIndex = -1;
    protected int lightmapIndex = -1;
    public CreativeBakedQuad quad;
    public RenderCubeObject cube;
    public VertexBuffer buffer;
    public BlockRenderLayer layer;
    private final CreativeVertexBufferConsumer parent;

    public BlockInfo getBlockInfo() {
        return this.blockInfo;
    }

    public CreativeCubeConsumer(VertexFormat format, BlockColors colors) {
        this.format = format;
        this.blockInfo = new BlockInfo(colors);
        block6: for (int i = 0; i < format.func_177345_h(); ++i) {
            switch (format.func_177348_c(i).func_177375_c()) {
                case POSITION: {
                    this.posIndex = i;
                    continue block6;
                }
                case NORMAL: {
                    this.normalIndex = i;
                    continue block6;
                }
                case COLOR: {
                    this.colorIndex = i;
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(i).func_177369_e() != 1) continue block6;
                    this.lightmapIndex = i;
                    continue block6;
                }
            }
        }
        if (this.posIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with position");
        }
        if (this.lightmapIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with lightmap");
        }
        if (this.colorIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with color");
        }
        this.parent = new CreativeVertexBufferConsumer(this);
        this.dataLength = new byte[format.func_177345_h()];
        this.quadData = new float[format.func_177345_h()][4][4];
    }

    public void put(int element, float ... data) {
        System.arraycopy(data, 0, this.quadData[element][this.vertices], 0, data.length);
        if (element == this.format.func_177345_h() - 1) {
            ++this.vertices;
        }
        if (this.vertices == 0) {
            this.dataLength[element] = (byte)data.length;
        } else if (this.vertices == 4) {
            this.vertices = 0;
            this.processQuad();
        }
    }

    protected void processQuad() {
        float[][] position = this.quadData[this.posIndex];
        float[][] normal = null;
        float[][] lightmap = this.quadData[this.lightmapIndex];
        float[][] color = this.quadData[this.colorIndex];
        normal = new float[4][4];
        Vector3f v1 = new Vector3f(position[3]);
        Vector3f t = new Vector3f(position[1]);
        Vector3f v2 = new Vector3f(position[2]);
        v1.sub((Tuple3f)t);
        t.set(position[0]);
        v2.sub((Tuple3f)t);
        v1.cross(v2, v1);
        v1.normalize();
        for (int v = 0; v < 4; ++v) {
            normal[v][0] = v1.x;
            normal[v][1] = v1.y;
            normal[v][2] = v1.z;
            normal[v][3] = 0.0f;
        }
        int multiplier = -1;
        if (this.tint != -1 && this.cube.color == -1) {
            multiplier = this.blockInfo.getColorMultiplier(this.tint);
        } else {
            if (this.layer != BlockRenderLayer.CUTOUT_MIPPED && this.cube.getBlockState().func_177230_c().func_180664_k() != BlockRenderLayer.CUTOUT) {
                this.tint = 0;
            }
            multiplier = this.cube.color;
        }
        int count = this.format.func_177345_h();
        for (int v = 0; v < 4; ++v) {
            float[] fArray = position[v];
            fArray[0] = fArray[0] + this.blockInfo.getShx();
            float[] fArray2 = position[v];
            fArray2[1] = fArray2[1] + this.blockInfo.getShy();
            float[] fArray3 = position[v];
            fArray3[2] = fArray3[2] + this.blockInfo.getShz();
            float x = position[v][0] - 0.5f;
            float y = position[v][1] - 0.5f;
            float z = position[v][2] - 0.5f;
            float blockLight = lightmap[v][0];
            float skyLight = lightmap[v][1];
            this.updateLightmap(normal[v], lightmap[v], x += normal[v][0] * 0.5f, y += normal[v][1] * 0.5f, z += normal[v][2] * 0.5f);
            if (this.dataLength[this.lightmapIndex] > 1) {
                if (blockLight > lightmap[v][0]) {
                    lightmap[v][0] = blockLight;
                }
                if (skyLight > lightmap[v][1]) {
                    lightmap[v][1] = skyLight;
                }
            }
            this.updateColor(normal[v], color[v], x, y, z, this.tint, multiplier);
            if (this.diffuse) {
                float d = LightUtil.diffuseLight((float)normal[v][0], (float)normal[v][1], (float)normal[v][2]);
                int i = 0;
                while (i < 3) {
                    float[] fArray4 = color[v];
                    int n = i++;
                    fArray4[n] = fArray4[n] * d;
                }
            }
            if (EntityRenderer.field_78517_a) {
                this.applyAnaglyph(color[v]);
            }
            block9: for (int e = 0; e < count; ++e) {
                VertexFormatElement element = this.format.func_177348_c(e);
                switch (element.func_177375_c()) {
                    case POSITION: {
                        this.parent.put(e, position[v]);
                        continue block9;
                    }
                    case NORMAL: {
                        if (this.normalIndex != -1) {
                            this.parent.put(e, normal[v]);
                            continue block9;
                        }
                    }
                    case COLOR: {
                        this.parent.put(e, color[v]);
                        continue block9;
                    }
                    case UV: {
                        if (element.func_177369_e() == 1) {
                            this.parent.put(e, lightmap[v]);
                            continue block9;
                        }
                    }
                    default: {
                        this.parent.put(e, this.quadData[e][v]);
                    }
                }
            }
        }
        this.tint = -1;
    }

    protected void applyAnaglyph(float[] color) {
        float r = color[0];
        color[0] = (r * 30.0f + color[1] * 59.0f + color[2] * 11.0f) / 100.0f;
        color[1] = (r * 3.0f + color[1] * 7.0f) / 10.0f;
        color[2] = (r * 3.0f + color[2] * 7.0f) / 10.0f;
    }

    public void setQuadTint(int tint) {
        this.tint = tint;
    }

    public void setQuadOrientation(EnumFacing orientation) {
    }

    public void setQuadCulled() {
    }

    public void setTexture(TextureAtlasSprite texture) {
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
        this.diffuse = diffuse;
    }

    public void setWorld(IBlockAccess world) {
        this.blockInfo.setWorld(world);
    }

    public void setState(IBlockState state) {
        this.blockInfo.setState(state);
    }

    public void setBlockPos(BlockPos blockPos) {
        this.blockInfo.setBlockPos(blockPos);
    }

    protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
        lightmap[0] = this.calcLightmap(this.blockInfo.getBlockLight(), x, y, z);
        lightmap[1] = this.calcLightmap(this.blockInfo.getSkyLight(), x, y, z);
    }

    protected void updateColor(float[] normal, float[] color, float x, float y, float z, float tint, int multiplier) {
        if (tint != -1.0f) {
            color[0] = color[0] * ((float)(multiplier >> 16 & 0xFF) / 255.0f);
            color[1] = color[1] * ((float)(multiplier >> 8 & 0xFF) / 255.0f);
            color[2] = color[2] * ((float)(multiplier & 0xFF) / 255.0f);
        }
        float a = this.getAo(x, y, z);
        color[0] = color[0] * a;
        color[1] = color[1] * a;
        color[2] = color[2] * a;
    }

    protected float calcLightmap(float[][][][] light, float x, float y, float z) {
        float s;
        float l2;
        if ((l2 = (x *= 2.0f) * x + (y *= 2.0f) * y + (z *= 2.0f) * z) > 5.98f) {
            float s2 = (float)Math.sqrt(5.98f / l2);
            x *= s2;
            y *= s2;
            z *= s2;
        }
        float ax = x > 0.0f ? x : -x;
        float ay = y > 0.0f ? y : -y;
        float az = z > 0.0f ? z : -z;
        float e1 = 1.0001f;
        if (ax > 1.9999f && ay <= e1 && az <= e1) {
            if (x > -1.9999f) {
                x = -1.9999f;
            }
            if (x < 1.9999f) {
                x = 1.9999f;
            }
        } else if (ay > 1.9999f && az <= e1 && ax <= e1) {
            if (y > -1.9999f) {
                y = -1.9999f;
            }
            if (y < 1.9999f) {
                y = 1.9999f;
            }
        } else if (az > 1.9999f && ax <= e1 && ay <= e1) {
            if (z > -1.9999f) {
                z = -1.9999f;
            }
            if (z < 1.9999f) {
                z = 1.9999f;
            }
        }
        ax = x > 0.0f ? x : -x;
        ay = y > 0.0f ? y : -y;
        float f = az = z > 0.0f ? z : -z;
        if (ax <= e1 && ay + az > 2.9999f) {
            s = 2.9999f / (ay + az);
            y *= s;
            z *= s;
        } else if (ay <= e1 && az + ax > 2.9999f) {
            s = 2.9999f / (az + ax);
            z *= s;
            x *= s;
        } else if (az <= e1 && ax + ay > 2.9999f) {
            s = 2.9999f / (ax + ay);
            x *= s;
            y *= s;
        } else if (ax + ay + az > 3.9999f) {
            s = 3.9999f / (ax + ay + az);
            x *= s;
            y *= s;
            z *= s;
        }
        float l = 0.0f;
        float s3 = 0.0f;
        for (int ix = 0; ix <= 1; ++ix) {
            for (int iy = 0; iy <= 1; ++iy) {
                for (int iz = 0; iz <= 1; ++iz) {
                    float vx = x * (float)(1 - ix * 2);
                    float vy = y * (float)(1 - iy * 2);
                    float vz = z * (float)(1 - iz * 2);
                    float s32 = vx + vy + vz + 4.0f;
                    float sx = vy + vz + 3.0f;
                    float sy = vz + vx + 3.0f;
                    float sz = vx + vy + 3.0f;
                    float bx = (2.0f * vx + vy + vz + 6.0f) / (s32 * sy * sz * (vx + 2.0f));
                    s3 += bx;
                    l += bx * light[0][ix][iy][iz];
                    float by = (2.0f * vy + vz + vx + 6.0f) / (s32 * sz * sx * (vy + 2.0f));
                    s3 += by;
                    l += by * light[1][ix][iy][iz];
                    float bz = (2.0f * vz + vx + vy + 6.0f) / (s32 * sx * sy * (vz + 2.0f));
                    s3 += bz;
                    l += bz * light[2][ix][iy][iz];
                }
            }
        }
        if ((l /= s3) > 0.0073243305f) {
            l = 0.0073243305f;
        }
        if (l < 0.0f) {
            l = 0.0f;
        }
        return l;
    }

    protected float getAo(float x, float y, float z) {
        int sz;
        int sx = x < 0.0f ? 1 : 2;
        int sy = y < 0.0f ? 1 : 2;
        int n = sz = z < 0.0f ? 1 : 2;
        if (x < 0.0f) {
            x += 1.0f;
        }
        if (y < 0.0f) {
            y += 1.0f;
        }
        if (z < 0.0f) {
            z += 1.0f;
        }
        float a = 0.0f;
        float[][][] ao = this.blockInfo.getAo();
        a += ao[sx - 1][sy - 1][sz - 1] * (1.0f - x) * (1.0f - y) * (1.0f - z);
        a += ao[sx - 1][sy - 1][sz - 0] * (1.0f - x) * (1.0f - y) * (0.0f + z);
        a += ao[sx - 1][sy - 0][sz - 1] * (1.0f - x) * (0.0f + y) * (1.0f - z);
        a += ao[sx - 1][sy - 0][sz - 0] * (1.0f - x) * (0.0f + y) * (0.0f + z);
        a += ao[sx - 0][sy - 1][sz - 1] * (0.0f + x) * (1.0f - y) * (1.0f - z);
        a += ao[sx - 0][sy - 1][sz - 0] * (0.0f + x) * (1.0f - y) * (0.0f + z);
        a += ao[sx - 0][sy - 0][sz - 1] * (0.0f + x) * (0.0f + y) * (1.0f - z);
        a += ao[sx - 0][sy - 0][sz - 0] * (0.0f + x) * (0.0f + y) * (0.0f + z);
        a = MathHelper.func_76131_a((float)a, (float)0.0f, (float)1.0f);
        return a;
    }

    public void updateBlockInfo() {
        this.blockInfo.updateShift(false);
        this.blockInfo.updateLightMatrix();
    }
}

