/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.client.rendering;

import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.common.utils.CubeObject;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderCubeObject
extends CubeObject {
    public Block block;
    public int meta = 0;
    public int color = -1;
    public Object customData = null;
    public boolean keepVU = false;
    private EnumSideRender renderEast = EnumSideRender.INSIDE_RENDERED;
    private EnumSideRender renderWest = EnumSideRender.INSIDE_RENDERED;
    private EnumSideRender renderUp = EnumSideRender.INSIDE_RENDERED;
    private EnumSideRender renderDown = EnumSideRender.INSIDE_RENDERED;
    private EnumSideRender renderSouth = EnumSideRender.INSIDE_RENDERED;
    private EnumSideRender renderNorth = EnumSideRender.INSIDE_RENDERED;
    private List<BakedQuad> quadEast = null;
    private List<BakedQuad> quadWest = null;
    private List<BakedQuad> quadUp = null;
    private List<BakedQuad> quadDown = null;
    private List<BakedQuad> quadSouth = null;
    private List<BakedQuad> quadNorth = null;
    public boolean doesNeedQuadUpdate = true;

    public void setQuad(EnumFacing facing, List<BakedQuad> quad) {
        switch (facing) {
            case DOWN: {
                this.quadDown = quad;
                break;
            }
            case EAST: {
                this.quadEast = quad;
                break;
            }
            case NORTH: {
                this.quadNorth = quad;
                break;
            }
            case SOUTH: {
                this.quadSouth = quad;
                break;
            }
            case UP: {
                this.quadUp = quad;
                break;
            }
            case WEST: {
                this.quadWest = quad;
            }
        }
    }

    public List<BakedQuad> getQuad(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return this.quadDown;
            }
            case EAST: {
                return this.quadEast;
            }
            case NORTH: {
                return this.quadNorth;
            }
            case SOUTH: {
                return this.quadSouth;
            }
            case UP: {
                return this.quadUp;
            }
            case WEST: {
                return this.quadWest;
            }
        }
        return null;
    }

    public RenderCubeObject(CubeObject cube, RenderCubeObject cube2) {
        super(cube);
        this.applyExtraCubeData(cube2);
    }

    public RenderCubeObject(CubeObject cube, Block block, int meta) {
        super(cube);
        this.block = block;
        this.meta = meta;
    }

    public RenderCubeObject(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Block block) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.block = block;
    }

    public RenderCubeObject(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Block block, int meta) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.block = block;
        this.meta = meta;
    }

    @Override
    protected void applyExtraCubeData(CubeObject cube) {
        if (cube instanceof RenderCubeObject) {
            this.block = ((RenderCubeObject)cube).block;
            this.meta = ((RenderCubeObject)cube).meta;
            this.color = ((RenderCubeObject)cube).color;
            this.renderEast = ((RenderCubeObject)cube).renderEast;
            this.renderWest = ((RenderCubeObject)cube).renderWest;
            this.renderUp = ((RenderCubeObject)cube).renderUp;
            this.renderDown = ((RenderCubeObject)cube).renderDown;
            this.renderSouth = ((RenderCubeObject)cube).renderSouth;
            this.renderNorth = ((RenderCubeObject)cube).renderNorth;
        }
    }

    public RenderCubeObject setColor(Vec3i color) {
        this.setColor(ColorUtils.RGBToInt(color));
        return this;
    }

    public RenderCubeObject setColor(int color) {
        this.color = color;
        return this;
    }

    public IBlockState getBlockState() {
        if (this.meta != -1) {
            return this.block.func_176203_a(this.meta);
        }
        return this.block.func_176223_P();
    }

    public IBlockState getBlockState(Block block) {
        if (this.meta != -1) {
            return block.func_176203_a(this.meta);
        }
        return block.func_176223_P();
    }

    public void setSideRender(EnumFacing facing, EnumSideRender renderer) {
        switch (facing) {
            case DOWN: {
                this.renderDown = renderer;
                break;
            }
            case EAST: {
                this.renderEast = renderer;
                break;
            }
            case NORTH: {
                this.renderNorth = renderer;
                break;
            }
            case SOUTH: {
                this.renderSouth = renderer;
                break;
            }
            case UP: {
                this.renderUp = renderer;
                break;
            }
            case WEST: {
                this.renderWest = renderer;
            }
        }
    }

    public EnumSideRender getSidedRendererType(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return this.renderDown;
            }
            case EAST: {
                return this.renderEast;
            }
            case NORTH: {
                return this.renderNorth;
            }
            case SOUTH: {
                return this.renderSouth;
            }
            case UP: {
                return this.renderUp;
            }
            case WEST: {
                return this.renderWest;
            }
        }
        return EnumSideRender.INSIDE_RENDERED;
    }

    public boolean shouldSideBeRendered(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return this.renderDown.shouldBeRendered;
            }
            case EAST: {
                return this.renderEast.shouldBeRendered;
            }
            case NORTH: {
                return this.renderNorth.shouldBeRendered;
            }
            case SOUTH: {
                return this.renderSouth.shouldBeRendered;
            }
            case UP: {
                return this.renderUp.shouldBeRendered;
            }
            case WEST: {
                return this.renderWest.shouldBeRendered;
            }
        }
        return true;
    }

    public static enum EnumSideRender {
        INSIDE_RENDERED(true, false),
        INSIDE_NOT_RENDERED(false, false),
        OUTSIDE_RENDERED(true, true),
        OUTSIDE_NOT_RENDERD(false, true);

        public final boolean shouldBeRendered;
        public final boolean outside;

        private EnumSideRender(boolean shouldBeRendered, boolean outside) {
            this.shouldBeRendered = shouldBeRendered;
            this.outside = outside;
        }
    }
}

