/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.util.BlockUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityUtils {
    public static IInventory getInventory(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            if (inventory instanceof TileEntityChest) {
                TileEntityChest first = (TileEntityChest)tileEntity;
                TileEntityChest second = null;
                for (BlockPos adjacentPos : BlockUtils.getAdjacent(pos, false)) {
                    TileEntity suspect = world.func_175625_s(adjacentPos);
                    if (!(suspect instanceof TileEntityChest)) continue;
                    second = (TileEntityChest)suspect;
                    break;
                }
                if (second != null) {
                    return new InventoryLargeChest("large chest", (ILockableContainer)first, second);
                }
            }
            return inventory;
        }
        return null;
    }

    public static IItemHandler getIItemHandler(World world, BlockPos pos, EnumFacing facing) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
        }
        return null;
    }
}

