/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import java.io.File;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class CommonUtils {
    public static boolean isClientWorld(World world) {
        return world.field_72995_K;
    }

    public static boolean isServerWorld(World world) {
        return !world.field_72995_K;
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public static File getSaveLocation(World world) {
        File base = DimensionManager.getCurrentSaveRootDirectory();
        return world.field_73011_w.getDimension() == 0 ? base : new File(base, world.field_73011_w.getSaveFolder());
    }

    public static File getSaveLocation(int dim) {
        return CommonUtils.getSaveLocation((World)DimensionManager.getWorld((int)dim));
    }

    public static String getWorldName(World world) {
        return world.func_72912_H().func_76065_j();
    }

    public static int getDimension(World world) {
        return world.field_73011_w.getDimension();
    }

    public static File getMinecraftDir() {
        return (File)FMLInjectionData.data()[6];
    }

    public static String getRelativePath(File parent, File child) {
        if (parent.isFile() || !child.getPath().startsWith(parent.getPath())) {
            return null;
        }
        return child.getPath().substring(parent.getPath().length() + 1);
    }

    @Deprecated
    public static void registerHandledEntity(Class<? extends Entity> entityClass, String identifier) {
        EntityList.field_75626_c.put(entityClass, identifier);
        EntityList.field_75625_b.put(identifier, entityClass);
    }
}

