/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakery;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.model.bakery.CCQuad;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UV;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;

@Deprecated
public class CCQuadBakery {
    private VertexFormat format;
    private TextureAtlasSprite sprite;
    private EnumFacing face;
    private UV uv = new UV();
    private Vector3 normal = null;
    private Colour colour = new ColourRGBA(-1);
    private int brightness = 0;
    private boolean isBakingTriModel = false;
    private boolean applyDifuseLighting = true;
    private LinkedList<BakedQuad> bakedQuads = null;
    private CCQuad quad = null;
    private int index = 0;

    public CCQuadBakery(TextureAtlasSprite sprite) {
        this(DefaultVertexFormats.field_176600_a, sprite);
    }

    public CCQuadBakery(VertexFormat format, TextureAtlasSprite sprite) {
        this.format = format;
        this.sprite = sprite;
    }

    public CCQuadBakery startBakingQuads() {
        return this.startBaking(false);
    }

    public CCQuadBakery startBakingTriangles() {
        return this.startBaking(true);
    }

    private CCQuadBakery startBaking(boolean isTriangles) {
        if (this.quad != null || this.bakedQuads != null) {
            throw new IllegalStateException("Quads are still baking or baking has not finished yet!");
        }
        this.isBakingTriModel = isTriangles;
        this.bakedQuads = new LinkedList();
        return this;
    }

    public ImmutableList<BakedQuad> finishBaking() {
        if (this.quad != null) {
            throw new IllegalStateException("Quads are still baking!");
        }
        if (this.bakedQuads == null) {
            throw new IllegalStateException("The bakery has no baked quads!");
        }
        ImmutableList returnQuads = ImmutableList.copyOf(this.bakedQuads);
        this.reset();
        return returnQuads;
    }

    public boolean hasIncompleteQuad() {
        return this.quad != null;
    }

    public void reset() {
        this.applyDifuseLighting = true;
        this.isBakingTriModel = false;
        this.bakedQuads = null;
        this.quad = null;
        this.index = 0;
    }

    public CCQuadBakery setSprite(TextureAtlasSprite sprite) {
        if (this.sprite == sprite) {
            return this;
        }
        if (this.quad != null) {
            throw new IllegalStateException("Unable to set sprite whilst quad is still baking!");
        }
        this.sprite = sprite;
        return this;
    }

    public CCQuadBakery setFace(EnumFacing face) {
        if (this.quad != null) {
            throw new IllegalStateException("Unable to set face whilst quad is still baking!");
        }
        this.face = face;
        return this;
    }

    public CCQuadBakery disableDifuseLighting() {
        return this.setDifuseLightingState(false);
    }

    public CCQuadBakery setDifuseLightingState(boolean state) {
        this.applyDifuseLighting = state;
        return this;
    }

    public CCQuadBakery setColour(int colour) {
        return this.setColour(new ColourRGBA(colour));
    }

    public CCQuadBakery setColour(Colour colour) {
        this.colour = colour.copy();
        return this;
    }

    public CCQuadBakery setLightMap(int brightness) {
        this.brightness = brightness;
        return this;
    }

    public CCQuadBakery setNormal(Vector3 normal) {
        this.normal = normal;
        return this;
    }

    public CCQuadBakery setUV(double u, double v) {
        return this.setUV(new UV(u, v));
    }

    public CCQuadBakery setUV(UV uv) {
        this.uv = uv.copy();
        return this;
    }

    public CCQuadBakery addVertexWithUV(Vector3 vertex, double u, double v) {
        return this.addVertexWithUV(vertex, new UV(u, v));
    }

    public CCQuadBakery addVertexWithUV(double x, double y, double z, UV uv) {
        return this.addVertexWithUV(new Vector3(x, y, z), uv);
    }

    public CCQuadBakery addVertexWithUV(double x, double y, double z, double u, double v) {
        return this.addVertexWithUV(new Vector3(x, y, z), new UV(u, v));
    }

    public CCQuadBakery addVertexWithUV(Vector3 vertex, UV uv) {
        return this.addVertexWithUV(new Vertex5(vertex, uv));
    }

    public CCQuadBakery addVertexWithUV(Vertex5 vertex) {
        this.setUV(vertex.uv);
        return this.addVertex(vertex.vec);
    }

    public CCQuadBakery addVertex(double x, double y, double z) {
        return this.addVertex(new Vector3(x, y, z));
    }

    public CCQuadBakery addVertex(Vector3 vertex) {
        int max;
        if (this.quad == null) {
            this.quad = new CCQuad();
            if (this.face != null) {
                this.quad.face = this.face;
            }
            this.quad.sprite = this.sprite;
            this.quad.applyDifuseLighting = this.applyDifuseLighting;
            this.index = 0;
        }
        this.quad.vertices[this.index] = new Vertex5(vertex.copy(), this.uv.copy());
        this.quad.normals[this.index] = this.normal != null ? this.normal.copy() : null;
        this.quad.colours[this.index] = this.colour.copy();
        this.quad.lightMaps[this.index] = this.brightness;
        ++this.index;
        int n = max = this.isBakingTriModel ? 3 : 4;
        if (this.index == max) {
            this.index = 0;
            this.bakedQuads.add(this.quad.bake(this.format));
            this.quad = null;
        }
        return this;
    }
}

