/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakery;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.model.bakery.UnpackingVertexConsumer;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.Copyable;
import codechicken.lib.util.VectorUtils;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UV;
import codechicken.lib.vec.uv.UVTransformation;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.IVertexProducer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class CCQuad
implements Copyable<CCQuad>,
IVertexProducer {
    public Vertex5[] vertices = new Vertex5[4];
    public Vector3[] normals = new Vector3[4];
    public Colour[] colours = new Colour[4];
    public Integer[] lightMaps = new Integer[4];
    public EnumFacing face = null;
    public int tintIndex = -1;
    public boolean applyDifuseLighting = true;
    public TextureAtlasSprite sprite;

    public CCQuad() {
    }

    public CCQuad(Vertex5 ... vertices) {
        if (vertices.length > 4) {
            throw new IllegalArgumentException("CCQuad is a... Quad.. only 3 or 4 vertices allowed!");
        }
        for (int i = 0; i < 4; ++i) {
            this.vertices[i] = vertices[i].copy();
        }
    }

    public CCQuad(BakedQuad quad) {
        this();
        VertexFormat format = quad.getFormat();
        this.face = quad.func_178210_d();
        this.tintIndex = quad.func_178211_c();
        this.sprite = quad.func_187508_a();
        ArrayUtils.fillArray(this.vertices, new Vertex5());
        UnpackingVertexConsumer consumer = new UnpackingVertexConsumer(quad.getFormat());
        quad.pipe((IVertexConsumer)consumer);
        float[][][] unpackedData = consumer.getUnpackedData();
        for (int v = 0; v < 4; ++v) {
            block7: for (int e = 0; e < format.func_177345_h(); ++e) {
                float[] data = unpackedData[v][e];
                switch (format.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        this.vertices[v].vec.set(data);
                        continue block7;
                    }
                    case NORMAL: {
                        this.normals[v] = new Vector3(data);
                        continue block7;
                    }
                    case COLOR: {
                        this.colours[v] = new ColourRGBA(data[0], data[1], data[2], data[3]);
                        continue block7;
                    }
                    case UV: {
                        if (format.func_177348_c(e).func_177369_e() == 0) {
                            this.vertices[v].uv.set(data[0], data[1]);
                            continue block7;
                        }
                        this.lightMaps[v] = (int)(data[1] * 65535.0f / 32.0f) << 20 | (int)(data[0] * 65535.0f / 32.0f) << 4;
                        continue block7;
                    }
                }
            }
        }
        if (!format.func_177346_d()) {
            ArrayUtils.fillArray(this.colours, new ColourRGBA(-1));
        }
        if (!format.func_177347_a(1)) {
            ArrayUtils.fillArray(this.lightMaps, 0);
        }
        if (!format.func_177350_b()) {
            this.computeNormals();
        }
    }

    public CCQuad(CCQuad quad) {
        this();
        int i;
        for (i = 0; i < this.vertices.length; ++i) {
            this.vertices[i] = quad.vertices[i].copy();
        }
        for (i = 0; i < this.vertices.length; ++i) {
            this.normals[i] = quad.normals[i].copy();
        }
        for (i = 0; i < this.vertices.length; ++i) {
            this.colours[i] = quad.colours[i].copy();
        }
        System.arraycopy(quad.lightMaps, 0, this.lightMaps, 0, this.vertices.length);
        this.face = quad.face;
        this.tintIndex = quad.tintIndex;
        this.applyDifuseLighting = quad.applyDifuseLighting;
        this.sprite = quad.sprite;
    }

    public void apply(Transformation ... transforms) {
        for (Transformation t : transforms) {
            this.apply(t);
        }
    }

    public void apply(UVTransformation ... transforms) {
        for (UVTransformation t : transforms) {
            this.apply(t);
        }
    }

    public void apply(Transformation t) {
        this.quadulate();
        if (ArrayUtils.countNoNull(this.normals) != 4) {
            this.computeNormals();
        }
        for (int i = 0; i < 4; ++i) {
            Vertex5 vert = this.vertices[i];
            Vector3 normal = this.normals[i];
            t.apply(vert.vec);
            t.applyN(normal);
        }
    }

    public void apply(UVTransformation t) {
        this.quadulate();
        for (int i = 0; i < 4; ++i) {
            Vertex5 vert = this.vertices[i];
            t.apply(vert.uv);
        }
    }

    public boolean isQuads() {
        int counter = ArrayUtils.countNoNull(this.vertices);
        return counter == 4;
    }

    public boolean hasTint() {
        return this.tintIndex != -1;
    }

    public void quadulate() {
        int verticesCount = ArrayUtils.countNoNull(this.vertices);
        int normalCount = ArrayUtils.countNoNull(this.normals);
        int colourCount = ArrayUtils.countNoNull(this.colours);
        int lightMapCount = ArrayUtils.countNoNull(this.lightMaps);
        if (verticesCount == 3) {
            this.vertices[3] = this.vertices[2].copy();
        }
        if (normalCount == 3) {
            this.normals[3] = this.normals[2].copy();
        }
        if (colourCount == 3) {
            this.colours[3] = this.colours[2].copy();
        }
        if (lightMapCount == 3) {
            this.lightMaps[3] = this.lightMaps[2];
        }
    }

    public void computeNormals() {
        if (ArrayUtils.countNoNull(this.normals) != 4) {
            this.quadulate();
            Vector3 normal = VectorUtils.calculateNormal(this.vertices[0].vec, this.vertices[1].vec, this.vertices[3].vec);
            for (int i = 0; i < 4; ++i) {
                this.normals[i] = normal.copy();
            }
        }
    }

    public EnumFacing getQuadFace() {
        if (this.face == null) {
            if (ArrayUtils.countNoNull(this.normals) != 4) {
                this.computeNormals();
            }
            this.face = VectorUtils.calcNormalSide(this.normals[0]);
        }
        return this.face;
    }

    public BakedQuad bake() {
        return this.bake(DefaultVertexFormats.field_176600_a);
    }

    public BakedQuad bake(VertexFormat format) {
        this.quadulate();
        this.computeNormals();
        UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(format);
        quadBuilder.setApplyDiffuseLighting(this.applyDifuseLighting);
        quadBuilder.setTexture(this.sprite);
        quadBuilder.setQuadOrientation(this.getQuadFace());
        quadBuilder.setQuadTint(this.tintIndex);
        for (int v = 0; v < 4; ++v) {
            block7: for (int e = 0; e < format.func_177345_h(); ++e) {
                VertexFormatElement element = format.func_177348_c(e);
                switch (element.func_177375_c()) {
                    case POSITION: {
                        Vector3 pos = this.vertices[v].vec;
                        quadBuilder.put(e, new float[]{(float)pos.x, (float)pos.y, (float)pos.z, 1.0f});
                        continue block7;
                    }
                    case NORMAL: {
                        Vector3 normal = this.normals[v];
                        quadBuilder.put(e, new float[]{(float)normal.x, (float)normal.y, (float)normal.z, 0.0f});
                        continue block7;
                    }
                    case COLOR: {
                        Colour colour = this.colours[v];
                        quadBuilder.put(e, new float[]{(colour.r & 0xFF) / 255, (colour.g & 0xFF) / 255, (colour.b & 0xFF) / 255, (colour.a & 0xFF) / 255});
                        continue block7;
                    }
                    case UV: {
                        if (element.func_177369_e() == 0) {
                            UV uv = this.vertices[v].uv;
                            quadBuilder.put(e, new float[]{(float)uv.u, (float)uv.v, 0.0f, 1.0f});
                            continue block7;
                        }
                        int brightness = this.lightMaps[v];
                        quadBuilder.put(e, new float[]{(float)(brightness >> 4 & 0x1E0) / 65535.0f, (float)(brightness >> 20 & 0x1E0) / 65535.0f, 0.0f, 1.0f});
                        continue block7;
                    }
                    default: {
                        quadBuilder.put(e, new float[0]);
                    }
                }
            }
        }
        return quadBuilder.build();
    }

    public void pipe(IVertexConsumer consumer) {
        this.quadulate();
        this.computeNormals();
        consumer.setApplyDiffuseLighting(this.applyDifuseLighting);
        consumer.setTexture(this.sprite);
        consumer.setQuadOrientation(this.getQuadFace());
        consumer.setQuadTint(this.tintIndex);
        for (int v = 0; v < 4; ++v) {
            block7: for (int e = 0; e < consumer.getVertexFormat().func_177345_h(); ++e) {
                VertexFormatElement element = consumer.getVertexFormat().func_177348_c(e);
                switch (element.func_177375_c()) {
                    case POSITION: {
                        Vector3 pos = this.vertices[v].vec;
                        consumer.put(e, new float[]{(float)pos.x, (float)pos.y, (float)pos.z, 1.0f});
                        continue block7;
                    }
                    case NORMAL: {
                        Vector3 normal = this.normals[v];
                        consumer.put(e, new float[]{(float)normal.x, (float)normal.y, (float)normal.z, 0.0f});
                        continue block7;
                    }
                    case COLOR: {
                        Colour colour = this.colours[v];
                        consumer.put(e, new float[]{(colour.r & 0xFF) / 255, (colour.g & 0xFF) / 255, (colour.b & 0xFF) / 255, (colour.a & 0xFF) / 255});
                        continue block7;
                    }
                    case UV: {
                        if (element.func_177369_e() == 0) {
                            UV uv = this.vertices[v].uv;
                            consumer.put(e, new float[]{(float)uv.u, (float)uv.v, 0.0f, 1.0f});
                            continue block7;
                        }
                        int brightness = this.lightMaps[v];
                        consumer.put(e, new float[]{(float)(brightness >> 4 & 0x1E0) / 65535.0f, (float)(brightness >> 20 & 0x1E0) / 65535.0f, 0.0f, 1.0f});
                        continue block7;
                    }
                    default: {
                        consumer.put(e, new float[0]);
                    }
                }
            }
        }
    }

    public static List<CCQuad> fromArray(List<BakedQuad> bakedQuads) {
        LinkedList<CCQuad> quads = new LinkedList<CCQuad>();
        for (BakedQuad quad : bakedQuads) {
            quads.add(new CCQuad(quad));
        }
        return quads;
    }

    @Override
    public CCQuad copy() {
        return new CCQuad(this);
    }
}

