/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.lib.util.ReflectionManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;

public class ModDescriptionEnhancer {
    public static void enhanceMod(Object mod) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        mc.getMetadata().description = ModDescriptionEnhancer.enhanceDesc(mc.getMetadata().description);
    }

    public static String enhanceDesc(String desc) {
        int supportersIdx = desc.indexOf("Supporters:");
        if (supportersIdx < 0) {
            return desc;
        }
        String supportersList = desc.substring(supportersIdx);
        supportersList = supportersList.replaceAll("\\b(\\w+)\\b", TextFormatting.AQUA + "$1");
        return desc.substring(0, supportersIdx) + supportersList;
    }

    public static void setUpdateStatus(String modId, ForgeVersion.Status status, ComparableVersion version) {
        try {
            ModContainer modContainer = FMLCommonHandler.instance().findContainerFor((Object)modId);
            HashMap changes = new HashMap();
            ForgeVersion.CheckResult result = (ForgeVersion.CheckResult)ReflectionManager.newInstance(ForgeVersion.CheckResult.class, (Object[])new Object[]{status, version, changes, ""});
            ModDescriptionEnhancer.setUpdateStatus(modContainer, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUpdateStatus(ModContainer container, ForgeVersion.CheckResult result) {
        try {
            Map resultMap;
            Map map = resultMap = (Map)ReflectionManager.getField(ForgeVersion.class, Map.class, null, (String)"results");
            synchronized (map) {
                resultMap.put(container, result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

