/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;

@ParametersAreNonnullByDefault
public class SoundUtil {
    public static SoundEvent getSound(EntityPlayer player, @Nullable ItemStack chisel, @Nullable IBlockState target) {
        if (target != null && chisel != null && chisel.func_77973_b() instanceof IChiselItem) {
            return Optional.ofNullable(((IChiselItem)chisel.func_77973_b()).getOverrideSound(player.func_130014_f_(), player, chisel, target)).orElse(CarvingUtils.getChiselRegistry().getVariationSound(target));
        }
        return CarvingUtils.getChiselRegistry().getVariationSound(target);
    }

    public static void playSound(EntityPlayer player, @Nullable ItemStack chisel, @Nullable IBlockState target) {
        SoundEvent sound = SoundUtil.getSound(player, chisel, target);
        SoundUtil.playSound(player, player.func_180425_c(), sound);
    }

    public static void playSound(EntityPlayer player, BlockPos pos, SoundEvent sound) {
        SoundUtil.playSound(player, pos, sound, SoundCategory.BLOCKS);
    }

    public static void playSound(EntityPlayer player, BlockPos pos, SoundEvent sound, SoundCategory category) {
        World world = player.func_130014_f_();
        world.func_184133_a(player, pos, sound, category, 0.3f + 0.7f * world.field_73012_v.nextFloat(), 0.6f + 0.4f * world.field_73012_v.nextFloat());
    }
}

