/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.IChiselMode;
import team.chisel.client.gui.PreviewType;
import team.chisel.common.item.ChiselMode;

public class NBTUtil {
    @Nonnull
    private static final String KEY_TAG = "chiseldata";
    @Nonnull
    private static final String KEY_TARGET = "target";
    @Nonnull
    private static final String KEY_PREVIEW_TYPE = "preview";
    @Nonnull
    private static final String KEY_SELECTION_SLOT = "selectslot";
    @Nonnull
    private static final String KEY_TARGET_SLOT = "targetslot";
    @Nonnull
    private static final String KEY_ROTATE = "rotate";
    @Nonnull
    private static final String KEY_MODE = "mode";

    @Nonnull
    public static NBTTagCompound getTag(@Nonnull ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    @Nonnull
    public static NBTTagCompound getChiselTag(@Nonnull ItemStack stack) {
        NBTTagCompound tag = NBTUtil.getTag(stack);
        if (!tag.func_74764_b(KEY_TAG)) {
            tag.func_74782_a(KEY_TAG, (NBTBase)new NBTTagCompound());
        }
        return tag.func_74775_l(KEY_TAG);
    }

    public static void setChiselTag(@Nonnull ItemStack stack, @Nullable NBTTagCompound tag) {
        NBTUtil.getTag(stack).func_74782_a(KEY_TAG, (NBTBase)tag);
    }

    @Nullable
    public static ItemStack getChiselTarget(@Nonnull ItemStack stack) {
        return ItemStack.func_77949_a((NBTTagCompound)NBTUtil.getChiselTag(stack).func_74775_l(KEY_TARGET));
    }

    public static void setChiselTarget(@Nonnull ItemStack chisel, @Nullable ItemStack target) {
        NBTUtil.getChiselTag(chisel).func_74782_a(KEY_TARGET, (NBTBase)(target == null ? new NBTTagCompound() : target.func_77955_b(new NBTTagCompound())));
    }

    @Nonnull
    public static PreviewType getHitechType(@Nonnull ItemStack stack) {
        return PreviewType.values()[NBTUtil.getChiselTag(stack).func_74762_e(KEY_PREVIEW_TYPE)];
    }

    public static void setHitechType(@Nonnull ItemStack stack, int type) {
        NBTUtil.getChiselTag(stack).func_74768_a(KEY_PREVIEW_TYPE, type);
    }

    public static int getHitechSelection(@Nonnull ItemStack stack) {
        NBTTagCompound tag = NBTUtil.getChiselTag(stack);
        return tag.func_74764_b(KEY_SELECTION_SLOT) ? tag.func_74762_e(KEY_SELECTION_SLOT) : -1;
    }

    public static void setHitechSelection(@Nonnull ItemStack chisel, int slot) {
        NBTUtil.getChiselTag(chisel).func_74768_a(KEY_SELECTION_SLOT, slot);
    }

    public static int getHitechTarget(@Nonnull ItemStack stack) {
        NBTTagCompound tag = NBTUtil.getChiselTag(stack);
        return tag.func_74764_b(KEY_TARGET_SLOT) ? tag.func_74762_e(KEY_TARGET_SLOT) : -1;
    }

    public static void setHitechTarget(@Nonnull ItemStack chisel, int slot) {
        NBTUtil.getChiselTag(chisel).func_74768_a(KEY_TARGET_SLOT, slot);
    }

    public static boolean getHitechRotate(@Nonnull ItemStack stack) {
        return NBTUtil.getChiselTag(stack).func_74767_n(KEY_ROTATE);
    }

    public static void setHitechRotate(@Nonnull ItemStack chisel, boolean rotate) {
        NBTUtil.getChiselTag(chisel).func_74757_a(KEY_ROTATE, rotate);
    }

    public static IChiselMode getChiselMode(@Nonnull ItemStack chisel) {
        String mode = NBTUtil.getChiselTag(chisel).func_74779_i(KEY_MODE);
        return Optional.ofNullable(CarvingUtils.getModeRegistry().getModeByName(mode)).orElse(ChiselMode.SINGLE);
    }

    public static void setChiselMode(@Nonnull ItemStack chisel, @Nonnull IChiselMode mode) {
        NBTUtil.getChiselTag(chisel).func_74778_a(KEY_MODE, mode.name());
    }
}

