/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.integration.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import team.chisel.common.integration.jei.ChiselRecipeWrapper;

@ParametersAreNonnullByDefault
public class ChiselRecipeCategory
implements IRecipeCategory<ChiselRecipeWrapper> {
    private static final ResourceLocation TEXTURE_LOC = new ResourceLocation("chisel", "textures/chiselJEI.png");
    private final IDrawable background;
    private final IDrawable arrowUp;
    private final IDrawable arrowDown;
    @Nullable
    private IRecipeLayout layout;
    @Nullable
    private IFocus<?> focus;

    public ChiselRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE_LOC, 0, 0, 165, 126);
        this.arrowDown = guiHelper.createDrawable(TEXTURE_LOC, 166, 0, 18, 15);
        this.arrowUp = guiHelper.createDrawable(TEXTURE_LOC, 166, 15, 18, 15);
    }

    @Nonnull
    public String getUid() {
        return "chisel.chiseling";
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"chisel.jei.title", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        if (this.layout != null) {
            if (this.focus == null || this.focus.getMode() == IFocus.Mode.INPUT) {
                this.arrowDown.draw(minecraft, 73, 21);
            } else {
                this.arrowUp.draw(minecraft, 73, 21);
            }
        }
    }

    public void drawAnimations(Minecraft minecraft) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, ChiselRecipeWrapper recipeWrapper) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, ChiselRecipeWrapper recipeWrapper, IIngredients ingredients) {
        int i;
        this.layout = recipeLayout;
        this.focus = this.layout.getFocus();
        recipeLayout.getItemStacks().init(0, this.focus == null || this.focus.getMode() == IFocus.Mode.INPUT, 73, 3);
        if (this.focus != null) {
            recipeLayout.getItemStacks().set(0, (ItemStack)this.focus.getValue());
        } else {
            recipeLayout.getItemStacks().set(0, ingredients.getInputs(ItemStack.class).stream().flatMap(l -> l.stream()).collect(Collectors.toList()));
        }
        int rowWidth = 9;
        int xStart = 2;
        int yStart = 36;
        int outputs = ingredients.getOutputs(ItemStack.class).size();
        int MAX_SLOTS = 45;
        ArrayList stacks = Lists.newArrayList();
        for (i = 0; i < outputs; ++i) {
            int slot = i % MAX_SLOTS;
            if (stacks.size() <= slot) {
                stacks.add(Lists.newArrayList());
            }
            ItemStack stack = (ItemStack)ingredients.getOutputs(ItemStack.class).get(i);
            ((List)stacks.get(slot)).add(stack.func_77946_l());
        }
        if (outputs > MAX_SLOTS) {
            int leftover;
            for (int i2 = leftover = outputs % MAX_SLOTS; i2 < MAX_SLOTS; ++i2) {
                ((List)stacks.get(i2)).add(null);
            }
        }
        for (i = 0; i < stacks.size(); ++i) {
            int x = xStart + i % rowWidth * 18;
            int y = yStart + i / rowWidth * 18;
            recipeLayout.getItemStacks().init(i + 1, this.focus != null && this.focus.getMode() == IFocus.Mode.OUTPUT, x, y);
            recipeLayout.getItemStacks().set(i + 1, (List)stacks.get(i));
        }
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }
}

