/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.event;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.BaublesContainer;
import baubles.api.cap.BaublesContainerProvider;
import baubles.api.cap.IBaublesItemHandler;
import baubles.common.Baubles;
import baubles.common.network.PacketHandler;
import baubles.common.network.PacketSync;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventHandlerEntity {
    private HashMap<UUID, ItemStack[]> baublesSync = new HashMap();

    @SubscribeEvent
    public void cloneCapabilitiesEvent(PlayerEvent.Clone event) {
        try {
            BaublesContainer bco = (BaublesContainer)BaublesApi.getBaublesHandler(event.getOriginal());
            NBTTagCompound nbt = bco.serializeNBT();
            BaublesContainer bcn = (BaublesContainer)BaublesApi.getBaublesHandler(event.getEntityPlayer());
            bcn.deserializeNBT(nbt);
        }
        catch (Exception e) {
            Baubles.log.error("Could not clone player [" + event.getOriginal().func_70005_c_() + "] baubles when changing dimensions");
        }
    }

    @SubscribeEvent
    public void attachCapabilitiesPlayer(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("Baubles", "container"), (ICapabilityProvider)new BaublesContainerProvider(new BaublesContainer()));
        }
    }

    @SubscribeEvent
    public void playerJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getWorld().field_72995_K) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)event.getEntity());
            for (int a = 0; a < baubles.getSlots(); ++a) {
                baubles.setChanged(a, true);
            }
            for (EntityPlayer p : event.getEntity().func_130014_f_().field_73010_i) {
                if (p.func_145782_y() == event.getEntity().func_145782_y()) continue;
                IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler(p);
                for (int a = 0; a < baubles2.getSlots(); ++a) {
                    baubles2.setChanged(a, true);
                }
            }
            this.baublesSync.put(event.getEntity().func_110124_au(), new ItemStack[baubles.getSlots()]);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.baublesSync.remove(event.player.func_110124_au());
    }

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            int count;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler(player);
            ItemStack[] items = this.baublesSync.get(player.func_110124_au());
            if (items == null) {
                this.baublesSync.put(player.func_110124_au(), new ItemStack[baubles.getSlots()]);
                items = this.baublesSync.get(player.func_110124_au());
            }
            if (items.length != (count = baubles.getSlots())) {
                ItemStack[] old = items;
                items = new ItemStack[count];
                for (int i = 0; i < old.length && i < items.length; ++i) {
                    items[i] = old[i];
                }
                this.baublesSync.put(player.func_110124_au(), items);
            }
            for (int a = 0; a < count; ++a) {
                ItemStack baubleStack = baubles.getStackInSlot(a);
                IBauble bauble = null;
                if (baubleStack != null && baubleStack.func_77973_b() instanceof IBauble) {
                    bauble = (IBauble)baubleStack.func_77973_b();
                    bauble.onWornTick(baubleStack, (EntityLivingBase)player);
                }
                if (player.func_130014_f_().field_72995_K || !baubles.isChanged(a) && (bauble == null || !bauble.willAutoSync(baubleStack, (EntityLivingBase)player) || ItemStack.func_77989_b((ItemStack)baubleStack, (ItemStack)items[a]))) continue;
                try {
                    PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketSync(player, a), player.func_130014_f_().field_73011_w.getDimension());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                items[a] = ItemStack.func_77944_b((ItemStack)baubleStack);
            }
        }
    }

    @SubscribeEvent
    public void playerDeath(PlayerDropsEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().field_70170_p.field_72995_K && !event.getEntity().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            this.dropItemsAt(event.getEntityPlayer(), event.getDrops(), (Entity)event.getEntityPlayer());
        }
    }

    public void dropItemsAt(EntityPlayer player, List<EntityItem> drops, Entity e) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler(player);
        for (int i = 0; i < baubles.getSlots(); ++i) {
            if (baubles.getStackInSlot(i) == null) continue;
            EntityItem ei = new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v, baubles.getStackInSlot(i).func_77946_l());
            ei.func_174867_a(40);
            float f1 = e.field_70170_p.field_73012_v.nextFloat() * 0.5f;
            float f2 = e.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            ei.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
            ei.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
            ei.field_70181_x = 0.2f;
            drops.add(ei);
            baubles.setStackInSlot(i, null);
        }
    }

    @SubscribeEvent
    public void tooltipEvent(ItemTooltipEvent event) {
        if (event.getItemStack() != null && event.getItemStack().func_77973_b() instanceof IBauble) {
            BaubleType bt = ((IBauble)event.getItemStack().func_77973_b()).getBaubleType(event.getItemStack());
            event.getToolTip().add(TextFormatting.GOLD + I18n.func_135052_a((String)("name." + (Object)((Object)bt)), (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    public void playerLoad(PlayerEvent.LoadFromFile event) {
        File file1 = this.getPlayerFile("baub", event.getPlayerDirectory(), event.getEntityPlayer().getDisplayNameString());
        if (file1.exists()) {
            Baubles.log.info("Loading legacy baubles inventory for [" + event.getEntityPlayer().getDisplayNameString() + "]. Occupied slots will be skipped");
            this.loadPlayerBaubles(event.getEntityPlayer(), file1, this.getPlayerFile("baubback", event.getPlayerDirectory(), event.getEntityPlayer().getDisplayNameString()));
            file1.delete();
        }
    }

    public void loadPlayerBaubles(EntityPlayer player, File file1, File file2) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            try {
                NBTTagCompound data = null;
                boolean save = false;
                if (file1 != null && file1.exists()) {
                    try {
                        FileInputStream fileinputstream = new FileInputStream(file1);
                        data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                        fileinputstream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (data != null) {
                    IBaublesItemHandler baubles = BaublesApi.getBaublesHandler(player);
                    NBTTagList tagList = data.func_150295_c("Baubles.Inventory", 10);
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
                        int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                        ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
                        if (itemstack == null || baubles.getStackInSlot(j) != null) continue;
                        baubles.setStackInSlot(j, itemstack);
                    }
                }
            }
            catch (Exception exception1) {
                Baubles.log.fatal("Error loading legacy baubles inventory");
                exception1.printStackTrace();
            }
        }
    }

    public File getPlayerFile(String suffix, File playerDirectory, String playername) {
        if ("dat".equals(suffix)) {
            throw new IllegalArgumentException("The suffix 'dat' is reserved");
        }
        return new File(playerDirectory, "_" + playername + "." + suffix);
    }
}

