/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.object.entity.pathfinding.raycoms;

import com.iafenvoy.uranus.Uranus;
import com.iafenvoy.uranus.object.BlockUtil;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AbstractAdvancedPathNavigate;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.IAdvancedPathingMob;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.IStuckHandler;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathFindingStatus;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathPointExtended;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathResult;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.Pathfinding;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathingStuckHandler;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs.AbstractPathJob;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs.PathJobMoveAwayFromLocation;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs.PathJobMoveToLocation;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs.PathJobRandomPos;
import com.iafenvoy.uranus.server.world.WorldChunkUtil;
import java.util.Arrays;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4209;
import net.minecraft.class_5134;
import net.minecraft.class_6;
import net.minecraft.class_8;
import net.minecraft.class_9;

public class AdvancedPathNavigate
extends AbstractAdvancedPathNavigate {
    public static final double MIN_Y_DISTANCE = 0.001;
    public static final int MAX_SPEED_ALLOWED = 2;
    public static final double MIN_SPEED_ALLOWED = 0.1;
    private final class_2338 spawnedPos = class_2338.field_10980;
    public boolean overrideDefaultDimensions;
    private PathResult<AbstractPathJob> pathResult;
    private class_2338 desiredPos;
    private int desiredPosTimeout = 0;
    private IStuckHandler stuckHandler;
    private boolean isSneaking = true;
    private double swimSpeedFactor = 1.0;
    private float width;
    private float height;

    public AdvancedPathNavigate(class_1308 entity, class_1937 world) {
        this(entity, world, MovementType.WALKING);
    }

    public AdvancedPathNavigate(class_1308 entity, class_1937 world, MovementType type) {
        this(entity, world, type, 1.0f, 1.0f);
        this.overrideDefaultDimensions = false;
    }

    public AdvancedPathNavigate(class_1308 entity, class_1937 world, MovementType type, float width, float height) {
        this(entity, world, type, width, height, PathingStuckHandler.createStuckHandler().withTeleportSteps(6).withTeleportOnFullStuck());
    }

    public AdvancedPathNavigate(class_1308 entity, class_1937 world, MovementType type, float width, float height, PathingStuckHandler stuckHandler) {
        super(entity, world);
        switch (type.ordinal()) {
            case 1: {
                this.field_6678 = new class_6();
                this.getPathingOptions().setIsFlying(true);
                break;
            }
            case 0: {
                this.field_6678 = new class_14();
                break;
            }
            case 2: {
                this.field_6678 = new class_14();
                this.getPathingOptions().setCanClimb(true);
            }
        }
        this.field_6678.method_15(true);
        this.getPathingOptions().setEnterDoors(true);
        this.field_6678.method_20(true);
        this.getPathingOptions().setCanOpenDoors(true);
        this.field_6678.method_14(true);
        this.getPathingOptions().setCanSwim(true);
        this.width = width;
        this.height = height;
        this.stuckHandler = stuckHandler;
        this.overrideDefaultDimensions = true;
    }

    public static double getSmartGroundY(class_1922 world, class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        class_265 voxelshape = world.method_8320(blockpos).method_26222(world, blockpos);
        if (voxelshape.method_1110() || voxelshape.method_1105(class_2350.class_2351.field_11052) < 1.0) {
            return pos.method_10264();
        }
        return (double)blockpos.method_10264() + voxelshape.method_1105(class_2350.class_2351.field_11052);
    }

    public static boolean isEqual(class_2338 coords, int x, int y, int z) {
        return coords.method_10263() == x && coords.method_10264() == y && coords.method_10260() == z;
    }

    public static boolean isEntityBlockLoaded(class_1936 world, class_2338 pos) {
        return WorldChunkUtil.isEntityBlockLoaded(world, pos);
    }

    @Override
    public PathResult moveAwayFromXYZ(class_2338 avoid, double range, double speedFactor, boolean safeDestination) {
        class_2338 start = AbstractPathJob.prepareStart((class_1309)this.ourEntity);
        return this.setPathJob(new PathJobMoveAwayFromLocation(this.ourEntity.method_37908(), start, avoid, (int)range, (int)this.ourEntity.method_5996(class_5134.field_23717).method_6194(), (class_1309)this.ourEntity), null, speedFactor, safeDestination);
    }

    @Override
    public PathResult moveToRandomPos(double range, double speedFactor) {
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobRandomPos) {
            return this.pathResult;
        }
        this.desiredPos = class_2338.field_10980;
        int theRange = (int)((double)this.field_6684.method_6051().method_43048((int)range) + range / 2.0);
        class_2338 start = AbstractPathJob.prepareStart((class_1309)this.ourEntity);
        return this.setPathJob(new PathJobRandomPos(this.ourEntity.method_37908(), start, theRange, (int)this.ourEntity.method_5996(class_5134.field_23717).method_6194(), (class_1309)this.ourEntity), null, speedFactor, true);
    }

    @Override
    public PathResult moveToRandomPosAroundX(int range, double speedFactor, class_2338 pos) {
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobRandomPos && ((PathJobRandomPos)this.pathResult.getJob()).posAndRangeMatch(range, pos)) {
            return this.pathResult;
        }
        this.desiredPos = class_2338.field_10980;
        return this.setPathJob(new PathJobRandomPos(this.ourEntity.method_37908(), AbstractPathJob.prepareStart((class_1309)this.ourEntity), 3, (int)this.ourEntity.method_5996(class_5134.field_23717).method_6194(), range, (class_1309)this.ourEntity, pos), pos, speedFactor, true);
    }

    @Override
    public PathResult moveToRandomPos(int range, double speedFactor, class_3545<class_2338, class_2338> corners, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobRandomPos) {
            return this.pathResult;
        }
        this.desiredPos = class_2338.field_10980;
        int theRange = this.field_6684.method_6051().method_43048(range) + range / 2;
        class_2338 start = AbstractPathJob.prepareStart((class_1309)this.ourEntity);
        return this.setPathJob(new PathJobRandomPos(this.ourEntity.method_37908(), start, theRange, (int)this.ourEntity.method_5996(class_5134.field_23717).method_6194(), (class_1309)this.ourEntity, (class_2338)corners.method_15442(), (class_2338)corners.method_15441(), restrictionType), null, speedFactor, true);
    }

    public PathResult setPathJob(AbstractPathJob job, class_2338 dest, double speedFactor, boolean safeDestination) {
        this.method_6340();
        this.destination = dest;
        this.originalDestination = dest;
        if (safeDestination) {
            this.desiredPos = dest;
            if (dest != null) {
                this.desiredPosTimeout = 1000;
            }
        }
        this.walkSpeedFactor = speedFactor;
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            Uranus.LOGGER.error("Tried to set a bad speed:{} for entity:{}", new Object[]{speedFactor, this.ourEntity, new Exception()});
            return null;
        }
        job.setPathingOptions(this.getPathingOptions());
        this.pathResult = job.getResult();
        this.pathResult.startJob(Pathfinding.getExecutor());
        return this.pathResult;
    }

    public boolean method_6357() {
        return (this.pathResult == null || this.pathResult.isFinished() && this.pathResult.getStatus() != PathFindingStatus.CALCULATION_COMPLETE) && super.method_6357();
    }

    public void method_6360() {
        IAdvancedPathingMob advancedPathingMob;
        class_1321 tamableAnimal;
        class_1308 class_13082;
        int oldIndex;
        if (this.overrideDefaultDimensions) {
            this.field_6678.field_31 = class_3532.method_15375((float)(this.width + 1.0f));
            this.field_6678.field_30 = class_3532.method_15375((float)(this.height + 1.0f));
            this.field_6678.field_28 = class_3532.method_15375((float)(this.width + 1.0f));
        } else {
            this.field_6678.field_31 = class_3532.method_15375((float)(this.ourEntity.method_17681() + 1.0f));
            this.field_6678.field_30 = class_3532.method_15375((float)(this.ourEntity.method_17682() + 1.0f));
            this.field_6678.field_28 = class_3532.method_15375((float)(this.ourEntity.method_17681() + 1.0f));
        }
        if (this.desiredPosTimeout > 0) {
            --this.desiredPosTimeout;
        }
        if (this.pathResult != null) {
            if (!this.pathResult.isFinished()) {
                return;
            }
            if (this.pathResult.getStatus() == PathFindingStatus.CALCULATION_COMPLETE) {
                this.processCompletedCalculationResult();
            }
        }
        int n = oldIndex = this.method_6357() ? 0 : this.method_6345().method_39();
        if (this.isSneaking) {
            this.isSneaking = false;
            this.field_6684.method_5660(false);
        }
        this.ourEntity.method_5976(0.0f);
        if (this.handleLadders(oldIndex)) {
            this.method_6339();
            this.stuckHandler.checkStuck(this);
            return;
        }
        if (this.handleRails()) {
            this.stuckHandler.checkStuck(this);
            return;
        }
        ++this.field_6675;
        if (!this.method_6357()) {
            if (this.method_6358()) {
                this.method_6339();
            } else if (this.field_6681 != null && !this.field_6681.method_46()) {
                class_243 vector3d = this.method_6347();
                class_243 vector3d1 = this.field_6681.method_49((class_1297)this.field_6684);
                if (vector3d.field_1351 > vector3d1.field_1351 && !this.field_6684.method_24828() && class_3532.method_15357((double)vector3d.field_1352) == class_3532.method_15357((double)vector3d1.field_1352) && class_3532.method_15357((double)vector3d.field_1350) == class_3532.method_15357((double)vector3d1.field_1350)) {
                    this.field_6681.method_44();
                }
            }
            class_4209.method_19470((class_1937)this.field_6677, (class_1308)this.field_6684, (class_11)this.field_6681, (float)this.field_6683);
            if (!this.method_6357()) {
                assert (this.field_6681 != null);
                class_243 vector3d2 = this.field_6681.method_49((class_1297)this.field_6684);
                class_2338 blockpos = class_2338.method_49638((class_2374)vector3d2);
                if (AdvancedPathNavigate.isEntityBlockLoaded((class_1936)this.field_6677, blockpos)) {
                    this.field_6684.method_5962().method_6239(vector3d2.field_1352, this.field_6677.method_8320(blockpos.method_10074()).method_26215() ? vector3d2.field_1351 : AdvancedPathNavigate.getSmartGroundY((class_1922)this.field_6677, blockpos), vector3d2.field_1350, this.field_6668);
                }
            }
        }
        if (this.field_6679) {
            this.method_6356();
        }
        if (this.pathResult != null && this.method_6357()) {
            this.pathResult.setStatus(PathFindingStatus.COMPLETE);
            this.pathResult = null;
        }
        if ((class_13082 = this.field_6684) instanceof class_1321 && (tamableAnimal = (class_1321)class_13082).method_6172()) {
            return;
        }
        class_13082 = this.field_6684;
        if (class_13082 instanceof IAdvancedPathingMob && (advancedPathingMob = (IAdvancedPathingMob)class_13082).stopTickingPathing()) {
            return;
        }
        this.stuckHandler.checkStuck(this);
    }

    @Override
    public PathResult moveToXYZ(double x, double y, double z, double speedFactor) {
        int newX = class_3532.method_15357((double)x);
        int newY = (int)y;
        int newZ = class_3532.method_15357((double)z);
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobMoveToLocation && (this.pathResult.isComputing() || this.destination != null && AdvancedPathNavigate.isEqual(this.destination, newX, newY, newZ) || this.originalDestination != null && AdvancedPathNavigate.isEqual(this.originalDestination, newX, newY, newZ))) {
            return this.pathResult;
        }
        class_2338 start = AbstractPathJob.prepareStart((class_1309)this.ourEntity);
        this.desiredPos = new class_2338(newX, newY, newZ);
        return this.setPathJob(new PathJobMoveToLocation(this.ourEntity.method_37908(), start, this.desiredPos, (int)this.ourEntity.method_5996(class_5134.field_23717).method_6194(), (class_1309)this.ourEntity), this.desiredPos, speedFactor, true);
    }

    @Override
    public boolean tryMoveToBlockPos(class_2338 pos, double speedFactor) {
        this.moveToXYZ(pos.method_10263(), pos.method_10264(), pos.method_10260(), speedFactor);
        return true;
    }

    protected class_13 method_6336(int p_179679_1_) {
        return new class_13((class_8)new class_14(), p_179679_1_);
    }

    protected boolean method_6358() {
        if (this.ourEntity.method_5854() != null) {
            PathPointExtended pEx = (PathPointExtended)this.method_6345().method_40(this.method_6345().method_39());
            if (pEx.isRailsExit()) {
                class_1297 entity = this.ourEntity.method_5854();
                this.ourEntity.method_5848();
                entity.method_5650(class_1297.class_5529.field_26999);
            } else if (!pEx.isOnRails()) {
                if (this.destination == null || this.field_6684.method_5649((double)this.destination.method_10263(), (double)this.destination.method_10264(), (double)this.destination.method_10260()) > 2.0) {
                    this.ourEntity.method_5848();
                }
            } else if ((Math.abs((double)pEx.field_40 - this.field_6684.method_23317()) > 7.0 || Math.abs((double)pEx.field_38 - this.field_6684.method_23321()) > 7.0) && this.ourEntity.method_5854() != null) {
                class_1297 entity = this.ourEntity.method_5854();
                this.ourEntity.method_5848();
                entity.method_5650(class_1297.class_5529.field_26999);
            }
        }
        return true;
    }

    protected class_243 method_6347() {
        return this.ourEntity.method_19538();
    }

    public class_11 method_6348(class_2338 pos, int accuracy) {
        return null;
    }

    protected boolean method_6341(class_243 start, class_243 end) {
        return super.method_6341(start, end);
    }

    public double getSpeedFactor() {
        if (this.ourEntity.method_5799()) {
            this.field_6668 = this.walkSpeedFactor * this.swimSpeedFactor;
            return this.field_6668;
        }
        this.field_6668 = this.walkSpeedFactor;
        return this.walkSpeedFactor;
    }

    public void method_6344(double speedFactor) {
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            Uranus.LOGGER.debug("Tried to set a bad speed:{} for entity:{}", (Object)speedFactor, (Object)this.ourEntity);
            return;
        }
        this.walkSpeedFactor = speedFactor;
    }

    public boolean method_6337(double x, double y, double z, double speedFactor) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return false;
        }
        this.moveToXYZ(x, y, z, speedFactor);
        return true;
    }

    public boolean method_6335(class_1297 entityIn, double speedFactor) {
        return this.tryMoveToBlockPos(entityIn.method_24515(), speedFactor);
    }

    protected void method_6359() {
    }

    public boolean method_6334(class_11 path, double speedFactor) {
        if (path == null) {
            this.method_6340();
            return false;
        }
        long pathStartTime = this.field_6677.method_8510();
        return super.method_6334(this.convertPath(path), speedFactor);
    }

    private class_11 convertPath(class_11 path) {
        int pathLength = path.method_38();
        class_11 tempPath = null;
        if (pathLength > 0 && !(path.method_40(0) instanceof PathPointExtended)) {
            PathPointExtended[] newPoints = new PathPointExtended[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                class_9 point = path.method_40(i);
                newPoints[i] = !(point instanceof PathPointExtended) ? new PathPointExtended(new class_2338(point.field_40, point.field_39, point.field_38)) : (PathPointExtended)point;
            }
            tempPath = new class_11(Arrays.asList(newPoints), path.method_48(), path.method_21655());
            PathPointExtended finalPoint = newPoints[pathLength - 1];
            this.destination = new class_2338(finalPoint.field_40, finalPoint.field_39, finalPoint.field_38);
        }
        return tempPath == null ? path : tempPath;
    }

    private void processCompletedCalculationResult() {
        this.method_6334(this.pathResult.getPath(), this.getSpeedFactor());
        if (this.pathResult != null) {
            this.pathResult.setStatus(PathFindingStatus.IN_PROGRESS_FOLLOWING);
        }
    }

    private boolean handleLadders(int oldIndex) {
        if (!this.method_6357()) {
            assert (this.method_6345() != null);
            PathPointExtended pEx = (PathPointExtended)this.method_6345().method_40(this.method_6345().method_39());
            PathPointExtended pExNext = this.method_6345().method_38() > this.method_6345().method_39() + 1 ? (PathPointExtended)this.method_6345().method_40(this.method_6345().method_39() + 1) : null;
            class_2338 pos = new class_2338(pEx.field_40, pEx.field_39, pEx.field_38);
            if (pEx.isOnLadder() && pExNext != null && (pEx.field_39 != pExNext.field_39 || this.field_6684.method_23318() > (double)pEx.field_39) && BlockUtil.isLadder(this.field_6677.method_8320(pos))) {
                return this.handlePathPointOnLadder(pEx);
            }
            if (this.ourEntity.method_5799()) {
                return this.handleEntityInWater(oldIndex, pEx);
            }
            if (this.field_6677.field_9229.method_43048(10) == 0) {
                this.field_6668 = !pEx.isOnLadder() && pExNext != null && pExNext.isOnLadder() ? this.getSpeedFactor() / 4.0 : this.getSpeedFactor();
            }
        }
        return false;
    }

    private class_2338 findBlockUnderEntity(class_1297 parEntity) {
        int blockX = (int)Math.round(parEntity.method_23317());
        int blockY = class_3532.method_15357((double)(parEntity.method_23318() - 0.2));
        int blockZ = (int)Math.round(parEntity.method_23321());
        return new class_2338(blockX, blockY, blockZ);
    }

    private boolean handleRails() {
        if (!this.method_6357()) {
            PathPointExtended pExNext;
            assert (this.method_6345() != null);
            PathPointExtended pEx = (PathPointExtended)this.method_6345().method_40(this.method_6345().method_39());
            PathPointExtended pathPointExtended = pExNext = this.method_6345().method_38() > this.method_6345().method_39() + 1 ? (PathPointExtended)this.method_6345().method_40(this.method_6345().method_39() + 1) : null;
            if (pExNext != null && pEx.field_40 == pExNext.field_40 && pEx.field_38 == pExNext.field_38) {
                PathPointExtended pathPointExtended2 = pExNext = this.method_6345().method_38() > this.method_6345().method_39() + 2 ? (PathPointExtended)this.method_6345().method_40(this.method_6345().method_39() + 2) : null;
            }
            if (pEx.isOnRails() || pEx.isRailsExit()) {
                return this.handlePathOnRails(pEx, pExNext);
            }
        }
        return false;
    }

    private boolean handlePathOnRails(PathPointExtended pEx, PathPointExtended pExNext) {
        return false;
    }

    private boolean handlePathPointOnLadder(PathPointExtended pEx) {
        class_243 vec3 = this.method_6345().method_49((class_1297)this.ourEntity);
        class_2338 entityPos = new class_2338((class_2382)this.ourEntity.method_24515());
        if (vec3.method_1028(this.ourEntity.method_23317(), vec3.field_1351, this.ourEntity.method_23321()) < 0.6 && Math.abs(vec3.field_1351 - (double)entityPos.method_10264()) <= 2.0) {
            double newSpeed = 0.3;
            switch (pEx.getLadderFacing()) {
                case field_11043: {
                    vec3 = vec3.method_1031(0.0, 0.0, 0.4);
                    break;
                }
                case field_11035: {
                    vec3 = vec3.method_1031(0.0, 0.0, -0.4);
                    break;
                }
                case field_11039: {
                    vec3 = vec3.method_1031(0.4, 0.0, 0.0);
                    break;
                }
                case field_11034: {
                    vec3 = vec3.method_1031(-0.4, 0.0, 0.0);
                    break;
                }
                case field_11036: {
                    vec3 = vec3.method_1031(0.0, 1.0, 0.0);
                    break;
                }
                default: {
                    newSpeed = 0.0;
                    this.field_6684.method_5660(true);
                    this.isSneaking = true;
                    this.ourEntity.method_5962().method_6239(vec3.field_1352, vec3.field_1351, vec3.field_1350, 0.2);
                }
            }
            if (newSpeed > 0.0) {
                if (!(this.field_6677.method_8320(this.ourEntity.method_24515()).method_26204() instanceof class_2399)) {
                    this.ourEntity.method_18799(this.ourEntity.method_18798().method_1031(0.0, 0.1, 0.0));
                }
                this.ourEntity.method_5962().method_6239(vec3.field_1352, vec3.field_1351, vec3.field_1350, newSpeed);
            } else {
                if (!BlockUtil.isLadder(this.field_6677.method_8320(entityPos.method_10074()))) {
                    return false;
                }
                this.ourEntity.method_5976(-0.5f);
                return true;
            }
        }
        return false;
    }

    private boolean handleEntityInWater(int oldIndex, PathPointExtended pEx) {
        assert (this.method_6345() != null);
        int curIndex = this.method_6345().method_39();
        if (curIndex > 0 && curIndex + 1 < this.method_6345().method_38() && this.method_6345().method_40((int)(curIndex - 1)).field_39 != pEx.field_39) {
            oldIndex = curIndex + 1;
        }
        this.method_6345().method_42(oldIndex);
        class_243 vec3d = this.method_6345().method_49((class_1297)this.ourEntity);
        class_243 class_2432 = new class_243(this.ourEntity.method_23317(), vec3d.field_1351, this.ourEntity.method_23321());
        if (vec3d.method_1025(class_2432) < 0.1 && Math.abs(this.ourEntity.method_23318() - vec3d.field_1351) < 0.5) {
            this.method_6345().method_44();
            if (this.method_6357()) {
                return true;
            }
            vec3d = this.method_6345().method_49((class_1297)this.ourEntity);
        }
        this.ourEntity.method_5962().method_6239(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, this.getSpeedFactor());
        return false;
    }

    protected void method_6339() {
        class_243 next;
        this.getSpeedFactor();
        assert (this.field_6681 != null);
        int curNode = this.field_6681.method_39();
        int curNodeNext = curNode + 1;
        if (curNodeNext < this.field_6681.method_38()) {
            if (!(this.field_6681.method_40(curNode) instanceof PathPointExtended)) {
                this.field_6681 = this.convertPath(this.field_6681);
            }
            PathPointExtended pEx = (PathPointExtended)this.field_6681.method_40(curNode);
            PathPointExtended pExNext = (PathPointExtended)this.field_6681.method_40(curNodeNext);
            if (pEx.isOnLadder() && pEx.getLadderFacing() == class_2350.field_11033 && !pExNext.isOnLadder()) {
                class_243 vec3 = this.method_6347();
                if (vec3.field_1351 - (double)pEx.field_39 < 0.001) {
                    this.field_6681.method_42(curNodeNext);
                }
                return;
            }
        }
        this.field_6683 = Math.max(1.2f, this.field_6684.method_17681());
        boolean wentAhead = false;
        boolean isTracking = AbstractPathJob.trackingMap.containsValue(this.ourEntity.method_5667());
        int maxDropHeight = 3;
        for (int i = this.field_6681.method_39(); i < Math.min(this.field_6681.method_38(), this.field_6681.method_39() + 4); ++i) {
            next = this.field_6681.method_47((class_1297)this.field_6684, i);
            if (!(Math.abs(this.field_6684.method_23317() - next.field_1352) < (double)this.field_6683 - Math.abs(this.field_6684.method_23318() - next.field_1351) * 0.1) || !(Math.abs(this.field_6684.method_23321() - next.field_1350) < (double)this.field_6683 - Math.abs(this.field_6684.method_23318() - next.field_1351) * 0.1) || !(Math.abs(this.field_6684.method_23318() - next.field_1351) <= Math.min(1.0, Math.ceil(this.field_6684.method_17682() / 2.0f))) && !(Math.abs(this.field_6684.method_23318() - next.field_1351) <= Math.ceil(this.field_6684.method_17681() / 2.0f) * (double)maxDropHeight)) continue;
            this.field_6681.method_44();
            wentAhead = true;
        }
        if (this.field_6681.method_46()) {
            this.onPathFinish();
            return;
        }
        if (wentAhead) {
            return;
        }
        if (curNode >= this.field_6681.method_38() || curNode <= 1) {
            return;
        }
        class_243 curr = this.field_6681.method_47((class_1297)this.field_6684, curNode - 1);
        next = this.field_6681.method_47((class_1297)this.field_6684, curNode);
        class_2382 currI = new class_2382((int)Math.round(curr.field_1352), (int)Math.round(curr.field_1351), (int)Math.round(curr.field_1350));
        class_2382 nextI = new class_2382((int)Math.round(next.field_1352), (int)Math.round(next.field_1351), (int)Math.round(next.field_1350));
        if (this.field_6684.method_24515().method_19771(currI, 2.0) && this.field_6684.method_24515().method_19771(nextI, 2.0)) {
            for (int currentIndex = curNode - 1; currentIndex > 0; --currentIndex) {
                class_243 tempoPos = this.field_6681.method_47((class_1297)this.field_6684, currentIndex);
                class_2382 tempoPosI = new class_2382((int)Math.round(tempoPos.field_1352), (int)Math.round(tempoPos.field_1351), (int)Math.round(tempoPos.field_1350));
                if (!this.field_6684.method_24515().method_19771(tempoPosI, 1.0)) continue;
                this.field_6681.method_42(currentIndex);
            }
        }
    }

    private void onPathFinish() {
        this.method_6340();
    }

    public void method_6356() {
    }

    protected void method_6346(class_243 positionVec3) {
    }

    public boolean entityOnAndBelowPath(class_1297 entity, class_243 slack) {
        class_11 path = this.method_6345();
        if (path == null) {
            return false;
        }
        int closest = path.method_39();
        for (int i = 0; i < path.method_38() - 1; ++i) {
            class_9 currentPoint;
            if (closest + i < path.method_38() && this.entityNearAndBelowPoint(currentPoint = path.method_40(closest + i), entity, slack)) {
                return true;
            }
            if (closest - i < 0 || !this.entityNearAndBelowPoint(currentPoint = path.method_40(closest - i), entity, slack)) continue;
            return true;
        }
        return false;
    }

    private boolean entityNearAndBelowPoint(class_9 currentPoint, class_1297 entity, class_243 slack) {
        return Math.abs((double)currentPoint.field_40 - entity.method_23317()) < slack.method_10216() && (double)currentPoint.field_39 - entity.method_23318() + slack.method_10214() > 0.0 && Math.abs((double)currentPoint.field_38 - entity.method_23321()) < slack.method_10215();
    }

    public void method_6340() {
        if (this.pathResult != null) {
            this.pathResult.cancel();
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
            this.pathResult = null;
        }
        this.destination = null;
        super.method_6340();
    }

    @Override
    public PathResult moveToLivingEntity(class_1297 e, double speed) {
        return this.moveToXYZ(e.method_23317(), e.method_23318(), e.method_23321(), speed);
    }

    @Override
    public PathResult moveAwayFromLivingEntity(class_1297 e, double distance, double speed) {
        return this.moveAwayFromXYZ(new class_2338((class_2382)e.method_24515()), distance, speed, true);
    }

    public void method_6354(boolean canSwim) {
        super.method_6354(canSwim);
        this.getPathingOptions().setCanSwim(canSwim);
    }

    @Override
    public class_2338 getDesiredPos() {
        return this.desiredPos;
    }

    @Override
    public void setStuckHandler(IStuckHandler stuckHandler) {
        this.stuckHandler = stuckHandler;
    }

    @Override
    public void setSwimSpeedFactor(double factor) {
        this.swimSpeedFactor = factor;
    }

    public static enum MovementType {
        WALKING,
        FLYING,
        CLIMBING;

    }
}

