/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.parties;

import java.util.UUID;
import net.minecraft.class_2487;
import xaero.pac.common.parties.party.PartyPlayerInfo;
import xaero.pac.common.parties.party.member.PartyInvite;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;

public class PartyPlayerInfoCodec {
    public PartyInvite fromPartyInviteTag(class_2487 playerInfoTag) {
        if (playerInfoTag.method_33133()) {
            return null;
        }
        try {
            UUID playerUUID = playerInfoTag.method_25926("i");
            String username = playerInfoTag.method_10558("n");
            if (username.isEmpty() || username.length() > 128) {
                return null;
            }
            PartyInvite result = new PartyInvite(playerUUID);
            result.setUsername(username);
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public PartyMember fromMemberTag(class_2487 memberTag, boolean isOwner) {
        if (memberTag.method_33133()) {
            return null;
        }
        try {
            UUID playerUUID = memberTag.method_25926("i");
            String username = memberTag.method_10558("n");
            if (username.isEmpty() || username.length() > 128) {
                return null;
            }
            String rank = memberTag.method_10558("r");
            if (rank.isEmpty() || rank.length() > 128) {
                return null;
            }
            PartyMember result = new PartyMember(playerUUID, isOwner);
            result.setUsername(username);
            result.setRank(PartyMemberRank.valueOf(rank));
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private class_2487 toPlayerInfoTag(PartyPlayerInfo<?> playerInfo) {
        class_2487 infoTag = new class_2487();
        infoTag.method_25927("i", playerInfo.getUUID());
        infoTag.method_10582("n", playerInfo.getUsername());
        return infoTag;
    }

    public class_2487 toPartyInviteTag(PartyInvite playerInfo) {
        return this.toPlayerInfoTag(playerInfo);
    }

    public class_2487 toMemberTag(PartyMember member) {
        class_2487 memberTag = this.toPlayerInfoTag(member);
        memberTag.method_10582("r", member.getRank().toString());
        return memberTag;
    }
}

