/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.packet.config.PlayerConfigPacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.sub.PlayerSubConfigDeletionStarter;
import xaero.pac.common.server.player.data.ServerPlayerData;

public class ServerboundSubConfigExistencePacket
extends PlayerConfigPacket {
    private final String subId;
    private final UUID owner;
    private final PlayerConfigType type;
    private final boolean create;

    public ServerboundSubConfigExistencePacket(String subId, UUID owner, PlayerConfigType type, boolean create) {
        this.subId = subId;
        this.owner = owner;
        this.type = type;
        this.create = create;
    }

    public static class ServerHandler
    implements BiConsumer<ServerboundSubConfigExistencePacket, class_3222> {
        @Override
        public void accept(ServerboundSubConfigExistencePacket t, class_3222 serverPlayer) {
            UUID ownerId;
            boolean isServer;
            if (t.type != PlayerConfigType.PLAYER && t.type != PlayerConfigType.SERVER) {
                OpenPartiesAndClaims.LOGGER.info("Someone is trying to create/delete a sub-config for an invalid config type! Name: " + serverPlayer.method_7334().getName());
                return;
            }
            boolean isOP = serverPlayer.method_5687(2);
            boolean bl = isServer = t.type == PlayerConfigType.SERVER;
            UUID uUID = isServer ? null : (ownerId = t.owner == null ? serverPlayer.method_5667() : t.owner);
            if (!isOP) {
                if (isServer) {
                    OpenPartiesAndClaims.LOGGER.info("Non-op player is attempting to create/delete a sub-config without required permissions! Name: " + serverPlayer.method_7334().getName());
                    return;
                }
                if (!Objects.equals(ownerId, serverPlayer.method_5667())) {
                    OpenPartiesAndClaims.LOGGER.info("Non-op player is attempting to create/delete a sub-config for another player! Name: " + serverPlayer.method_7334().getName());
                    return;
                }
            }
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverPlayer.method_5682());
            IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
            IPlayerConfig config = !isServer ? playerConfigs.getLoadedConfig(ownerId) : playerConfigs.getServerClaimConfig();
            ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(serverPlayer);
            if (serverData.getServerTickHandler().getTickCounter() == playerData.getLastSubConfigCreationTick()) {
                return;
            }
            playerData.setLastSubConfigCreationTick(serverData.getServerTickHandler().getTickCounter());
            if (t.create) {
                boolean reachedLimit;
                boolean bl2 = reachedLimit = config.getSubCount() >= config.getSubConfigLimit();
                if (reachedLimit || config.createSubConfig(t.subId) == null || !isServer && !Objects.equals(ownerId, serverPlayer.method_5667())) {
                    playerConfigs.getSynchronizer().confirmSubConfigCreationSync(serverPlayer, config);
                    if (reachedLimit) {
                        class_5250 limitReachedMessage = class_2561.method_43469((String)"gui.xaero_pac_config_create_sub_id_limit_reached", (Object[])new Object[]{config.getSubConfigLimit()});
                        limitReachedMessage.method_27694(s -> s.method_10977(class_124.field_1061));
                        serverPlayer.method_43496((class_2561)limitReachedMessage);
                    }
                }
            } else {
                IPlayerConfig subConfig = config.getSubConfig(t.subId);
                if (subConfig == null) {
                    return;
                }
                if (subConfig == config) {
                    return;
                }
                IServerPlayerClaimInfo playerInfo = (IServerPlayerClaimInfo)serverData.getServerClaimsManager().getPlayerInfo(config.getPlayerId());
                if (playerInfo.hasReplacementTasks()) {
                    serverPlayer.method_43496((class_2561)class_2561.method_43471((String)"gui.xaero_pac_config_delete_sub_already_replacing"));
                    playerConfigs.getSynchronizer().syncGeneralState(serverPlayer, subConfig);
                    return;
                }
                new PlayerSubConfigDeletionStarter().start(serverPlayer, playerInfo, subConfig, serverData);
            }
        }
    }

    public static class Codec
    implements BiConsumer<ServerboundSubConfigExistencePacket, class_2540>,
    Function<class_2540, ServerboundSubConfigExistencePacket> {
        @Override
        public ServerboundSubConfigExistencePacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 4096) {
                    return null;
                }
                class_2487 nbt = input.method_30617();
                if (nbt == null) {
                    return null;
                }
                String subId = nbt.method_10558("subId");
                if (subId.isEmpty() || subId.length() > 100) {
                    return null;
                }
                String typeString = nbt.method_10558("type");
                if (typeString.isEmpty() || typeString.length() > 100) {
                    return null;
                }
                PlayerConfigType type = null;
                try {
                    type = PlayerConfigType.valueOf(typeString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (type == null) {
                    OpenPartiesAndClaims.LOGGER.info("Received unknown player config type!");
                    return null;
                }
                UUID owner = nbt.method_10545("owner") ? nbt.method_25926("owner") : null;
                boolean create = nbt.method_10577("create");
                return new ServerboundSubConfigExistencePacket(subId, owner, type, create);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void accept(ServerboundSubConfigExistencePacket t, class_2540 u) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("subId", t.subId);
            if (t.owner != null) {
                nbt.method_25927("owner", t.owner);
            }
            nbt.method_10582("type", t.type.name());
            nbt.method_10556("create", t.create);
            u.method_10794(nbt);
        }
    }
}

