/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.movingelevators.elevator.ClientElevatorCage;
import com.supermartijn642.movingelevators.extensions.MovingElevatorsLevelChunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2440;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_3194;
import net.minecraft.class_3218;
import net.minecraft.class_3829;

public class ElevatorCage {
    public final int xSize;
    public final int ySize;
    public final int zSize;
    public final class_2680[][][] blockStates;
    public final class_2487[][][] blockEntityData;
    public final class_2487[][][] blockEntityStacks;
    public final class_265 shape;
    public final List<class_238> collisionBoxes;
    public final class_238 bounds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElevatorCage createCageAndClear(class_1937 level, class_2338 startPos, int xSize, int ySize, int zSize) {
        class_2338 pos;
        int z;
        int y;
        int x;
        if (!ElevatorCage.canCreateCage(level, startPos, xSize, ySize, zSize)) {
            return null;
        }
        class_2680[][][] states = new class_2680[xSize][ySize][zSize];
        class_2487[][][] entities = new class_2487[xSize][ySize][zSize];
        class_2487[][][] entityItemStacks = new class_2487[xSize][ySize][zSize];
        class_265 shape = class_259.method_1073();
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    pos = startPos.method_10069(x, y, z);
                    if (ElevatorCage.canBlockBeIgnored(level, pos)) continue;
                    states[x][y][z] = level.method_8320(pos);
                    class_265 blockShape = states[x][y][z].method_26220((class_1922)level, pos);
                    blockShape = blockShape.method_1096((double)x, (double)y, (double)z);
                    shape = class_259.method_1082((class_265)shape, (class_265)blockShape, (class_247)class_247.field_1366);
                    class_2586 entity = level.method_8321(pos);
                    if (entity == null) continue;
                    class_2487 tag = entity.method_38242();
                    tag.method_10569("x", x);
                    tag.method_10569("y", y);
                    tag.method_10569("z", z);
                    entities[x][y][z] = tag;
                    class_1799 stack = new class_1799((class_1935)states[x][y][z].method_26204());
                    tag = tag.method_10553();
                    tag.method_10551("x");
                    tag.method_10551("y");
                    tag.method_10551("z");
                    stack.method_7959("BlockEntityTag", (class_2520)tag);
                    class_2487 displayTag = new class_2487();
                    class_2499 loreTag = new class_2499();
                    loreTag.add((Object)class_2519.method_23256((String)"\"(+NBT)\""));
                    displayTag.method_10566("Lore", (class_2520)loreTag);
                    stack.method_7959("display", (class_2520)displayTag);
                    entityItemStacks[x][y][z] = stack.method_7953(new class_2487());
                }
            }
        }
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    class_2818 chunk;
                    pos = startPos.method_10069(x, y, z);
                    if (states[x][y][z] == null) continue;
                    class_2586 entity = level.method_8321(pos);
                    if (entity != null) {
                        class_3829.method_16825((Object)entity);
                        level.method_8544(pos);
                    }
                    if ((chunk = level.method_8500(pos)) != null) {
                        ((MovingElevatorsLevelChunk)chunk).movingElevatorsSuppressBlockUpdates(true);
                        try {
                            level.method_8652(pos, class_2246.field_10124.method_9564(), 20);
                            continue;
                        }
                        finally {
                            ((MovingElevatorsLevelChunk)chunk).movingElevatorsSuppressBlockUpdates(false);
                        }
                    }
                    level.method_8652(pos, class_2246.field_10124.method_9564(), 20);
                }
            }
        }
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    pos = startPos.method_10069(x, y, z);
                    class_2680 state = states[x][y][z];
                    if (states[x][y][z] == null) continue;
                    class_2680 newState = level.method_8320(pos);
                    state.method_26197(level, pos, newState, false);
                    ElevatorCage.markAndNotify(level, pos, level.method_8500(pos), states[x][y][z], newState, 3, 512);
                }
            }
        }
        shape.method_1097();
        return level.field_9236 ? new ClientElevatorCage(xSize, ySize, zSize, states, entities, entityItemStacks, shape.method_1090()) : new ElevatorCage(xSize, ySize, zSize, states, entities, entityItemStacks, shape.method_1090());
    }

    public static boolean canCreateCage(class_1937 level, class_2338 startPos, int xSize, int ySize, int zSize) {
        boolean hasBlocks = false;
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    if (ElevatorCage.canBlockBeIgnored(level, startPos.method_10069(x, y, z))) continue;
                    if (!ElevatorCage.canBlockBeInCage(level, startPos.method_10069(x, y, z))) {
                        return false;
                    }
                    hasBlocks = true;
                }
            }
        }
        return hasBlocks;
    }

    public static boolean canBlockBeIgnored(class_1937 level, class_2338 pos) {
        return level.method_22347(pos) || level.method_8320(pos).method_27852(class_2246.field_31037);
    }

    public static boolean canBlockBeInCage(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return state.method_26227().method_15769() && state.method_26214((class_1922)level, pos) >= 0.0f;
    }

    public ElevatorCage(int xSize, int ySize, int zSize, class_2680[][][] states, class_2487[][][] blockEntityData, class_2487[][][] blockEntityStacks, List<class_238> collisionBoxes) {
        this.blockEntityData = blockEntityData;
        this.blockEntityStacks = blockEntityStacks;
        if (states.length != xSize || states[0].length != ySize || states[0][0].length != zSize) {
            throw new IllegalArgumentException("Given size and block state array do not match!");
        }
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.blockStates = states;
        this.collisionBoxes = Collections.unmodifiableList(collisionBoxes);
        class_265 shape = class_259.method_1073();
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (class_238 box : collisionBoxes) {
            shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1078((class_238)box), (class_247)class_247.field_1366);
            minX = Math.min(minX, box.field_1323);
            minY = Math.min(minY, box.field_1322);
            minZ = Math.min(minZ, box.field_1321);
            maxX = Math.max(maxX, box.field_1320);
            maxY = Math.max(maxY, box.field_1325);
            maxZ = Math.max(maxZ, box.field_1324);
        }
        this.shape = shape.method_1097();
        this.bounds = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void place(class_1937 level, class_2338 startPos) {
        class_2338 pos;
        int z;
        int y;
        int x;
        class_2680[][][] oldStates = new class_2680[this.xSize][this.ySize][this.zSize];
        for (x = 0; x < this.xSize; ++x) {
            for (y = 0; y < this.ySize; ++y) {
                for (z = 0; z < this.zSize; ++z) {
                    class_2680 state = this.blockStates[x][y][z];
                    if (state == null) continue;
                    pos = startPos.method_10069(x, y, z);
                    class_2680 currentState = level.method_8320(pos);
                    if (ElevatorCage.canBlockBeIgnored(level, pos) || currentState.method_26214((class_1922)level, pos) >= 0.0f) {
                        class_2586 entity;
                        class_2818 chunk;
                        oldStates[x][y][z] = currentState;
                        if (!level.method_22347(pos)) {
                            level.method_22352(pos, true);
                        }
                        if ((chunk = level.method_8500(pos)) != null) {
                            ((MovingElevatorsLevelChunk)chunk).movingElevatorsSuppressBlockUpdates(true);
                            try {
                                level.method_8652(pos, state, 20);
                            }
                            finally {
                                ((MovingElevatorsLevelChunk)chunk).movingElevatorsSuppressBlockUpdates(false);
                            }
                        } else {
                            level.method_8652(pos, state, 20);
                        }
                        if (this.blockEntityData[x][y][z] == null || (entity = class_2586.method_11005((class_2338)pos, (class_2680)state, (class_2487)this.blockEntityData[x][y][z])) == null) continue;
                        level.method_8438(entity);
                        continue;
                    }
                    class_2487 itemTag = this.blockEntityStacks[x][y][z];
                    class_1799 stack = itemTag == null ? new class_1799((class_1935)state.method_26204()) : class_1799.method_7915((class_2487)itemTag);
                    class_1264.method_5449((class_1937)level, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5), (class_1799)stack);
                }
            }
        }
        for (x = 0; x < this.xSize; ++x) {
            for (y = 0; y < this.ySize; ++y) {
                for (z = 0; z < this.zSize; ++z) {
                    class_2680 previousState = oldStates[x][y][z];
                    if (previousState == null) continue;
                    pos = startPos.method_10069(x, y, z);
                    class_2680 state = level.method_8320(pos);
                    state.method_26182(level, pos, previousState, true);
                    boolean isOnTheBoundary = x == 0 || x == this.xSize - 1 || y == 0 || y == this.ySize - 1 || z == 0 || z == this.zSize - 1;
                    int flags = isOnTheBoundary ? 3 : 22;
                    ElevatorCage.markAndNotify(level, pos, level.method_8500(pos), previousState, state, flags, 512);
                    if (!level.field_9236 && state.method_26204() instanceof class_2269 && state.method_28498((class_2769)class_2269.field_10729) && ((Boolean)state.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
                        state.method_26192((class_3218)level, pos, level.field_9229);
                    }
                    if (!level.field_9236 && state.method_26204() instanceof class_2440 && state.method_28498((class_2769)class_2440.field_11358) && ((Boolean)state.method_11654((class_2769)class_2440.field_11358)).booleanValue()) {
                        state.method_26192((class_3218)level, pos, level.field_9229);
                    }
                    if (!state.method_27852(class_2246.field_10091)) continue;
                    boolean[] updateDirections = new boolean[6];
                    updateDirections[4] = x == 0;
                    updateDirections[5] = x == this.xSize - 1;
                    updateDirections[0] = y == 0;
                    updateDirections[1] = y == this.ySize - 1;
                    updateDirections[2] = z == 0;
                    updateDirections[3] = z == this.zSize - 1;
                    for (int i = 0; i < updateDirections.length; ++i) {
                        if (!updateDirections[i]) continue;
                        class_2350 direction = class_2350.values()[i];
                        level.method_8452(pos.method_10093(direction), class_2246.field_10091);
                    }
                }
            }
        }
    }

    public List<class_1799> getDrops() {
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    if (this.blockStates[x][y][z] == null) continue;
                    if (this.blockEntityStacks[x][y][z] != null) {
                        drops.add(class_1799.method_7915((class_2487)this.blockEntityStacks[x][y][z]));
                        continue;
                    }
                    drops.add(new class_1799((class_1935)this.blockStates[x][y][z].method_26204()));
                }
            }
        }
        return drops;
    }

    public class_2487 write() {
        class_2487 compound = new class_2487();
        compound.method_10569("xSize", this.xSize);
        compound.method_10569("ySize", this.ySize);
        compound.method_10569("zSize", this.zSize);
        int[] stateIds = new int[this.xSize * this.ySize * this.zSize];
        class_2499 entityData = new class_2499();
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    int index = x * this.ySize * this.zSize + y * this.zSize + z;
                    class_2680 state = this.blockStates[x][y][z];
                    stateIds[index] = class_2248.method_9507((class_2680)(state == null || state.method_26204() == class_2246.field_10124 ? class_2246.field_10124.method_9564() : state));
                    if (this.blockEntityData[x][y][z] == null) continue;
                    class_2487 tag = new class_2487();
                    tag.method_10569("x", x);
                    tag.method_10569("y", y);
                    tag.method_10569("z", z);
                    tag.method_10566("data", (class_2520)this.blockEntityData[x][y][z]);
                    tag.method_10566("stack", (class_2520)this.blockEntityStacks[x][y][z]);
                    entityData.add((Object)tag);
                }
            }
        }
        compound.method_10539("blockStates", stateIds);
        compound.method_10566("entityData", (class_2520)entityData);
        class_2499 collisionBoxList = new class_2499();
        this.collisionBoxes.forEach(box -> collisionBoxList.add((Object)ElevatorCage.writeBox(box)));
        compound.method_10566("collisionBoxes", (class_2520)collisionBoxList);
        return compound;
    }

    public static ElevatorCage read(class_2487 compound, boolean isClientSide) {
        int xSize = compound.method_10550("xSize");
        int ySize = compound.method_10550("ySize");
        int zSize = compound.method_10550("zSize");
        int[] stateIds = compound.method_10561("blockStates");
        class_2680[][][] blockStates = new class_2680[xSize][ySize][zSize];
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    int index = x * ySize * zSize + y * zSize + z;
                    class_2680 state = class_2248.method_9531((int)stateIds[index]);
                    blockStates[x][y][z] = state.method_26204() == class_2246.field_10124 ? null : state;
                }
            }
        }
        class_2487[][][] entityTags = new class_2487[xSize][ySize][zSize];
        class_2487[][][] stackTags = new class_2487[xSize][ySize][zSize];
        if (compound.method_10573("entityData", 9)) {
            class_2499 entityData = compound.method_10554("entityData", 10);
            for (class_2520 tag : entityData) {
                int x = ((class_2487)tag).method_10550("x");
                int y = ((class_2487)tag).method_10550("y");
                int z = ((class_2487)tag).method_10550("z");
                entityTags[x][y][z] = ((class_2487)tag).method_10562("data");
                stackTags[x][y][z] = ((class_2487)tag).method_10562("stack");
            }
        }
        class_2499 collisionBoxList = compound.method_10554("collisionBoxes", 10);
        List<class_238> collisionBoxes = collisionBoxList.stream().map(class_2487.class::cast).map(ElevatorCage::readBox).collect(Collectors.toList());
        return isClientSide ? new ClientElevatorCage(xSize, ySize, zSize, blockStates, entityTags, stackTags, collisionBoxes) : new ElevatorCage(xSize, ySize, zSize, blockStates, entityTags, stackTags, collisionBoxes);
    }

    private static class_2487 writeBox(class_238 box) {
        class_2487 compound = new class_2487();
        compound.method_10549("x1", box.field_1323);
        compound.method_10549("y1", box.field_1322);
        compound.method_10549("z1", box.field_1321);
        compound.method_10549("x2", box.field_1320);
        compound.method_10549("y2", box.field_1325);
        compound.method_10549("z2", box.field_1324);
        return compound;
    }

    private static class_238 readBox(class_2487 compound) {
        return new class_238(compound.method_10574("x1"), compound.method_10574("y1"), compound.method_10574("z1"), compound.method_10574("x2"), compound.method_10574("y2"), compound.method_10574("z2"));
    }

    private static void markAndNotify(class_1937 level, class_2338 pos, class_2818 levelChunk, class_2680 oldState, class_2680 newState, int flags, int maxUpdates) {
        class_2680 currentState = level.method_8320(pos);
        if (currentState == newState) {
            if (oldState != currentState) {
                level.method_16109(pos, oldState, currentState);
            }
            if ((flags & 2) != 0 && (!level.field_9236 || (flags & 4) == 0) && (level.field_9236 || levelChunk.method_12225() != null && levelChunk.method_12225().method_14014(class_3194.field_44856))) {
                level.method_8413(pos, oldState, newState, flags);
            }
            if ((flags & 1) != 0) {
                level.method_8408(pos, oldState.method_26204());
                if (!level.field_9236 && newState.method_26221()) {
                    level.method_8455(pos, newState.method_26204());
                }
            }
            if ((flags & 0x10) == 0 && maxUpdates > 0) {
                int k = flags & 0xFFFFFFDE;
                oldState.method_26198((class_1936)level, pos, k, maxUpdates - 1);
                newState.method_26183((class_1936)level, pos, k, maxUpdates - 1);
                newState.method_26198((class_1936)level, pos, k, maxUpdates - 1);
            }
            level.method_19282(pos, oldState, currentState);
        }
    }
}

