/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.config.ModMenuConfigManager;
import com.terraformersmc.modmenu.gui.widget.DescriptionListWidget;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.TranslationUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_407;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_7919;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModsScreen
extends class_437 {
    private static final class_2960 FILTERS_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/filters_button.png");
    private static final class_2960 CONFIGURE_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/configure_button.png");
    private static final class_2561 TOGGLE_FILTER_OPTIONS = class_2561.method_43471((String)"modmenu.toggleFilterOptions");
    private static final class_2561 CONFIGURE = class_2561.method_43471((String)"modmenu.configure");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | ModsScreen");
    private class_342 searchBox;
    private DescriptionListWidget descriptionListWidget;
    private final class_437 previousScreen;
    private ModListWidget modList;
    private ModListEntry selected;
    private ModBadgeRenderer modBadgeRenderer;
    private double scrollPercent = 0.0;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private int paneY;
    private static final int RIGHT_PANE_Y = 48;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    private int filtersX;
    private int filtersWidth;
    private int searchRowWidth;
    public final Set<String> showModChildren = new HashSet<String>();
    public final Map<String, Boolean> modHasConfigScreen = new HashMap<String, Boolean>();
    public final Map<String, Throwable> modScreenErrors = new HashMap<String, Throwable>();

    public ModsScreen(class_437 previousScreen) {
        super((class_2561)class_2561.method_43471((String)"modmenu.title"));
        this.previousScreen = previousScreen;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.modList.method_25405(mouseX, mouseY)) {
            return this.modList.method_25401(mouseX, mouseY, amount);
        }
        if (this.descriptionListWidget.method_25405(mouseX, mouseY)) {
            return this.descriptionListWidget.method_25401(mouseX, mouseY, amount);
        }
        return false;
    }

    public void method_25393() {
        this.searchBox.method_1865();
    }

    protected void method_25426() {
        this.paneY = ModMenuConfig.CONFIG_MODE.getValue() ? 48 : 67;
        this.paneWidth = this.field_22789 / 2 - 8;
        this.rightPaneX = this.field_22789 - this.paneWidth;
        int filtersButtonSize = ModMenuConfig.CONFIG_MODE.getValue() ? 0 : 22;
        int searchWidthMax = this.paneWidth - 32 - filtersButtonSize;
        int searchBoxWidth = ModMenuConfig.CONFIG_MODE.getValue() ? Math.min(200, searchWidthMax) : searchWidthMax;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - filtersButtonSize / 2;
        this.searchBox = new class_342(this.field_22793, this.searchBoxX, 22, searchBoxWidth, 20, this.searchBox, (class_2561)class_2561.method_43471((String)"modmenu.search"));
        this.searchBox.method_1863(string_1 -> this.modList.filter((String)string_1, false));
        for (Mod mod : ModMenu.MODS.values()) {
            String id = mod.getId();
            if (this.modHasConfigScreen.containsKey(id)) continue;
            try {
                class_437 configScreen = ModMenu.getConfigScreen(id, this);
                this.modHasConfigScreen.put(id, configScreen != null);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.warn("The '" + id + "' mod config screen is not available because " + e.getLocalizedMessage() + " is missing.");
                this.modScreenErrors.put(id, e);
                this.modHasConfigScreen.put(id, false);
            }
            catch (Throwable e) {
                LOGGER.error("Error from mod '" + id + "'", e);
                this.modScreenErrors.put(id, e);
                this.modHasConfigScreen.put(id, false);
            }
        }
        this.modList = new ModListWidget(this.field_22787, this.paneWidth, this.field_22790, this.paneY, this.field_22790 - 36, ModMenuConfig.COMPACT_LIST.getValue() ? 23 : 36, this.searchBox.method_1882(), this.modList, this);
        this.modList.method_25333(0);
        this.modList.reloadFilters();
        Objects.requireNonNull(this.field_22793);
        this.descriptionListWidget = new DescriptionListWidget(this.field_22787, this.paneWidth, this.field_22790, 108, this.field_22790 - 36, 9 + 1, this);
        this.descriptionListWidget.method_25333(this.rightPaneX);
        class_344 configureButton = new class_344(this.field_22789 - 24, 48, 20, 20, 0, 0, 20, CONFIGURE_BUTTON_LOCATION, 32, 64, button -> {
            String id = Objects.requireNonNull(this.selected).getMod().getId();
            if (this.modHasConfigScreen.get(id).booleanValue()) {
                class_437 configScreen = ModMenu.getConfigScreen(id, this);
                this.field_22787.method_1507(configScreen);
            } else {
                button.field_22763 = false;
            }
        }){

            public void method_25394(class_332 DrawContext, int mouseX, int mouseY, float delta) {
                String modId = ModsScreen.this.selected.getMod().getId();
                if (ModsScreen.this.selected != null) {
                    this.field_22763 = ModsScreen.this.modHasConfigScreen.get(modId);
                } else {
                    this.field_22763 = false;
                    this.field_22764 = false;
                }
                boolean bl = this.field_22764 = ModsScreen.this.selected != null && ModsScreen.this.modHasConfigScreen.get(modId) != false || ModsScreen.this.modScreenErrors.containsKey(modId);
                if (ModsScreen.this.modScreenErrors.containsKey(modId)) {
                    Throwable e = ModsScreen.this.modScreenErrors.get(modId);
                    this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"modmenu.configure.error", (Object[])new Object[]{modId, modId}).method_27661().method_27693("\n\n").method_27693(e.toString()).method_27692(class_124.field_1061)));
                } else {
                    this.method_47400(class_7919.method_47407((class_2561)CONFIGURE));
                }
                super.method_25394(DrawContext, mouseX, mouseY, delta);
            }

            public void method_48579(class_332 DrawContext, int mouseX, int mouseY, float delta) {
                RenderSystem.setShader(class_757::method_34543);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.method_48579(DrawContext, mouseX, mouseY, delta);
            }
        };
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        class_4185 websiteButton = new class_4185(this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, 84, Math.min(urlButtonWidths, 200), 20, (class_2561)class_2561.method_43471((String)"modmenu.website"), button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            this.field_22787.method_1507((class_437)new class_407(bool -> {
                if (bool) {
                    class_156.method_668().method_670(mod.getWebsite());
                }
                this.field_22787.method_1507((class_437)this);
            }, mod.getWebsite(), false));
        }, Supplier::get){

            public void method_25394(class_332 DrawContext, int mouseX, int mouseY, float delta) {
                this.field_22764 = ModsScreen.this.selected != null;
                this.field_22763 = this.field_22764 && ModsScreen.this.selected.getMod().getWebsite() != null;
                super.method_25394(DrawContext, mouseX, mouseY, delta);
            }
        };
        class_4185 issuesButton = new class_4185(this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, 84, Math.min(urlButtonWidths, 200), 20, (class_2561)class_2561.method_43471((String)"modmenu.issues"), button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            this.field_22787.method_1507((class_437)new class_407(bool -> {
                if (bool) {
                    class_156.method_668().method_670(mod.getIssueTracker());
                }
                this.field_22787.method_1507((class_437)this);
            }, mod.getIssueTracker(), false));
        }, Supplier::get){

            public void method_25394(class_332 DrawContext, int mouseX, int mouseY, float delta) {
                this.field_22764 = ModsScreen.this.selected != null;
                this.field_22763 = this.field_22764 && ModsScreen.this.selected.getMod().getIssueTracker() != null;
                super.method_25394(DrawContext, mouseX, mouseY, delta);
            }
        };
        this.method_25429((class_364)this.searchBox);
        class_344 filtersButton = new class_344(this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22, 20, 20, 0, 0, 20, FILTERS_BUTTON_LOCATION, 32, 64, button -> {
            this.filterOptionsShown = !this.filterOptionsShown;
        }, TOGGLE_FILTER_OPTIONS);
        filtersButton.method_47400(class_7919.method_47407((class_2561)TOGGLE_FILTER_OPTIONS));
        if (!ModMenuConfig.CONFIG_MODE.getValue()) {
            this.method_37063((class_364)filtersButton);
        }
        class_2561 showLibrariesText = ModMenuConfig.SHOW_LIBRARIES.getButtonText();
        class_2561 sortingText = ModMenuConfig.SORTING.getButtonText();
        int showLibrariesWidth = this.field_22793.method_27525((class_5348)showLibrariesText) + 20;
        int sortingWidth = this.field_22793.method_27525((class_5348)sortingText) + 20;
        this.filtersWidth = showLibrariesWidth + sortingWidth + 2;
        this.searchRowWidth = this.searchBoxX + searchBoxWidth + 22;
        this.updateFiltersX();
        this.method_37063((class_364)new class_4185(this.filtersX, 45, sortingWidth, 20, sortingText, button -> {
            ModMenuConfig.SORTING.cycleValue();
            ModMenuConfigManager.save();
            this.modList.reloadFilters();
        }, Supplier::get){

            public void method_25394(class_332 DrawContext, int mouseX, int mouseY, float delta) {
                DrawContext.method_51448().method_46416(0.0f, 0.0f, 1.0f);
                this.field_22764 = ModsScreen.this.filterOptionsShown;
                this.method_25355(ModMenuConfig.SORTING.getButtonText());
                super.method_25394(DrawContext, mouseX, mouseY, delta);
            }
        });
        this.method_37063((class_364)new class_4185(this.filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, showLibrariesText, button -> {
            ModMenuConfig.SHOW_LIBRARIES.toggleValue();
            ModMenuConfigManager.save();
            this.modList.reloadFilters();
        }, Supplier::get){

            public void method_25394(class_332 DrawContext, int mouseX, int mouseY, float delta) {
                DrawContext.method_51448().method_46416(0.0f, 0.0f, 1.0f);
                this.field_22764 = ModsScreen.this.filterOptionsShown;
                this.method_25355(ModMenuConfig.SHOW_LIBRARIES.getButtonText());
                super.method_25394(DrawContext, mouseX, mouseY, delta);
            }
        });
        this.method_25429((class_364)this.modList);
        if (!ModMenuConfig.HIDE_CONFIG_BUTTONS.getValue()) {
            this.method_37063((class_364)configureButton);
        }
        this.method_37063((class_364)websiteButton);
        this.method_37063((class_364)issuesButton);
        this.method_25429((class_364)this.descriptionListWidget);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"modmenu.modsFolder"), button -> class_156.method_668().method_672(new File(FabricLoader.getInstance().getGameDir().toFile(), "mods"))).method_46433(this.field_22789 / 2 - 154, this.field_22790 - 28).method_46437(150, 20).method_46435(Supplier::get).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.field_22787.method_1507(this.previousScreen)).method_46433(this.field_22789 / 2 + 4, this.field_22790 - 28).method_46437(150, 20).method_46435(Supplier::get).method_46431());
        this.searchBox.method_25365(true);
        this.init = true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers) || this.searchBox.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int keyCode) {
        return this.searchBox.method_25400(chr, keyCode);
    }

    public void method_25394(class_332 DrawContext, int mouseX, int mouseY, float delta) {
        this.method_25434(DrawContext);
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.method_25394(DrawContext, mouseX, mouseY, delta);
        }
        this.modList.method_25394(DrawContext, mouseX, mouseY, delta);
        this.searchBox.method_25394(DrawContext, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        DrawContext.method_27534(this.field_22793, this.field_22785, this.modList.getWidth() / 2, 8, 0xFFFFFF);
        if (!ModMenuConfig.DISABLE_DRAG_AND_DROP.getValue()) {
            class_5250 class_52502 = class_2561.method_43471((String)"modmenu.dropInfo.line1").method_27692(class_124.field_1080);
            int n = this.field_22789 - this.modList.getWidth() / 2;
            Objects.requireNonNull(this.field_22787.field_1772);
            DrawContext.method_27534(this.field_22793, (class_2561)class_52502, n, 24 - 9 - 1, 0xFFFFFF);
            DrawContext.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"modmenu.dropInfo.line2").method_27692(class_124.field_1080), this.field_22789 - this.modList.getWidth() / 2, 25, 0xFFFFFF);
        }
        if (!ModMenuConfig.CONFIG_MODE.getValue()) {
            class_2561 fullModCount = this.computeModCountText(true);
            if (!ModMenuConfig.CONFIG_MODE.getValue() && this.updateFiltersX()) {
                if (this.filterOptionsShown) {
                    if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.field_22793.method_27525((class_5348)fullModCount) <= this.filtersX - 5) {
                        DrawContext.method_51430(this.field_22793, fullModCount.method_30937(), this.searchBoxX, 52, 0xFFFFFF, false);
                    } else {
                        DrawContext.method_51430(this.field_22793, this.computeModCountText(false).method_30937(), this.searchBoxX, 46, 0xFFFFFF, false);
                        DrawContext.method_51430(this.field_22793, this.computeLibraryCountText().method_30937(), this.searchBoxX, 57, 0xFFFFFF, false);
                    }
                } else if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.field_22793.method_27525((class_5348)fullModCount) <= this.modList.getWidth() - 5) {
                    DrawContext.method_51430(this.field_22793, fullModCount.method_30937(), this.searchBoxX, 52, 0xFFFFFF, false);
                } else {
                    DrawContext.method_51430(this.field_22793, this.computeModCountText(false).method_30937(), this.searchBoxX, 46, 0xFFFFFF, false);
                    DrawContext.method_51430(this.field_22793, this.computeLibraryCountText().method_30937(), this.searchBoxX, 57, 0xFFFFFF, false);
                }
            }
        }
        if (selectedEntry != null) {
            List<String> names;
            class_5250 name;
            Mod mod = selectedEntry.getMod();
            int x = this.rightPaneX;
            if ("java".equals(mod.getId())) {
                DrawingUtil.drawRandomVersionBackground(mod, DrawContext, x, 48, 32, 32);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            DrawContext.method_25290(this.selected.getIconTexture(), x, 48, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
            Objects.requireNonNull(this.field_22793);
            int lineSpacing = 9 + 1;
            int imageOffset = 36;
            class_5250 trimmedName = name = class_2561.method_43470((String)mod.getTranslatedName());
            int maxNameWidth = this.field_22789 - (x + imageOffset);
            if (this.field_22793.method_27525((class_5348)name) > maxNameWidth) {
                class_5348 ellipsis = class_5348.method_29430((String)"...");
                trimmedName = class_5348.method_29433((class_5348[])new class_5348[]{this.field_22793.method_1714((class_5348)name, maxNameWidth - this.field_22793.method_27525(ellipsis)), ellipsis});
            }
            DrawContext.method_51430(this.field_22793, class_2477.method_10517().method_30934((class_5348)trimmedName), x + imageOffset, 49, 0xFFFFFF, false);
            if (mouseX > x + imageOffset && mouseY > 49) {
                Objects.requireNonNull(this.field_22793);
                if (mouseY < 49 + 9 && mouseX < x + imageOffset + this.field_22793.method_27525((class_5348)trimmedName)) {
                    this.method_47415((class_2561)class_2561.method_43469((String)"modmenu.modIdToolTip", (Object[])new Object[]{mod.getId()}));
                }
            }
            if (this.init || this.modBadgeRenderer == null || this.modBadgeRenderer.getMod() != mod) {
                this.modBadgeRenderer = new ModBadgeRenderer(x + imageOffset + this.field_22787.field_1772.method_27525((class_5348)trimmedName) + 2, 48, this.field_22789 - 28, selectedEntry.mod, this);
                this.init = false;
            }
            if (!ModMenuConfig.HIDE_BADGES.getValue()) {
                this.modBadgeRenderer.draw(DrawContext, mouseX, mouseY);
            }
            if (mod.isReal()) {
                DrawContext.method_51433(this.field_22793, mod.getPrefixedVersion(), x + imageOffset, 50 + lineSpacing, 0x808080, false);
            }
            if (!(names = mod.getAuthors()).isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : names.get(0);
                DrawingUtil.drawWrappedString(DrawContext, class_1074.method_4662((String)"modmenu.authorPrefix", (Object[])new Object[]{authors}), x + imageOffset, 50 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
        }
        super.method_25394(DrawContext, mouseX, mouseY, delta);
    }

    private class_2561 computeModCountText(boolean includeLibs) {
        int[] rootMods = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && !mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
        if (includeLibs && ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingModsLibraries", rootMods, rootLibs);
        }
        return TranslationUtil.translateNumeric("modmenu.showingMods", new int[][]{rootMods});
    }

    private class_2561 computeLibraryCountText() {
        if (ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingLibraries", new int[][]{rootLibs});
        }
        return class_2561.method_43470(null);
    }

    private int[] formatModCount(Set<String> set) {
        int total;
        int visible = this.modList.getDisplayedCountFor(set);
        if (visible == (total = set.size())) {
            return new int[]{total};
        }
        return new int[]{visible, total};
    }

    public void method_25419() {
        this.modList.close();
        this.field_22787.method_1507(this.previousScreen);
    }

    public ModListEntry getSelectedEntry() {
        return this.selected;
    }

    public void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            this.selected = entry;
        }
    }

    public double getScrollPercent() {
        return this.scrollPercent;
    }

    public void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.method_1882();
    }

    private boolean updateFiltersX() {
        if (this.filtersWidth + this.field_22793.method_27525((class_5348)this.computeModCountText(true)) + 20 >= this.searchRowWidth && (this.filtersWidth + this.field_22793.method_27525((class_5348)this.computeModCountText(false)) + 20 >= this.searchRowWidth || this.filtersWidth + this.field_22793.method_27525((class_5348)this.computeLibraryCountText()) + 20 >= this.searchRowWidth)) {
            this.filtersX = this.paneWidth / 2 - this.filtersWidth / 2;
            return !this.filterOptionsShown;
        }
        this.filtersX = this.searchRowWidth - this.filtersWidth + 1;
        return true;
    }

    public void method_29638(List<Path> paths) {
        Path modsDirectory = FabricLoader.getInstance().getGameDir().resolve("mods");
        List mods = paths.stream().filter(ModsScreen::isFabricMod).collect(Collectors.toList());
        if (mods.isEmpty()) {
            return;
        }
        String modList = mods.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.field_22787.method_1507((class_437)new class_410(value -> {
            if (value) {
                boolean allSuccessful = true;
                for (Path path : mods) {
                    try {
                        Files.copy(path, modsDirectory.resolve(path.getFileName()), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to copy mod from {} to {}", (Object)path, (Object)modsDirectory.resolve(path.getFileName()));
                        class_370.method_29627((class_310)this.field_22787, (String)path.toString());
                        allSuccessful = false;
                        break;
                    }
                }
                if (allSuccessful) {
                    class_370.method_27024((class_374)this.field_22787.method_1566(), (class_370.class_371)class_370.class_371.field_2218, (class_2561)class_2561.method_43471((String)"modmenu.dropSuccessful.line1"), (class_2561)class_2561.method_43471((String)"modmenu.dropSuccessful.line2"));
                }
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)class_2561.method_43471((String)"modmenu.dropConfirm"), (class_2561)class_2561.method_43470((String)modList)));
    }

    private static boolean isFabricMod(Path mod) {
        boolean bl;
        JarFile jarFile = new JarFile(mod.toFile());
        try {
            bl = jarFile.getEntry("fabric.mod.json") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    public Map<String, Boolean> getModHasConfigScreen() {
        return this.modHasConfigScreen;
    }
}

