/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.anvil;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.IExtendableSmithingRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8059;
import org.jetbrains.annotations.Nullable;

public class SmithingRecipeCategory
extends AbstractRecipeCategory<class_8059>
implements IExtendableSmithingRecipeCategory {
    private final Map<Class<? extends class_8059>, ISmithingCategoryExtension<?>> extensions = new HashMap();

    public SmithingRecipeCategory(IGuiHelper guiHelper) {
        super(RecipeTypes.SMITHING, (class_2561)class_2246.field_16329.method_9518(), guiHelper.createDrawableItemLike((class_1935)class_2246.field_16329), 108, 28);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8059 recipe, IFocusGroup focuses) {
        ISmithingCategoryExtension<class_8059> extension = this.getExtension(recipe);
        if (extension == null) {
            return;
        }
        IRecipeSlotBuilder templateSlot = builder.addInputSlot(1, 6).setStandardSlotBackground();
        IRecipeSlotBuilder baseSlot = builder.addInputSlot(19, 6).setStandardSlotBackground();
        IRecipeSlotBuilder additionSlot = builder.addInputSlot(37, 6).setStandardSlotBackground();
        IRecipeSlotBuilder outputSlot = builder.addOutputSlot(91, 6).setStandardSlotBackground();
        extension.setTemplate(recipe, templateSlot);
        extension.setBase(recipe, baseSlot);
        extension.setAddition(recipe, additionSlot);
        extension.setOutput(recipe, outputSlot);
    }

    @Override
    public void onDisplayedIngredientsUpdate(class_8059 recipe, List<IRecipeSlotDrawable> recipeSlots, IFocusGroup focuses) {
        ISmithingCategoryExtension<class_8059> extension = this.getExtension(recipe);
        if (extension == null) {
            return;
        }
        IRecipeSlotDrawable templateSlot = recipeSlots.get(0);
        IRecipeSlotDrawable baseSlot = recipeSlots.get(1);
        IRecipeSlotDrawable additionSlot = recipeSlots.get(2);
        IRecipeSlotDrawable outputSlot = recipeSlots.get(3);
        extension.onDisplayedIngredientsUpdate(recipe, templateSlot, baseSlot, additionSlot, outputSlot, focuses);
    }

    @Override
    public void createRecipeExtras(IRecipeExtrasBuilder builder, class_8059 recipe, IFocusGroup focuses) {
        builder.addRecipeArrow().setPosition(61, 6);
    }

    @Override
    public boolean isHandled(class_8059 recipe) {
        ISmithingCategoryExtension extension = this.getExtension(recipe);
        return extension != null;
    }

    @Override
    public class_2960 getRegistryName(class_8059 recipe) {
        return recipe.method_8114();
    }

    @Override
    public <R extends class_8059> void addExtension(Class<? extends R> recipeClass, ISmithingCategoryExtension<R> extension) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        ErrorUtil.checkNotNull(extension, "extension");
        if (this.extensions.containsKey(recipeClass)) {
            throw new IllegalArgumentException("An extension has already been registered for: " + recipeClass);
        }
        this.extensions.put(recipeClass, extension);
    }

    @Nullable
    private <R extends class_8059> ISmithingCategoryExtension<? super R> getExtension(class_8059 recipe) {
        ISmithingCategoryExtension<?> extension = this.extensions.get(recipe.getClass());
        if (extension != null) {
            return extension;
        }
        for (Map.Entry<Class<class_8059>, ISmithingCategoryExtension<?>> e : this.extensions.entrySet()) {
            if (!e.getKey().isInstance(recipe)) continue;
            return e.getValue();
        }
        return null;
    }
}

