/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.entity;

import immersive_paintings.Config;
import immersive_paintings.Entities;
import immersive_paintings.Items;
import immersive_paintings.Main;
import immersive_paintings.ServerDataManager;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.compat.XercaPaintCompat;
import immersive_paintings.entity.AbstractImmersiveDecorationEntity;
import immersive_paintings.network.s2c.OpenGuiRequest;
import immersive_paintings.network.s2c.PaintingModifyMessage;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

public class ImmersivePaintingEntity
extends AbstractImmersiveDecorationEntity {
    private class_2960 motive = Main.locate("none");
    private class_2960 frame = Main.locate("none");
    private class_2960 material = Main.locate("none");
    private int width = 1;
    private int height = 1;

    public ImmersivePaintingEntity(class_1937 world, class_2338 pos, class_2350 direction, int rotation) {
        super(Entities.PAINTING.get(), world, pos);
        this.setFacing(direction, rotation);
    }

    public ImmersivePaintingEntity(class_1299<class_1297> type, class_1937 world) {
        super(type, world);
    }

    public ImmersivePaintingEntity(class_1299<?> painting, class_1937 world, class_2338 pos) {
        super(painting, world, pos);
    }

    @Override
    public int getWidthPixels() {
        return this.width * 16;
    }

    @Override
    public int getHeightPixels() {
        return this.height * 16;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        nbt.method_10582("Motive", this.motive.toString());
        nbt.method_10582("Frame", this.frame.toString());
        nbt.method_10582("Material", this.material.toString());
        super.method_5652(nbt);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        this.motive = new class_2960(nbt.method_10558("Motive"));
        this.frame = new class_2960(nbt.method_10558("Frame"));
        this.material = new class_2960(nbt.method_10558("Material"));
        this.updateMotiveDimensions();
        super.method_5749(nbt);
    }

    public class_1792 getDrop() {
        return Items.PAINTING.get();
    }

    @Override
    public void onBreak(@Nullable class_1297 entity) {
        if (!this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            return;
        }
        this.method_5783(class_3417.field_14809, 1.0f, 1.0f);
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            if (playerEntity.method_31549().field_7477) {
                return;
            }
        }
        this.method_5706((class_1935)this.getDrop());
    }

    @Override
    public void onPlace() {
        this.method_5783(class_3417.field_14875, 1.0f, 1.0f);
    }

    public void method_5808(double x, double y, double z, float yaw, float pitch) {
        this.method_5814(x, y, z);
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        class_2338 blockPos = this.attachmentPos.method_10081((class_2382)class_2338.method_49637((double)(x - this.method_23317()), (double)(y - this.method_23318()), (double)(z - this.method_23321())));
        this.method_5814(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }

    public void method_5837(class_3222 player) {
        ServerDataManager.playerRequestedImages(player);
        NetworkHandler.sendToPlayer(new PaintingModifyMessage(this), player);
        super.method_5837(player);
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)this.getDrop());
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)player;
            if (serverPlayerEntity.field_13974.method_14257() != class_1934.field_9216) {
                if (!XercaPaintCompat.interactWithPainting(this, player, hand)) {
                    Config config = Config.getInstance();
                    NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.EDITOR, this.method_5628(), config.minPaintingResolution, config.maxPaintingResolution, config.showOtherPlayersPaintings, config.uploadPermissionLevel), (class_3222)player);
                }
                return class_1269.field_21466;
            }
        }
        return class_1269.field_5811;
    }

    public class_2960 getMotive() {
        return this.motive;
    }

    public void setMotive(class_2960 motive) {
        this.motive = motive;
        this.updateMotiveDimensions();
        this.updateAttachmentPosition();
    }

    public void updateMotiveDimensions() {
        Painting painting = this.method_37908().field_9236 ? ClientPaintingManager.getPainting(this.motive) : ServerPaintingManager.getPainting(this.motive);
        if (painting != null) {
            this.width = painting.width;
            this.height = painting.height;
        }
    }

    public class_2960 getFrame() {
        return this.frame;
    }

    public void setFrame(class_2960 frame) {
        this.frame = frame;
    }

    public class_2960 getMaterial() {
        return this.material;
    }

    public void setMaterial(class_2960 material) {
        this.material = material;
    }

    public boolean isGraffiti() {
        return false;
    }
}

