/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.client.gui;

import immersive_paintings.Main;
import immersive_paintings.client.ClientUtils;
import immersive_paintings.client.gui.widget.CallbackCheckboxWidget;
import immersive_paintings.client.gui.widget.DefaultButtonWidget;
import immersive_paintings.client.gui.widget.IntegerSliderWidget;
import immersive_paintings.client.gui.widget.PaintingWidget;
import immersive_paintings.client.gui.widget.PercentageSliderWidget;
import immersive_paintings.client.gui.widget.TexturedButtonWidget;
import immersive_paintings.client.gui.widget.TooltipButtonWidget;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.entity.ImmersivePaintingEntity;
import immersive_paintings.network.LazyNetworkManager;
import immersive_paintings.network.c2s.PaintingDeleteRequest;
import immersive_paintings.network.c2s.PaintingModifyRequest;
import immersive_paintings.network.c2s.RegisterPaintingRequest;
import immersive_paintings.network.c2s.UploadPaintingRequest;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Frame;
import immersive_paintings.resources.FrameLoader;
import immersive_paintings.resources.Painting;
import immersive_paintings.util.FlowingText;
import immersive_paintings.util.ImageManipulations;
import immersive_paintings.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class ImmersivePaintingScreen
extends class_437 {
    private static final int SCREENSHOTS_PER_PAGE = 5;
    final int entityId;
    final int minResolution;
    final int maxResolution;
    final boolean showOtherPlayersPaintings;
    final int uploadPermissionLevel;
    public final ImmersivePaintingEntity entity;
    private String filteredString = "";
    private int filteredResolution = 0;
    private int filteredWidth = 0;
    private int filteredHeight = 0;
    private final List<class_2960> filteredPaintings = new ArrayList<class_2960>();
    private int selectionPage;
    private Page page;
    private class_4185 pageWidget;
    private final List<PaintingWidget> paintingWidgetList = new LinkedList<PaintingWidget>();
    private ByteImage currentImage;
    private static int currentImagePixelZoomCache = -1;
    private String currentImageName;
    private PixelatorSettings settings;
    private ByteImage pixelatedImage;
    private List<File> screenshots = List.of();
    private int screenshotPage;
    private class_2960 deletePainting;
    private class_2561 error;
    private boolean shouldReProcess;
    private static volatile boolean shouldUpload;
    final ExecutorService service = Executors.newFixedThreadPool(1);

    public ImmersivePaintingScreen(int entityId, int minResolution, int maxResolution, boolean showOtherPlayersPaintings, int uploadPermissionLevel) {
        super((class_2561)class_2561.method_43471((String)"item.immersive_paintings.painting"));
        ImmersivePaintingEntity painting;
        class_1297 class_12972;
        this.entityId = entityId;
        this.minResolution = minResolution;
        this.maxResolution = maxResolution;
        this.showOtherPlayersPaintings = showOtherPlayersPaintings;
        this.uploadPermissionLevel = uploadPermissionLevel;
        this.entity = class_310.method_1551().field_1687 != null && (class_12972 = class_310.method_1551().field_1687.method_8469(entityId)) instanceof ImmersivePaintingEntity ? (painting = (ImmersivePaintingEntity)class_12972) : null;
        if (this.entity == null) {
            this.method_25419();
        }
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.page == null) {
            this.setPage(Page.DATAPACKS);
        } else {
            this.refreshPage();
        }
        File file = new File(class_310.method_1551().field_1697, "screenshots");
        File[] files = file.listFiles(v -> v.getName().endsWith(".png"));
        if (files != null) {
            this.screenshots = Arrays.stream(files).toList();
        }
    }

    private void clearSearch() {
        this.filteredString = "";
        this.filteredResolution = 0;
        this.filteredWidth = 0;
        this.filteredHeight = 0;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        switch (this.page) {
            case NEW: {
                context.method_25294(this.field_22789 / 2 - 115, this.field_22790 / 2 - 68, this.field_22789 / 2 + 115, this.field_22790 / 2 - 41, 0x50000000);
                List<class_2561> wrap = FlowingText.wrap((class_2561)class_2561.method_43471((String)"immersive_paintings.drop"), 220);
                int y = this.field_22790 / 2 - 40 - wrap.size() * 12;
                for (class_2561 text : wrap) {
                    context.method_27534(this.field_22793, text, this.field_22789 / 2, y, -1);
                    y += 12;
                }
                break;
            }
            case CREATE: {
                if (this.shouldReProcess && this.currentImage != null) {
                    Runnable task = () -> {
                        this.pixelatedImage = ImmersivePaintingScreen.pixelateImage(this.currentImage, this.settings);
                        shouldUpload = true;
                    };
                    this.service.submit(task);
                    this.shouldReProcess = false;
                }
                if (shouldUpload && this.pixelatedImage != null) {
                    class_310.method_1551().method_1531().method_4616(Main.locate("temp_pixelated"), (class_1044)new class_1043(ClientUtils.byteImageToNativeImage(this.pixelatedImage)));
                }
                int maxWidth = 190;
                int maxHeight = 135;
                int tw = this.settings.resolution * this.settings.width;
                int th = this.settings.resolution * this.settings.height;
                float size = Math.min((float)maxWidth / (float)tw, (float)maxHeight / (float)th);
                class_4587 matrices = context.method_51448();
                matrices.method_22903();
                matrices.method_46416((float)this.field_22789 / 2.0f - (float)tw * size / 2.0f, (float)this.field_22790 / 2.0f - (float)th * size / 2.0f, 0.0f);
                matrices.method_22905(size, size, 1.0f);
                context.method_25290(Main.locate("temp_pixelated"), 0, 0, 0.0f, 0.0f, tw, th, tw, th);
                matrices.method_22909();
                if (this.error == null) break;
                context.method_27534(this.field_22793, this.error, this.field_22789 / 2, this.field_22790 / 2, -65536);
                break;
            }
            case DELETE: {
                context.method_25294(this.field_22789 / 2 - 160, this.field_22790 / 2 - 50, this.field_22789 / 2 + 160, this.field_22790 / 2 + 50, -2013265920);
                List<class_2561> wrap = FlowingText.wrap((class_2561)class_2561.method_43471((String)"immersive_paintings.confirm_deletion"), 300);
                int y = this.field_22790 / 2 - 35;
                for (class_2561 t : wrap) {
                    context.method_27534(this.field_22793, t, this.field_22789 / 2, y, 0xFFFFFF);
                    y += 15;
                }
                break;
            }
            case ADMIN_DELETE: {
                context.method_25294(this.field_22789 / 2 - 160, this.field_22790 / 2 - 50, this.field_22789 / 2 + 160, this.field_22790 / 2 + 50, -2013265920);
                List<class_2561> wrap = FlowingText.wrap((class_2561)class_2561.method_43471((String)"immersive_paintings.confirm_admin_deletion"), 300);
                int y = this.field_22790 / 2 - 35;
                for (class_2561 t : wrap) {
                    context.method_27534(this.field_22793, t, this.field_22789 / 2, y, 0xFFFFFF);
                    y += 15;
                }
                break;
            }
            case LOADING: {
                class_5250 text = class_2561.method_43469((String)"immersive_paintings.upload", (Object[])new Object[]{(int)Math.ceil(LazyNetworkManager.getRemainingTime())});
                context.method_27534(this.field_22793, (class_2561)text, this.field_22789 / 2, this.field_22790 / 2, -1);
            }
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private List<class_2960> getMaterialsList() {
        return FrameLoader.frames.values().stream().filter(v -> v.frame().equals((Object)this.entity.getFrame())).map(Frame::material).distinct().sorted(class_2960::method_12833).toList();
    }

    private void rebuild() {
        int x;
        this.method_37067();
        if (this.page != Page.CREATE) {
            LinkedList<Page> b2 = new LinkedList<Page>();
            b2.add(Page.YOURS);
            b2.add(Page.DATAPACKS);
            if (this.showOtherPlayersPaintings || this.isOp()) {
                b2.add(Page.PLAYERS);
            }
            if (class_310.method_1551().field_1724 == null || class_310.method_1551().field_1724.method_5687(this.uploadPermissionLevel)) {
                b2.add(Page.NEW);
            }
            if (!this.entity.isGraffiti()) {
                b2.add(Page.FRAME);
            }
            x = this.field_22789 / 2 - 200;
            int w = 400 / b2.size();
            for (Page page : b2) {
                ((DefaultButtonWidget)this.method_37063((class_364)new DefaultButtonWidget((int)x, (int)(this.field_22790 / 2 - 90 - 22), (int)w, (int)20, (class_2561)class_2561.method_43471((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"immersive_paintings.page.\u0001"}, (String)page.name().toLowerCase((Locale)Locale.ROOT)))), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$rebuild$3(immersive_paintings.client.gui.ImmersivePaintingScreen$Page net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((ImmersivePaintingScreen)this, (Page)page)))).field_22763 = page != this.page;
                x += w;
            }
        }
        switch (this.page) {
            case NEW: {
                class_342 textFieldWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 90, this.field_22790 / 2 - 38, 180, 16, (class_2561)class_2561.method_43470((String)"URL")));
                textFieldWidget.method_1880(1024);
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 - 50, this.field_22790 / 2 - 15, 100, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.load"), sender -> this.loadImage(textFieldWidget.method_1882())));
                this.rebuildScreenshots();
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 - 65, this.field_22790 / 2 + 70, 30, 20, (class_2561)class_2561.method_43470((String)"<<"), sender -> this.setScreenshotPage(this.screenshotPage - 1)));
                this.pageWidget = (class_4185)this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 - 65 + 30, this.field_22790 / 2 + 70, 70, 20, (class_2561)class_2561.method_43470((String)""), sender -> {}));
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 - 65 + 100, this.field_22790 / 2 + 70, 30, 20, (class_2561)class_2561.method_43470((String)">>"), sender -> this.setScreenshotPage(this.screenshotPage + 1)));
                this.setScreenshotPage(this.screenshotPage);
                break;
            }
            case CREATE: {
                class_342 textFieldWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 90, this.field_22790 / 2 - 100, 180, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.name")));
                textFieldWidget.method_1880(256);
                textFieldWidget.method_1852(this.currentImageName);
                textFieldWidget.method_1863(s -> {
                    this.currentImageName = s;
                });
                int y = this.field_22790 / 2 - 60;
                this.method_37063((class_364)new IntegerSliderWidget(this.field_22789 / 2 - 200, y, 100, 20, "immersive_paintings.width", this.settings.width, 1, 16, v -> {
                    this.settings.width = v;
                    this.shouldReProcess = true;
                }));
                this.method_37063((class_364)new IntegerSliderWidget(this.field_22789 / 2 - 200, y += 22, 100, 20, "immersive_paintings.height", this.settings.height, 1, 16, v -> {
                    this.settings.height = v;
                    this.shouldReProcess = true;
                }));
                int x2 = this.field_22789 / 2 - 200;
                TooltipButtonWidget widget = (TooltipButtonWidget)this.method_37063((class_364)new TooltipButtonWidget(x2 + 25, y += 22, 50, 20, (class_2561)class_2561.method_43470((String)String.valueOf(this.settings.resolution)), (class_2561)class_2561.method_43471((String)"immersive_paintings.tooltip.resolution"), v -> {}));
                this.method_37063((class_364)new TooltipButtonWidget(x2, y, 25, 20, (class_2561)class_2561.method_43470((String)"<"), (class_2561)class_2561.method_43471((String)"immersive_paintings.tooltip.resolution"), v -> {
                    this.settings.resolution = Math.max(this.minResolution, this.settings.resolution / 2);
                    if (this.settings.pixelArt) {
                        this.adaptToPixelArt();
                        this.refreshPage();
                    }
                    this.shouldReProcess = true;
                    widget.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.settings.resolution)));
                }));
                this.method_37063((class_364)new TooltipButtonWidget(x2 + 75, y, 25, 20, (class_2561)class_2561.method_43470((String)">"), (class_2561)class_2561.method_43471((String)"immersive_paintings.tooltip.resolution"), v -> {
                    this.settings.resolution = Math.min(this.maxResolution, this.settings.resolution * 2);
                    if (this.settings.pixelArt) {
                        this.adaptToPixelArt();
                        this.refreshPage();
                    }
                    this.shouldReProcess = true;
                    widget.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.settings.resolution)));
                }));
                y += 22;
                ((IntegerSliderWidget)this.method_37063((class_364)new IntegerSliderWidget((int)(this.field_22789 / 2 - 200), (int)(y += 10), (int)100, (int)20, (String)"immersive_paintings.colors", (double)((double)this.settings.colors), (int)1, (int)25, (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$14(java.lang.Integer ), (Ljava/lang/Integer;)V)((ImmersivePaintingScreen)this)))).field_22763 = !this.settings.pixelArt;
                ((PercentageSliderWidget)this.method_37063((class_364)new PercentageSliderWidget((int)(this.field_22789 / 2 - 200), (int)(y += 22), (int)100, (int)20, (String)"immersive_paintings.dither", (double)this.settings.dither, (Consumer<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$15(java.lang.Double ), (Ljava/lang/Double;)V)((ImmersivePaintingScreen)this)))).field_22763 = !this.settings.pixelArt;
                y = this.field_22790 / 2 - 50;
                this.method_37063((class_364)new CallbackCheckboxWidget(this.field_22789 / 2 + 100, y, 20, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.pixelart"), (class_2561)class_2561.method_43471((String)"immersive_paintings.pixelart.tooltip"), this.settings.pixelArt, true, b -> {
                    this.settings.pixelArt = b;
                    this.adaptToPixelArt();
                    this.refreshPage();
                    this.shouldReProcess = true;
                }));
                this.method_37063((class_364)new CallbackCheckboxWidget(this.field_22789 / 2 + 100, y += 22, 100, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.hide"), (class_2561)class_2561.method_43471((String)"immersive_paintings.visibility"), this.settings.hidden, true, v -> {
                    this.settings.hidden = !this.settings.hidden;
                }));
                this.method_37063((class_364)new PercentageSliderWidget(this.field_22789 / 2 + 100, y += 22, 100, 20, "immersive_paintings.x_offset", this.settings.offsetX, v -> {
                    this.settings.offsetX = v;
                    this.shouldReProcess = true;
                }));
                this.method_37063((class_364)new PercentageSliderWidget(this.field_22789 / 2 + 100, y += 22, 100, 20, "immersive_paintings.y_offset", this.settings.offsetY, v -> {
                    this.settings.offsetY = v;
                    this.shouldReProcess = true;
                }));
                ((PercentageSliderWidget)this.method_37063((class_364)new PercentageSliderWidget((int)(this.field_22789 / 2 + 100), (int)(y += 22), (int)100, (int)20, (String)"immersive_paintings.zoom", (double)this.settings.zoom, (double)(this.entity.isGraffiti() ? 0.5 : 1.0), (double)(this.entity.isGraffiti() ? 1.5 : 3.0), (Consumer<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$20(java.lang.Double ), (Ljava/lang/Double;)V)((ImmersivePaintingScreen)this)))).field_22763 = !this.settings.pixelArt;
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 - 85, this.field_22790 / 2 + 75, 80, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.cancel"), v -> this.setPage(Page.NEW)));
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 + 5, this.field_22790 / 2 + 75, 80, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.save"), v -> {
                    Utils.processByteArrayInChunks(this.pixelatedImage.encode(), (TriConsumer<byte[], Integer, Integer>)((TriConsumer)(ints, split, splits) -> LazyNetworkManager.sendToServer(new UploadPaintingRequest((byte[])ints, (int)split, (int)splits))));
                    LazyNetworkManager.sendToServer(new RegisterPaintingRequest(this.currentImageName, new Painting(this.pixelatedImage, this.settings.width, this.settings.height, this.settings.resolution, this.settings.hidden, this.entity.isGraffiti())));
                    this.setPage(Page.LOADING);
                }));
                break;
            }
            case YOURS: 
            case DATAPACKS: 
            case PLAYERS: {
                this.rebuildPaintings();
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 - 35 - 30, this.field_22790 / 2 + 80, 30, 20, (class_2561)class_2561.method_43470((String)"<<"), sender -> this.setSelectionPage(this.selectionPage - 1)));
                this.pageWidget = (class_4185)this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 - 35, this.field_22790 / 2 + 80, 70, 20, (class_2561)class_2561.method_43470((String)""), sender -> {}));
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 + 35, this.field_22790 / 2 + 80, 30, 20, (class_2561)class_2561.method_43470((String)">>"), sender -> this.setSelectionPage(this.selectionPage + 1)));
                this.setSelectionPage(this.selectionPage);
                class_342 textFieldWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 65, this.field_22790 / 2 - 88, 130, 16, (class_2561)class_2561.method_43471((String)"immersive_paintings.search")));
                textFieldWidget.method_1880(64);
                textFieldWidget.method_1887("search");
                textFieldWidget.method_1863(s -> {
                    this.filteredString = s;
                    this.updateSearch();
                    textFieldWidget.method_1887(null);
                });
                x = this.field_22789 / 2 - 200 + 12;
                class_4185 widget = (class_4185)this.method_37063((class_364)new TooltipButtonWidget(x + 50 + 8, this.field_22790 / 2 - 90, 25, 20, (class_2561)class_2561.method_43470((String)String.valueOf(this.filteredResolution)), (class_2561)class_2561.method_43471((String)"immersive_paintings.tooltip.filter_resolution"), v -> {}));
                TooltipButtonWidget allWidget = (TooltipButtonWidget)this.method_37063((class_364)new TooltipButtonWidget(x, this.field_22790 / 2 - 90, 25, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.filter.all"), (class_2561)class_2561.method_43471((String)"immersive_paintings.tooltip.filter_resolution"), v -> {
                    this.filteredResolution = 0;
                    this.updateSearch();
                    widget.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.filteredResolution)));
                    v.field_22763 = false;
                }));
                this.method_37063((class_364)new TooltipButtonWidget(x + 25 + 8, this.field_22790 / 2 - 90, 25, 20, (class_2561)class_2561.method_43470((String)"<"), (class_2561)class_2561.method_43471((String)"immersive_paintings.tooltip.filter_resolution"), v -> {
                    this.filteredResolution = this.filteredResolution == 0 ? 32 : Math.max(this.minResolution, this.filteredResolution / 2);
                    this.updateSearch();
                    widget.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.filteredResolution)));
                    allWidget.field_22763 = true;
                }));
                this.method_37063((class_364)new TooltipButtonWidget(x + 75 + 8, this.field_22790 / 2 - 90, 25, 20, (class_2561)class_2561.method_43470((String)">"), (class_2561)class_2561.method_43471((String)"immersive_paintings.tooltip.filter_resolution"), v -> {
                    this.filteredResolution = this.filteredResolution == 0 ? 32 : Math.min(this.maxResolution, this.filteredResolution * 2);
                    this.updateSearch();
                    widget.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.filteredResolution)));
                    allWidget.field_22763 = true;
                }));
                class_342 widthWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 + 80, this.field_22790 / 2 - 88, 40, 16, (class_2561)class_2561.method_43471((String)"immersive_paintings.filter_width")));
                widthWidget.method_1880(2);
                widthWidget.method_1887("width");
                widthWidget.method_1863(s -> {
                    try {
                        this.filteredWidth = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ignored) {
                        this.filteredWidth = 0;
                    }
                    this.updateSearch();
                    widthWidget.method_1887(null);
                });
                class_342 heightWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 + 80 + 40, this.field_22790 / 2 - 88, 40, 16, (class_2561)class_2561.method_43471((String)"immersive_paintings.filter_height")));
                heightWidget.method_1880(2);
                heightWidget.method_1887("height");
                heightWidget.method_1863(s -> {
                    try {
                        this.filteredHeight = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ignored) {
                        this.filteredHeight = 0;
                    }
                    this.updateSearch();
                    heightWidget.method_1887(null);
                });
                break;
            }
            case FRAME: {
                int y = this.field_22790 / 2 - 80;
                List<class_2960> frames = FrameLoader.frames.values().stream().map(Frame::frame).distinct().sorted(class_2960::method_12833).toList();
                for (class_2960 frame : frames) {
                    class_4185 widget = (class_4185)this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 - 200, y, 100, 20, (class_2561)class_2561.method_43471((String)("immersive_paintings.frame." + Utils.identifierToTranslation(frame))), v -> {
                        this.entity.setFrame(frame);
                        this.entity.setMaterial(this.getMaterialsList().get(0));
                        NetworkHandler.sendToServer(new PaintingModifyRequest(this.entity));
                        this.setPage(Page.FRAME);
                    }));
                    widget.field_22763 = !frame.equals((Object)this.entity.getFrame());
                    y += 25;
                }
                int py = 0;
                int px = 0;
                List<class_2960> materials = this.getMaterialsList();
                LinkedList<class_4185> materialList = new LinkedList<class_4185>();
                for (class_2960 material : materials) {
                    class_4185 widget = (class_4185)this.method_37063((class_364)new TexturedButtonWidget(this.field_22789 / 2 - 80 + px * 65, this.field_22790 / 2 - 80 + py * 20, 64, 16, new class_2960(material.method_12836(), material.method_12832().replace("/block/", "/gui/")), 0, 0, 64, 32, (class_2561)class_2561.method_43470((String)""), v -> {
                        this.entity.setMaterial(material);
                        NetworkHandler.sendToServer(new PaintingModifyRequest(this.entity));
                        materialList.forEach(b -> {
                            b.field_22763 = true;
                        });
                        v.field_22763 = false;
                    }, () -> class_7919.method_47406((class_310)class_310.method_1551(), (class_2561)class_2561.method_43471((String)("immersive_paintings.material." + Utils.identifierToTranslation(material))))));
                    widget.field_22763 = !material.equals((Object)this.entity.getMaterial());
                    materialList.add(widget);
                    if (++px <= 3) continue;
                    px = 0;
                    ++py;
                }
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 - 50, this.field_22790 / 2 + 70, 100, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.done"), v -> this.method_25419()));
                break;
            }
            case DELETE: {
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 - 100 - 5, this.field_22790 / 2 + 20, 100, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.cancel"), v -> this.setPage(Page.YOURS)));
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 + 5, this.field_22790 / 2 + 20, 100, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.delete"), v -> {
                    NetworkHandler.sendToServer(new PaintingDeleteRequest(this.deletePainting));
                    this.setPage(Page.YOURS);
                }));
                break;
            }
            case ADMIN_DELETE: {
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 - 115, this.field_22790 / 2 + 10, 70, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.cancel"), v -> this.setPage(Page.PLAYERS)));
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 - 40, this.field_22790 / 2 + 10, 70, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.delete"), v -> {
                    NetworkHandler.sendToServer(new PaintingDeleteRequest(this.deletePainting));
                    this.setPage(Page.PLAYERS);
                }));
                this.method_37063((class_364)new DefaultButtonWidget(this.field_22789 / 2 + 35, this.field_22790 / 2 + 10, 70, 20, (class_2561)class_2561.method_43471((String)"immersive_paintings.delete_all"), v -> {
                    String author = ClientPaintingManager.getPainting((class_2960)this.deletePainting).author;
                    ClientPaintingManager.getPaintings().entrySet().stream().filter(p -> Objects.equals(((Painting)p.getValue()).author, author) && !((Painting)p.getValue()).datapack).map(Map.Entry::getKey).forEach(p -> NetworkHandler.sendToServer(new PaintingDeleteRequest((class_2960)p)));
                    this.setPage(Page.PLAYERS);
                }));
            }
        }
    }

    private void rebuildPaintings() {
        for (PaintingWidget w : this.paintingWidgetList) {
            this.method_37066((class_364)w);
        }
        this.paintingWidgetList.clear();
        for (int y = 0; y < 3; ++y) {
            int i;
            for (int x = 0; x < 8 && (i = y * 8 + x + this.selectionPage * 24) >= 0 && i < this.filteredPaintings.size(); ++x) {
                class_2960 identifier = this.filteredPaintings.get(i);
                Painting painting = ClientPaintingManager.getPainting(identifier);
                LinkedList<class_5250> tooltip = new LinkedList<class_5250>();
                tooltip.add(class_2561.method_43470((String)painting.name));
                tooltip.add(class_2561.method_43469((String)"immersive_paintings.by_author", (Object[])new Object[]{painting.author}).method_27692(class_124.field_1056));
                tooltip.add(class_2561.method_43469((String)"immersive_paintings.resolution", (Object[])new Object[]{painting.width, painting.height, painting.resolution}).method_27692(class_124.field_1056));
                if (this.page == Page.YOURS && painting.hidden) {
                    tooltip.add(class_2561.method_43471((String)"immersive_paintings.hidden").method_27692(class_124.field_1056).method_27692(class_124.field_1080));
                }
                if (this.page == Page.YOURS || this.page == Page.PLAYERS && this.isOp()) {
                    tooltip.add(class_2561.method_43471((String)"immersive_paintings.right_click_to_delete").method_27692(class_124.field_1056).method_27692(class_124.field_1080));
                }
                this.paintingWidgetList.add((PaintingWidget)this.method_37063((class_364)new PaintingWidget(ClientPaintingManager.getPaintingTexture(identifier, Painting.Type.THUMBNAIL), (int)((double)this.field_22789 / 2.0 + ((double)x - 3.5) * 48.0) - 24, this.field_22790 / 2 - 66 + y * 48, 46, 46, sender -> {
                    this.entity.setMotive(identifier);
                    NetworkHandler.sendToServer(new PaintingModifyRequest(this.entity));
                    if (this.entity.isGraffiti()) {
                        this.method_25419();
                    } else {
                        this.setPage(Page.FRAME);
                    }
                }, b -> {
                    if (this.page == Page.YOURS) {
                        this.deletePainting = identifier;
                        this.setPage(Page.DELETE);
                    } else if (this.page == Page.PLAYERS && this.isOp()) {
                        this.deletePainting = identifier;
                        this.setPage(Page.ADMIN_DELETE);
                    }
                }, () -> tooltip.stream().map(class_2561::method_30937).toList())));
            }
        }
    }

    private void rebuildScreenshots() {
        int i;
        for (PaintingWidget w : this.paintingWidgetList) {
            this.method_37066((class_364)w);
        }
        this.paintingWidgetList.clear();
        for (int x = 0; x < 5 && (i = x + this.screenshotPage * 5) >= 0 && i < this.screenshots.size(); ++x) {
            File file = this.screenshots.get(i);
            Painting painting = new Painting(null, 16, 16, 16, false, this.entity.isGraffiti());
            this.paintingWidgetList.add((PaintingWidget)this.method_37063((class_364)new PaintingWidget(painting.thumbnail, this.field_22789 / 2 + (x - 2) * 68 - 32, this.field_22790 / 2 + 15, 64, 48, b -> {
                this.currentImage = ((PaintingWidget)b).thumbnail.image;
                if (this.currentImage != null) {
                    currentImagePixelZoomCache = -1;
                    this.currentImageName = file.getName();
                    this.settings = new PixelatorSettings(this.currentImage);
                    this.setPage(Page.CREATE);
                    this.pixelateImage();
                }
            }, b -> {}, () -> class_7919.method_47406((class_310)class_310.method_1551(), (class_2561)class_2561.method_43470((String)file.getName())))));
            class_2960 identifier = Main.locate("screenshot_" + x);
            Runnable task = () -> {
                ByteImage image = this.loadImage(file.getPath(), identifier);
                if (image != null) {
                    painting.width = image.getWidth();
                    painting.height = image.getHeight();
                    painting.thumbnail.image = image;
                    painting.thumbnail.textureIdentifier = identifier;
                }
            };
            this.service.submit(task);
        }
    }

    public void setPage(Page page) {
        if (page != this.page) {
            this.clearSearch();
        }
        this.page = page;
        this.filteredResolution = page == Page.DATAPACKS ? 32 : 0;
        this.rebuild();
        if (page == Page.DATAPACKS || page == Page.PLAYERS || page == Page.YOURS) {
            this.updateSearch();
        }
    }

    private void updateSearch() {
        this.filteredPaintings.clear();
        String playerName = this.getPlayerName();
        this.filteredPaintings.addAll(ClientPaintingManager.getPaintings().entrySet().stream().filter(v -> ((Painting)v.getValue()).graffiti == this.entity.isGraffiti()).filter(v -> this.page != Page.YOURS || Objects.equals(((Painting)v.getValue()).author, playerName) && !((Painting)v.getValue()).datapack).filter(v -> this.page != Page.PLAYERS || !((Painting)v.getValue()).datapack && (!((Painting)v.getValue()).hidden || this.isOp())).filter(v -> this.page != Page.DATAPACKS || ((Painting)v.getValue()).datapack).filter(v -> ((class_2960)v.getKey()).toString().contains(this.filteredString)).filter(v -> this.filteredResolution == 0 || ((Painting)v.getValue()).resolution == this.filteredResolution).filter(v -> this.filteredWidth == 0 || ((Painting)v.getValue()).width == this.filteredWidth).filter(v -> this.filteredHeight == 0 || ((Painting)v.getValue()).height == this.filteredHeight).map(Map.Entry::getKey).toList());
        this.setSelectionPage(this.selectionPage);
    }

    private String getPlayerName() {
        return class_310.method_1551().field_1724 == null ? "" : class_310.method_1551().field_1724.method_7334().getName();
    }

    private boolean isOp() {
        return class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_5687(4);
    }

    private void setSelectionPage(int p) {
        this.selectionPage = Math.min(this.getMaxPages() - 1, Math.max(0, p));
        this.rebuildPaintings();
        this.pageWidget.method_25355((class_2561)class_2561.method_43470((String)(this.selectionPage + 1 + " / " + this.getMaxPages())));
    }

    private int getMaxPages() {
        return (int)Math.ceil((double)this.filteredPaintings.size() / 24.0);
    }

    private void setScreenshotPage(int p) {
        int oldPage = this.screenshotPage;
        this.screenshotPage = Math.min(this.getScreenshotMaxPages() - 1, Math.max(0, p));
        if (oldPage != this.screenshotPage) {
            this.rebuildScreenshots();
        }
        this.pageWidget.method_25355((class_2561)class_2561.method_43470((String)(this.screenshotPage + 1 + " / " + this.getScreenshotMaxPages())));
    }

    private int getScreenshotMaxPages() {
        return (int)Math.ceil((double)this.screenshots.size() / 8.0);
    }

    public void method_29638(List<Path> paths) {
        Path path = paths.get(0);
        this.loadImage(path.toString());
    }

    private void loadImage(String path) {
        this.currentImage = this.loadImage(path, Main.locate("temp"));
        currentImagePixelZoomCache = -1;
        if (this.currentImage != null) {
            this.currentImageName = FilenameUtils.getBaseName((String)path).replaceFirst("[.][^.]+$", "");
            this.settings = new PixelatorSettings(this.currentImage);
            this.setPage(Page.CREATE);
            this.pixelateImage();
        }
    }

    private ByteImage loadImage(String path, class_2960 identifier) {
        InputStream stream = null;
        try {
            stream = new URL(path).openStream();
        }
        catch (Exception exception) {
            try {
                stream = new FileInputStream(path);
            }
            catch (Exception e) {
                Main.LOGGER.error((Object)e);
            }
        }
        if (stream != null) {
            try {
                ByteImage nativeImage = ByteImage.read(stream);
                this.preprocessImage(nativeImage);
                class_310.method_1551().method_1531().method_4616(identifier, (class_1044)new class_1043(ClientUtils.byteImageToNativeImage(nativeImage)));
                stream.close();
                return nativeImage;
            }
            catch (IOException e) {
                Main.LOGGER.error((Object)e);
            }
        }
        return null;
    }

    private void preprocessImage(ByteImage image) {
        this.clearError();
        if (!this.entity.isGraffiti()) {
            byte[] bytes = image.getBytes();
            for (int i = 3; i < bytes.length; i += 4) {
                if (bytes[i] == -1) continue;
                if (this.error == null) {
                    this.setError((class_2561)class_2561.method_43471((String)"immersive_paintings.graffiti_warning"));
                }
                bytes[i] = -1;
            }
        }
    }

    private static int getCurrentImagePixelZoomCache(ByteImage currentImage) {
        if (currentImagePixelZoomCache < 0) {
            currentImagePixelZoomCache = ImageManipulations.scanForPixelArtMultiple(currentImage);
        }
        return currentImagePixelZoomCache;
    }

    private void pixelateImage() {
        this.pixelatedImage = ImmersivePaintingScreen.pixelateImage(this.currentImage, this.settings);
        shouldUpload = true;
    }

    private void adaptToPixelArt() {
        double zoom = ImmersivePaintingScreen.getCurrentImagePixelZoomCache(this.currentImage);
        this.settings.width = Math.max(1, Math.min(16, (int)((double)this.currentImage.getWidth() / zoom / (double)this.settings.resolution)));
        this.settings.height = Math.max(1, Math.min(16, (int)((double)this.currentImage.getHeight() / zoom / (double)this.settings.resolution)));
    }

    public static ByteImage pixelateImage(ByteImage currentImage, PixelatorSettings settings) {
        double zoom;
        ByteImage pixelatedImage = new ByteImage(settings.resolution * settings.width, settings.resolution * settings.height);
        if (settings.pixelArt) {
            zoom = ImmersivePaintingScreen.getCurrentImagePixelZoomCache(currentImage);
        } else {
            float fx = (float)currentImage.getWidth() / (float)pixelatedImage.getWidth();
            float fy = (float)currentImage.getHeight() / (float)pixelatedImage.getHeight();
            zoom = (double)Math.min(fx, fy) / settings.zoom;
        }
        int ox = (int)(((double)currentImage.getWidth() - (double)pixelatedImage.getWidth() * zoom) * settings.offsetX);
        int oy = (int)(((double)currentImage.getHeight() - (double)pixelatedImage.getHeight() * zoom) * settings.offsetY);
        if (settings.pixelArt) {
            ox = ox / (int)zoom * (int)zoom;
            oy = oy / (int)zoom * (int)zoom;
        }
        ImageManipulations.resize(pixelatedImage, currentImage, zoom, ox, oy);
        if (settings.dither > 0.0 && !settings.pixelArt) {
            if (settings.colors > 1) {
                ImageManipulations.dither(pixelatedImage, settings.dither / (double)settings.colors);
            } else {
                ImageManipulations.dither(pixelatedImage, settings.dither / 16.0);
            }
        }
        if (settings.colors > 1 && !settings.pixelArt) {
            ImageManipulations.reduceColors(pixelatedImage, settings.colors);
        }
        return pixelatedImage;
    }

    public void refreshPage() {
        this.setPage(this.page);
    }

    public void clearError() {
        this.error = null;
    }

    public void setError(class_2561 text) {
        this.error = text;
    }

    private /* synthetic */ void lambda$rebuild$20(Double v) {
        this.settings.zoom = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$15(Double v) {
        this.settings.dither = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$14(Integer v) {
        this.settings.colors = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$3(Page page, class_4185 sender) {
        this.setPage(page);
    }

    public static enum Page {
        YOURS,
        DATAPACKS,
        PLAYERS,
        NEW,
        CREATE,
        FRAME,
        DELETE,
        ADMIN_DELETE,
        LOADING;

    }

    public static final class PixelatorSettings {
        public double dither;
        public int colors;
        public int resolution;
        public int width;
        public int height;
        public double offsetX;
        public double offsetY;
        public double zoom;
        public boolean pixelArt;
        public boolean hidden;

        public PixelatorSettings(double dither, int colors, int resolution, int width, int height, double offsetX, double offsetY, double zoom, boolean pixelArt) {
            this.dither = dither;
            this.colors = colors;
            this.resolution = resolution;
            this.width = width;
            this.height = height;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.zoom = zoom;
            this.pixelArt = pixelArt;
        }

        PixelatorSettings(ByteImage currentImage) {
            this(0.25, 10, 32, 1, 1, 0.5, 0.5, 1.0, false);
            double target = (double)currentImage.getWidth() / (double)currentImage.getHeight();
            double bestScore = 100.0;
            double d = Math.sqrt(currentImage.getWidth() * currentImage.getWidth() + currentImage.getHeight() * currentImage.getHeight());
            double dw = (double)currentImage.getWidth() / d;
            double dh = (double)currentImage.getHeight() / d;
            for (double diagonal = 3.0; diagonal < 6.0; diagonal += target) {
                int ph;
                int pw = (int)Math.ceil(dw * diagonal);
                double e = Math.abs((double)pw / (double)(ph = (int)Math.ceil(dh * diagonal)) - target) * Math.sqrt(5 + this.width + this.height);
                if (!(e < bestScore)) continue;
                this.width = Math.max(1, Math.min(16, pw));
                this.height = Math.max(1, Math.min(16, ph));
                bestScore = e;
            }
        }
    }
}

